/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class AppClientServerConfiguration {
    private AppClientServerConfiguration() {
    }

    public static List<ModelNode> serverConfiguration(String filePath, String deploymentName, String hostUrl, List<String> parameters, List<ModelNode> xmlNodes) {
        ArrayList<ModelNode> ret = new ArrayList<ModelNode>();
        for (ModelNode node : xmlNodes) {
            List address;
            if (node.getType() == ModelType.OBJECT && node.get("operation").asString().equals("add") && (address = node.get("address").asList()).size() == 1 && ((ModelNode)address.get(0)).asProperty().getName().equals("subsystem")) {
                node.get("appclient").set(true);
            }
            ret.add(node);
        }
        AppClientServerConfiguration.appclient(ret, filePath, deploymentName, hostUrl, parameters);
        return ret;
    }

    private static void appclient(List<ModelNode> nodes, String filePath, String deploymentName, String hostUrl, List<String> parameters) {
        AppClientServerConfiguration.loadExtension(nodes, "org.jboss.as.appclient");
        ModelNode add = new ModelNode();
        add.get("address").set(new ModelNode().setEmptyList()).add("subsystem", "appclient");
        add.get("operation").set("add");
        add.get("file").set(filePath);
        if (deploymentName != null) {
            add.get("deployment").set(deploymentName);
        }
        if (parameters.isEmpty()) {
            add.get("parameters").addEmptyList();
        } else {
            for (String param : parameters) {
                add.get("parameters").add(param);
            }
        }
        add.get("host-url").set(hostUrl);
        nodes.add(add);
    }

    private static void loadExtension(List<ModelNode> nodes, String moduleName) {
        ModelNode add = new ModelNode();
        add.get("address").set(new ModelNode().setEmptyList()).add("extension", moduleName);
        add.get("operation").set("add");
        nodes.add(add);
    }
}

