/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.util.HashSet;
import java.util.Set;

public class Domain {
    private Set<Server> servers = new HashSet<Server>();
    private Set<ServerGroup> serverGroups = new HashSet<ServerGroup>();

    public void addServer(Server server) {
        this.servers.add(server);
    }

    public void addServerGroup(ServerGroup group) {
        this.serverGroups.add(group);
    }

    public Set<Server> getServers() {
        return this.servers;
    }

    public Set<ServerGroup> getServerGroups() {
        return this.serverGroups;
    }

    public Set<String> getHosts() {
        HashSet<String> unique = new HashSet<String>();
        for (Server server : this.servers) {
            unique.add(server.host);
        }
        return unique;
    }

    public Set<Server> getServersInGroup(ServerGroup group) {
        return this.getServersInGroup(group.getName());
    }

    public Set<Server> getServersInGroup(String group) {
        HashSet<Server> unique = new HashSet<Server>();
        for (Server server : this.servers) {
            if (!group.equals(server.group)) continue;
            unique.add(server);
        }
        return unique;
    }

    public Set<Server> getAutoStartServers() {
        HashSet<Server> auto = new HashSet<Server>();
        for (Server server : this.servers) {
            if (!server.autostart) continue;
            auto.add(server);
        }
        return auto;
    }

    public static class Server {
        private String name;
        private String containerName;
        private String host;
        private String group;
        private boolean autostart = false;

        public Server(String name, String host, String group, boolean autostart) {
            if (name == null || host == null) {
                throw new IllegalArgumentException("Server name and host can not be null. name[" + name + "], host[" + host + "]");
            }
            this.name = name;
            this.host = host;
            this.group = group;
            this.autostart = autostart;
        }

        public String getGroup() {
            return this.group;
        }

        public String getHost() {
            return this.host;
        }

        public String getName() {
            return this.name;
        }

        public String getUniqueName() {
            return this.host + ":" + this.name;
        }

        public String getContainerName() {
            if (this.containerName != null) {
                return this.containerName;
            }
            return this.getUniqueName();
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public boolean isAutostart() {
            return this.autostart;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
            result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Server other = (Server)obj;
            if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return "[host=" + this.host + ", name=" + this.name + ", group=" + this.group + ", containerName=" + this.getContainerName() + "]";
        }
    }

    public static class ServerGroup {
        private String name;
        private String containerName;

        public ServerGroup(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Name must be specified");
            }
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getContainerName() {
            if (this.containerName != null) {
                return this.containerName;
            }
            return this.getName();
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ServerGroup other = (ServerGroup)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String toString() {
            return "ServerGroup [name=" + this.name + ", containerName=" + this.getContainerName() + "]";
        }
    }
}

