/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import org.jboss.arquillian.spi.DeploymentPackager;
import org.jboss.arquillian.spi.TestDeployment;
import org.jboss.as.arquillian.container.ManifestUtils;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class JBossASDeploymentPackager
implements DeploymentPackager {
    private static final Set<String> excludedAuxillaryArchives = new HashSet<String>();

    public Archive<?> generateDeployment(TestDeployment testDeployment) {
        Manifest manifest = ManifestUtils.getOrCreateManifest(testDeployment.getApplicationArchive());
        Archive appArchive = testDeployment.getApplicationArchive();
        Collection auxArchives = testDeployment.getAuxiliaryArchives();
        if (BundleInfo.isValidateBundleManifest((Manifest)manifest)) {
            this.merge(appArchive, auxArchives);
        } else if (appArchive instanceof WebArchive) {
            ArchivePath webInfLib = ArchivePaths.create((String)"WEB-INF", (String)"lib");
            for (Archive aux : auxArchives) {
                if (excludedAuxillaryArchives.contains(aux.getName())) continue;
                appArchive.add(aux, webInfLib);
            }
        } else {
            this.merge(appArchive, auxArchives);
        }
        return appArchive;
    }

    private void merge(Archive<?> appArchive, Collection<Archive<?>> auxArchives) {
        for (Archive<?> aux : auxArchives) {
            if (excludedAuxillaryArchives.contains(aux.getName())) continue;
            appArchive.merge(aux);
        }
    }

    static {
        excludedAuxillaryArchives.add("arquillian-core.jar");
        excludedAuxillaryArchives.add("arquillian-junit.jar");
    }
}

