/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.common;

import java.io.InputStream;
import java.util.concurrent.Future;
import org.jboss.arquillian.api.ArchiveDeployer;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;

public final class ArchiveDeployerImpl
implements ArchiveDeployer {
    private ServerDeploymentManager deploymentManager;

    public ArchiveDeployerImpl(ServerDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public String deploy(Archive<?> archive) throws Exception {
        InputStream input = ((ZipExporter)archive.as(ZipExporter.class)).exportZip();
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        builder = builder.add(archive.getName(), input).andDeploy();
        DeploymentPlan plan = builder.build();
        DeploymentAction deployAction = builder.getLastAction();
        String runtimeName = this.executeDeploymentPlan(plan, deployAction);
        return runtimeName;
    }

    public void undeploy(String runtimeName) throws Exception {
        InitialDeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
        DeploymentPlan plan = builder.undeploy(runtimeName).remove(runtimeName).build();
        Future future = this.deploymentManager.execute(plan);
        future.get();
    }

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        Exception deploymentException;
        Future future = this.deploymentManager.execute(plan);
        ServerDeploymentPlanResult planResult = (ServerDeploymentPlanResult)future.get();
        ServerDeploymentActionResult actionResult = planResult.getDeploymentActionResult(deployAction.getId());
        if (actionResult != null && (deploymentException = (Exception)actionResult.getDeploymentException()) != null) {
            throw deploymentException;
        }
        return deployAction.getDeploymentUnitUniqueName();
    }
}

