/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.ArchiveDeployer;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.modules.management.ObjectProperties;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.management.ServiceContainerMXBean;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.util.NotImplementedException;

public abstract class CommonDeployableContainer<T extends CommonContainerConfiguration>
implements DeployableContainer<T> {
    protected static final ObjectName OBJECT_NAME;
    private T containerConfig;
    private ModelControllerClient modelControllerClient;
    @Inject
    @ContainerScoped
    private InstanceProducer<ArchiveDeployer> archiveDeployerInst;
    private final Map<Object, String> registry = new HashMap<Object, String>();

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-as7");
    }

    public void setup(T config) {
        this.containerConfig = config;
        this.modelControllerClient = ModelControllerClient.Factory.create((InetAddress)((CommonContainerConfiguration)config).getBindAddress(), (int)((CommonContainerConfiguration)config).getManagementPort());
        ArchiveDeployer archiveDeployer = new ArchiveDeployer(ServerDeploymentManager.Factory.create((ModelControllerClient)this.modelControllerClient));
        this.archiveDeployerInst.set((Object)archiveDeployer);
    }

    public final void start() throws LifecycleException {
        this.startInternal();
    }

    protected abstract void startInternal() throws LifecycleException;

    public final void stop() throws LifecycleException {
        this.stopInternal();
    }

    protected abstract void stopInternal() throws LifecycleException;

    protected T getContainerConfiguration() {
        return this.containerConfig;
    }

    protected ModelControllerClient getModelControllerClient() {
        return this.modelControllerClient;
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        ArchiveDeployer archiveDeployer = (ArchiveDeployer)this.archiveDeployerInst.get();
        String runtimeName = archiveDeployer.deploy(archive);
        this.registry.put(archive, runtimeName);
        return new ProtocolMetaData();
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        String runtimeName = this.registry.remove(archive);
        if (runtimeName != null) {
            ArchiveDeployer archiveDeployer = (ArchiveDeployer)this.archiveDeployerInst.get();
            archiveDeployer.undeploy(runtimeName);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }

    protected abstract MBeanServerConnection getMBeanServerConnection();

    protected MBeanServerConnection getMBeanServerConnection(long timeout) {
        while (timeout > 0L) {
            try {
                return this.getMBeanServerConnection();
            }
            catch (Exception ex) {
                try {
                    Thread.sleep(100L);
                    timeout -= 100L;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new IllegalStateException("MBeanServerConnection not available");
    }

    protected void waitForMBean(ObjectName objectName, long timeout) {
        boolean mbeanAvailable = false;
        MBeanServerConnection mbeanServer = this.getMBeanServerConnection(timeout);
        while (timeout > 0L && !mbeanAvailable) {
            try {
                mbeanAvailable = mbeanServer.isRegistered(objectName);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (mbeanAvailable) continue;
            try {
                Thread.sleep(100L);
                timeout -= 100L;
            }
            catch (InterruptedException ex) {}
        }
        if (!mbeanAvailable) {
            throw new IllegalStateException("MBean not available: " + objectName);
        }
    }

    protected void waitForServiceState(ServiceName serviceName, ServiceController.State expectedState, long timeout) {
        ObjectName objectName = OBJECT_NAME;
        MBeanServerConnection mbeanServer = this.getMBeanServerConnection();
        ServiceContainerMXBean proxy = MBeanProxy.get(mbeanServer, objectName, ServiceContainerMXBean.class);
        ServiceController.State currentState = ServiceController.State.valueOf((String)proxy.getServiceStatus(serviceName.getCanonicalName()).getStateName());
        while (timeout > 0L && currentState != expectedState) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            timeout -= 100L;
            currentState = ServiceController.State.valueOf((String)proxy.getServiceStatus(serviceName.getCanonicalName()).getStateName());
        }
        if (currentState != expectedState) {
            throw new IllegalStateException("Unexpected state for [" + serviceName + "] - " + currentState);
        }
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("jboss.msc", (Hashtable<String, String>)ObjectProperties.properties((ObjectProperties.Property[])new ObjectProperties.Property[]{ObjectProperties.property((String)"type", (String)"container"), ObjectProperties.property((String)"name", (String)"jboss-as")}));
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    static class MBeanProxy {
        MBeanProxy() {
        }

        static <T> T get(MBeanServerConnection server, ObjectName name, Class<T> interf) {
            return MBeanServerInvocationHandler.newProxyInstance(server, name, interf, false);
        }
    }
}

