/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.Manifest;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.as.arquillian.container.ManifestUtils;
import org.jboss.as.arquillian.container.ModuleApplicationArchiveProcessor;
import org.jboss.as.arquillian.container.OSGiApplicationArchiveProcessor;
import org.jboss.logging.Logger;
import org.jboss.osgi.spi.util.BundleInfo;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;

public class DelegatingApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final Logger log = Logger.getLogger(DelegatingApplicationArchiveProcessor.class);

    public void process(Archive<?> appArchive, TestClass testClass) {
        Object archiveProcessor = this.isBundleArchive(testClass, appArchive) ? new OSGiApplicationArchiveProcessor() : new ModuleApplicationArchiveProcessor();
        log.debugf("Process archive '%s' with: %s", (Object)appArchive.getName(), archiveProcessor);
        archiveProcessor.process(appArchive, testClass);
        ArchivePath manifestPath = ArchivePaths.create((String)"META-INF/MANIFEST.MF");
        Node node = appArchive.get(manifestPath);
        if (node == null) {
            log.errorf("Cannot find manifest in: %s", (Object)appArchive.getName());
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                IOUtil.copy((InputStream)node.getAsset().openStream(), (OutputStream)baos);
            }
            catch (IOException ex) {
                // empty catch block
            }
            log.debugf("Manifest for %s: \n%s", (Object)appArchive.getName(), (Object)new String(baos.toByteArray()));
        }
    }

    private boolean isBundleArchive(TestClass testClass, Archive<?> appArchive) {
        Manifest manifest = ManifestUtils.getOrCreateManifest(appArchive);
        return BundleInfo.isValidBundleManifest((Manifest)manifest);
    }
}

