/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.JMXContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.as.arquillian.container.TunneledMBeanServerConnection;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class ManagementClient {
    private static final String SUBDEPLOYMENT = "subdeployment";
    private static final String WEB = "web";
    private static final String JMX = "jmx";
    private static final String NAME = "name";
    private static final String SERVLET = "servlet";
    private static final String POSTFIX_WEB = ".war";
    private static final String POSTFIX_EAR = ".ear";
    private final String mgmtAddress;
    private final ModelControllerClient client;
    private final Map<String, URI> subsystemURICache;
    private ModelNode rootNode = null;
    private MBeanServerConnection connection;
    private JMXConnector connector;

    public ManagementClient(ModelControllerClient client, String mgmtAddress) {
        if (client == null) {
            throw new IllegalArgumentException("Client must be specified");
        }
        this.client = client;
        this.mgmtAddress = mgmtAddress;
        this.subsystemURICache = new HashMap<String, URI>();
    }

    public ModelControllerClient getControllerClient() {
        return this.client;
    }

    public URI getSubSystemURI(String subsystem) {
        URI subsystemURI = this.subsystemURICache.get(subsystem);
        if (subsystemURI != null) {
            return subsystemURI;
        }
        subsystemURI = this.extractSubSystemURI(subsystem);
        this.subsystemURICache.put(subsystem, subsystemURI);
        return subsystemURI;
    }

    public ProtocolMetaData getDeploymentMetaData(String deploymentName) {
        URI webURI = this.getSubSystemURI(WEB);
        ProtocolMetaData metaData = new ProtocolMetaData();
        metaData.addContext((Object)new JMXContext(this.getConnection()));
        HTTPContext context = new HTTPContext(webURI.getHost(), webURI.getPort());
        metaData.addContext((Object)context);
        try {
            ModelNode deploymentNode = this.readResource(this.createDeploymentAddress(deploymentName));
            if (this.isWebArchive(deploymentName)) {
                this.extractWebArchiveContexts(context, deploymentNode);
            } else if (this.isEnterpriseArchive(deploymentName)) {
                this.extractEnterpriseArchiveContexts(context, deploymentNode);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return metaData;
    }

    public boolean isServerInRunningState() {
        try {
            ModelNode op = Util.getEmptyOperation((String)"read-attribute", (ModelNode)PathAddress.EMPTY_ADDRESS.toModelNode());
            op.get(NAME).set("server-state");
            ModelNode rsp = this.client.execute(op);
            return "success".equals(rsp.get("outcome").asString()) && !ControlledProcessState.State.STARTING.toString().equals(rsp.get("result").asString()) && !ControlledProcessState.State.STOPPING.toString().equals(rsp.get("result").asString());
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void close() {
        try {
            this.getControllerClient().close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close connection", e);
        }
        finally {
            if (this.connector != null) {
                try {
                    this.connector.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close JMX connection", e);
                }
            }
        }
    }

    private URI extractSubSystemURI(String subsystem) {
        try {
            if (this.rootNode == null) {
                this.readRootNode();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (WEB.equals(subsystem)) {
            String socketBinding = this.rootNode.get("subsystem").get(WEB).get("connector").get("http").get("socket-binding").asString();
            return this.getBinding(socketBinding);
        }
        if (JMX.equals(subsystem)) {
            String socketBinding = this.rootNode.get("subsystem").get(JMX).get("connector").get(JMX).get("registry-binding").asString();
            return this.getBinding(socketBinding);
        }
        throw new IllegalArgumentException("No handler for subsystem " + subsystem);
    }

    private void readRootNode() throws Exception {
        this.rootNode = this.readResource(new ModelNode());
    }

    private URI getBinding(String socketBinding) {
        try {
            String socketBindingGroupName = (String)this.rootNode.get("socket-binding-group").keys().iterator().next();
            ModelNode operation = new ModelNode();
            operation.get("address").get("socket-binding-group").set(socketBindingGroupName);
            operation.get("address").get("socket-binding").set(socketBinding);
            operation.get("operation").set("read-attribute");
            operation.get(NAME).set("bound-address");
            String ip = this.executeForResult(operation).asString();
            ModelNode portOp = new ModelNode();
            portOp.get("address").get("socket-binding-group").set(socketBindingGroupName);
            portOp.get("address").get("socket-binding").set(socketBinding);
            portOp.get("operation").set("read-attribute");
            portOp.get(NAME).set("bound-port");
            int port = this.executeForResult(portOp).asInt();
            return URI.create(socketBinding + "://" + ip + ":" + port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getInterface(String name) {
        ModelNode address = new ModelNode();
        address.add("interface", name);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-attribute");
        operation.get("address").set(address);
        operation.get(NAME).set("resolved-address");
        try {
            String ip = this.executeForResult(operation).asString();
            if ("0.0.0.0".equals(ip) || "0:0:0:0:0:0:0:0".equals(ip)) {
                return this.mgmtAddress;
            }
            return ip;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isEnterpriseArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_EAR);
    }

    private boolean isWebArchive(String deploymentName) {
        return deploymentName.endsWith(POSTFIX_WEB);
    }

    private ModelNode createDeploymentAddress(String deploymentName) {
        ModelNode address = new ModelNode();
        address.add("deployment", deploymentName);
        return address;
    }

    private void extractEnterpriseArchiveContexts(HTTPContext context, ModelNode deploymentNode) {
        if (deploymentNode.hasDefined(SUBDEPLOYMENT)) {
            for (ModelNode subdeployment : deploymentNode.get(SUBDEPLOYMENT).asList()) {
                String deploymentName = (String)subdeployment.keys().iterator().next();
                if (!this.isWebArchive(deploymentName)) continue;
                this.extractWebArchiveContexts(context, deploymentName, subdeployment.get(deploymentName));
            }
        }
    }

    private void extractWebArchiveContexts(HTTPContext context, ModelNode deploymentNode) {
        this.extractWebArchiveContexts(context, deploymentNode.get(NAME).asString(), deploymentNode);
    }

    private void extractWebArchiveContexts(HTTPContext context, String deploymentName, ModelNode deploymentNode) {
        ModelNode webSubSystem;
        ModelNode subsystem;
        if (deploymentNode.hasDefined("subsystem") && (subsystem = deploymentNode.get("subsystem")).hasDefined(WEB) && (webSubSystem = subsystem.get(WEB)).isDefined() && webSubSystem.hasDefined("context-root")) {
            String contextName = webSubSystem.get("context-root").asString();
            if (webSubSystem.hasDefined(SERVLET)) {
                for (ModelNode servletNode : webSubSystem.get(SERVLET).asList()) {
                    for (String servletName : servletNode.keys()) {
                        context.add(new Servlet(servletName, this.toContextName(contextName)));
                    }
                }
            }
            context.add(new Servlet("default", this.toContextName(contextName)));
        }
    }

    private String toContextName(String deploymentName) {
        String correctedName = deploymentName;
        if (correctedName.startsWith("/")) {
            correctedName = correctedName.substring(1);
        }
        if (correctedName.indexOf(".") != -1) {
            correctedName = correctedName.substring(0, correctedName.lastIndexOf("."));
        }
        return correctedName;
    }

    private ModelNode readResource(ModelNode address) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("recursive").set("true");
        operation.get("address").set(address);
        return this.executeForResult(operation);
    }

    private ModelNode executeForResult(ModelNode operation) throws Exception {
        ModelNode result = this.client.execute(operation);
        this.checkSuccessful(result, operation);
        return result.get("result");
    }

    private void checkSuccessful(ModelNode result, ModelNode operation) throws UnSuccessfulOperationException {
        if (!"success".equals(result.get("outcome").asString())) {
            throw new UnSuccessfulOperationException(result.get("failure-description").toString());
        }
    }

    private MBeanServerConnection getConnection() {
        if (this.connection == null) {
            this.connection = new TunneledMBeanServerConnection(this.client);
        }
        return this.connection;
    }

    private JMXServiceURL getRemoteJMXURL() {
        URI jmxURI = this.getSubSystemURI(JMX);
        try {
            return new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + jmxURI.getHost() + ":" + jmxURI.getPort() + "/jmxrmi");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create JMXServiceURL:" + this, e);
        }
    }

    private static class UnSuccessfulOperationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnSuccessfulOperationException(String message) {
            super(message);
        }
    }
}

