/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain.managed;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.domain.CommonDomainDeployableContainer;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.ManagementClient;
import org.jboss.as.arquillian.container.domain.managed.ManagedDomainContainerConfiguration;

public class ManagedDomainDeployableContainer
extends CommonDomainDeployableContainer<ManagedDomainContainerConfiguration> {
    private static final String CONFIG_PATH = "/domain/configuration/";
    private final Logger log = Logger.getLogger(ManagedDomainDeployableContainer.class.getName());
    private Thread shutdownThread;
    private Process process;

    public Class<ManagedDomainContainerConfiguration> getConfigurationClass() {
        return ManagedDomainContainerConfiguration.class;
    }

    protected void startInternal() throws LifecycleException {
        ManagedDomainContainerConfiguration config = (ManagedDomainContainerConfiguration)this.getContainerConfiguration();
        if (this.isServerRunning()) {
            if (config.isAllowConnectingToRunningServer()) {
                return;
            }
            this.failDueToRunning();
        }
        try {
            List<String> cmd = this.createCommandLine(config);
            this.log.info("Starting container with: " + cmd.toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            long startupTimeout = ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            long sleep = 1000L;
            while (timeout > 0L && !serverAvailable) {
                serverAvailable = this.getManagementClient().isDomainInRunningState();
                if (serverAvailable) continue;
                if (ManagedDomainDeployableContainer.processHasDied(proc)) break;
                Thread.sleep(sleep);
                timeout -= sleep;
                sleep = Math.max(sleep / 2L, 100L);
            }
            if (!serverAvailable) {
                this.destroyProcess();
                throw new TimeoutException(String.format("Managed Domain server was not started within [%d] s", config.getStartupTimeoutInSeconds()));
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    protected void waitForStart(Domain domain, ManagementClient client) throws LifecycleException {
        this.waitForAutoStartServersToStart(domain, client);
    }

    protected void stopInternal() throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                this.process.destroy();
                this.process.waitFor();
                this.process = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    private List<String> createCommandLine(ManagedDomainContainerConfiguration config) throws Exception {
        File modulesDir;
        String jbossHomeDir = config.getJbossHome();
        String modulesPath = config.getModulePath();
        if (modulesPath == null || modulesPath.isEmpty()) {
            modulesPath = jbossHomeDir + File.separatorChar + "modules";
        }
        if (!(modulesDir = new File(modulesPath)).isDirectory()) {
            throw new IllegalStateException("Cannot find: " + modulesDir);
        }
        String bundlesPath = modulesDir.getParent() + File.separator + "bundles";
        File bundlesDir = new File(bundlesPath);
        if (!bundlesDir.isDirectory()) {
            throw new IllegalStateException("Cannot find: " + bundlesDir);
        }
        String additionalJavaOpts = config.getJavaVmArguments();
        File modulesJar = new File(jbossHomeDir + File.separatorChar + "jboss-modules.jar");
        if (!modulesJar.exists()) {
            throw new IllegalStateException("Cannot find: " + modulesJar);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        String javaExec = config.getJavaHome() + File.separatorChar + "bin" + File.separatorChar + "java";
        if (config.getJavaHome().contains(" ")) {
            javaExec = "\"" + javaExec + "\"";
        }
        cmd.add(javaExec);
        if (additionalJavaOpts != null) {
            for (String opt : additionalJavaOpts.split("\\s+")) {
                cmd.add(opt);
            }
        }
        if (config.isEnableAssertions()) {
            cmd.add("-ea");
        }
        cmd.add("-Djboss.home.dir=" + jbossHomeDir);
        cmd.add("-Dorg.jboss.boot.log.file=" + jbossHomeDir + "/domain/log/process-controller.log");
        cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + CONFIG_PATH + "logging.properties");
        cmd.add("-Djboss.bundles.dir=" + bundlesDir.getCanonicalPath());
        cmd.add("-Djboss.domain.default.config=" + config.getDomainConfig());
        cmd.add("-Djboss.host.default.config=" + config.getHostConfig());
        cmd.add("-jar");
        cmd.add(modulesJar.getAbsolutePath());
        cmd.add("-mp");
        cmd.add(modulesPath);
        cmd.add("org.jboss.as.process-controller");
        cmd.add("-jboss-home");
        cmd.add(jbossHomeDir);
        cmd.add("-jvm");
        cmd.add(javaExec);
        cmd.add("--");
        cmd.add("-Dorg.jboss.boot.log.file=" + jbossHomeDir + "/domain/log/host-controller.log");
        cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + CONFIG_PATH + "logging.properties");
        cmd.add("--");
        cmd.add("-default-jvm");
        cmd.add(javaExec);
        return cmd;
    }

    private static boolean processHasDied(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerRunning() {
        Socket socket = null;
        try {
            socket = new Socket(((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getManagementAddress(), ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getManagementPort());
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close isServerStarted socket", e);
                }
            }
        }
        return true;
    }

    private void failDueToRunning() throws LifecycleException {
        throw new LifecycleException("The server is already running! Managed containers does not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration");
    }

    private int destroyProcess() {
        if (this.process == null) {
            return 0;
        }
        this.process.destroy();
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void waitForAutoStartServersToStart(Domain domain, ManagementClient client) {
        long timeout;
        Set servers = domain.getAutoStartServers();
        long startupTimeout = ((ManagedDomainContainerConfiguration)this.getContainerConfiguration()).getAutoServerStartupTimeoutInSeconds();
        long sleep = 100L;
        for (timeout = startupTimeout * 1000L; timeout > 0L && servers.size() > 0; timeout -= sleep) {
            Iterator serverIterator = servers.iterator();
            while (serverIterator.hasNext()) {
                Domain.Server server = (Domain.Server)serverIterator.next();
                if (!client.isServerStarted(server)) continue;
                serverIterator.remove();
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed waiting for servers to start", e);
            }
        }
        if (timeout <= 0L) {
            throw new RuntimeException("Auto started servers did not start within set timeout [autoServerStartupTimeoutInSeconds=" + startupTimeout + "]. " + servers);
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = ManagedDomainDeployableContainer.this.process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            boolean writeOutput = ((ManagedDomainContainerConfiguration)ManagedDomainDeployableContainer.this.getContainerConfiguration()).isOutputToConsole();
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    if (!writeOutput) continue;
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

