/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;

public class ManagedContainerConfiguration
extends CommonContainerConfiguration {
    private String jbossHome = System.getenv("JBOSS_HOME");
    private String javaHome = System.getenv("JAVA_HOME");
    private String modulePath = System.getProperty("module.path");
    private String javaVmArguments = System.getProperty("jboss.options", "-Xmx512m -XX:MaxPermSize=128m");
    private int startupTimeoutInSeconds = 30;
    private boolean outputToConsole = true;
    private String serverConfig = System.getProperty("jboss.server.config.file.name", "standalone.xml");
    private boolean allowConnectingToRunningServer = false;

    public void validate() throws ConfigurationException {
        super.validate();
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)("jbossHome '" + this.jbossHome + "' must exist"));
        if (this.javaHome != null) {
            Validate.configurationDirectoryExists((String)this.javaHome, (String)"javaHome must exist");
        }
    }

    public String getJbossHome() {
        return this.jbossHome;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public void setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
    }
}

