/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.internal.AbstractOSGiMetaData;

class OSGiManifestMetaData
extends AbstractOSGiMetaData
implements Externalizable {
    private Manifest manifest;

    public OSGiManifestMetaData() {
    }

    OSGiManifestMetaData(Manifest manifest) {
        if (manifest == null) {
            throw new IllegalArgumentException("Null manifest");
        }
        this.manifest = manifest;
    }

    @Override
    public Map<Attributes.Name, String> getMainAttributes() {
        return this.manifest.getMainAttributes();
    }

    @Override
    public String getMainAttribute(String key) {
        return this.manifest.getMainAttributes().getValue(key);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        OutputWrapper os = new OutputWrapper(out);
        this.manifest.write(os);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        InputWrapper is = new InputWrapper(in);
        this.manifest = new Manifest(is);
    }

    class InputWrapper
    extends InputStream {
        private ObjectInput in;

        public InputWrapper(ObjectInput in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }
    }

    class OutputWrapper
    extends OutputStream {
        private ObjectOutput out;

        public OutputWrapper(ObjectOutput out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

