/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata.internal;

import java.util.StringTokenizer;
import org.jboss.osgi.metadata.VersionRange;
import org.osgi.framework.Version;

public class AbstractVersionRange
implements VersionRange {
    public static AbstractVersionRange valueOf(String rangeSpec) {
        return AbstractVersionRange.parseRangeSpec(rangeSpec);
    }

    public static AbstractVersionRange parseRangeSpec(String rangeSpec) {
        if (rangeSpec == null) {
            throw new IllegalArgumentException("Null rangeSpec");
        }
        if (rangeSpec.startsWith("\"") && rangeSpec.endsWith("\"")) {
            rangeSpec = rangeSpec.substring(1, rangeSpec.length() - 1);
        }
        Version floor = null;
        Version ceiling = null;
        StringTokenizer st = new StringTokenizer(rangeSpec, ",[]()", true);
        Boolean floorIsGreaterThan = null;
        Boolean ceilingIsLessThan = null;
        boolean mid = false;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("[")) {
                floorIsGreaterThan = false;
                continue;
            }
            if (token.equals("(")) {
                floorIsGreaterThan = true;
                continue;
            }
            if (token.equals("]")) {
                ceilingIsLessThan = false;
                continue;
            }
            if (token.equals(")")) {
                ceilingIsLessThan = true;
                continue;
            }
            if (token.equals(",")) {
                mid = true;
                continue;
            }
            if (token.equals("\"")) continue;
            if (floor == null) {
                floor = new Version(token);
                continue;
            }
            ceiling = new Version(token);
        }
        if (floorIsGreaterThan == null || ceilingIsLessThan == null) {
            if (mid) {
                throw new IllegalArgumentException("Missing parenthesis: " + rangeSpec);
            }
            floorIsGreaterThan = false;
            ceilingIsLessThan = false;
        }
        return new AbstractVersionRange(floor, ceiling, floorIsGreaterThan, ceilingIsLessThan);
    }

    public AbstractVersionRange(Version floor, Version ceiling, boolean floorIsLessThan, boolean ceilingIsLessThan) {
    }

    @Override
    public Version getFloor() {
        return null;
    }

    @Override
    public Version getCeiling() {
        return null;
    }

    @Override
    public boolean isInRange(Version v) {
        return false;
    }
}

