/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.framework.bundle.AbstractBundleContext;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.bundle.BundleWrapper;
import org.jboss.osgi.framework.bundle.ServiceState;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugin.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.framework.plugin.ResolverPlugin;
import org.jboss.osgi.framework.plugin.ServiceManagerPlugin;
import org.jboss.osgi.metadata.CaseInsensitiveDictionary;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public abstract class AbstractBundle
implements Bundle {
    private static final Logger log = Logger.getLogger(AbstractBundle.class);
    private final BundleManager bundleManager;
    private final String symbolicName;
    private final long bundleId;
    private final BundleStorageState storageState;
    private final AtomicInteger bundleState = new AtomicInteger(1);
    private final List<AbstractRevision> revisions = new CopyOnWriteArrayList<AbstractRevision>();
    private BundleWrapper bundleWrapper;
    private AbstractBundleContext bundleContext;
    private final CopyOnWriteArrayList<ServiceState> registeredServices = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<ServiceState, AtomicInteger> usedServices = new ConcurrentHashMap();
    private final FrameworkEventsPlugin eventsPlugin;
    private final LifecycleInterceptorPlugin interceptorPlugin;
    private final ResolverPlugin resolverPlugin;
    private final ModuleManagerPlugin moduleManager;
    private final ServiceManagerPlugin serviceManager;

    AbstractBundle(BundleManager bundleManager, String symbolicName, BundleStorageState storageState) {
        if (bundleManager == null) {
            throw new IllegalArgumentException("Null bundleManager");
        }
        if (symbolicName == null) {
            throw new IllegalArgumentException("Null symbolicName");
        }
        if (storageState == null) {
            throw new IllegalArgumentException("Null storageState");
        }
        if (symbolicName.indexOf(59) > 0) {
            symbolicName = symbolicName.substring(0, symbolicName.indexOf(59));
        }
        this.bundleManager = bundleManager;
        this.symbolicName = symbolicName;
        this.storageState = storageState;
        this.bundleId = storageState.getBundleId();
        this.eventsPlugin = bundleManager.getPlugin(FrameworkEventsPlugin.class);
        this.interceptorPlugin = bundleManager.getPlugin(LifecycleInterceptorPlugin.class);
        this.moduleManager = bundleManager.getPlugin(ModuleManagerPlugin.class);
        this.resolverPlugin = bundleManager.getPlugin(ResolverPlugin.class);
        this.serviceManager = bundleManager.getPlugin(ServiceManagerPlugin.class);
    }

    public static AbstractBundle assertBundleState(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (bundle instanceof BundleWrapper) {
            bundle = ((BundleWrapper)bundle).getBundleState();
        }
        if (!(bundle instanceof AbstractBundle)) {
            throw new IllegalArgumentException("Not an AbstractBundle: " + bundle);
        }
        return (AbstractBundle)bundle;
    }

    public abstract boolean isFragment();

    public abstract boolean ensureResolved();

    abstract AbstractBundleContext createContextInternal();

    public abstract List<XModule> getAllResolverModules();

    public BundleContext getBundleContext() {
        return this.bundleContext != null ? this.bundleContext.getContextWrapper() : null;
    }

    BundleContext getBundleContextInternal() {
        return this.bundleContext;
    }

    BundleContext createBundleContext() {
        if (this.bundleContext != null) {
            throw new IllegalStateException("BundleContext already available");
        }
        this.bundleContext = this.createContextInternal();
        return this.bundleContext;
    }

    void destroyBundleContext() {
        this.bundleContext.destroy();
        this.bundleContext = null;
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public BundleManager getBundleManager() {
        return this.bundleManager;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getCanonicalName() {
        return this.getSymbolicName() + ":" + this.getVersion();
    }

    public BundleStorageState getBundleStorageState() {
        return this.storageState;
    }

    public long getLastModified() {
        return this.storageState.getLastModified();
    }

    void updateLastModified() {
        this.storageState.updateLastModified();
    }

    public boolean isResolved() {
        return this.getResolverModule().isResolved();
    }

    public boolean isUninstalled() {
        return this.getState() == 1;
    }

    public void addToResolver() {
        XModule resModule = this.getResolverModule();
        this.resolverPlugin.addModule(resModule);
    }

    public void removeFromResolver() {
        for (AbstractRevision abr : this.getRevisions()) {
            XModule resModule = abr.getResolverModule();
            this.resolverPlugin.removeModule(resModule);
        }
    }

    boolean hasActiveWires() {
        XModule resModule = this.getResolverModule();
        if (!resModule.isResolved()) {
            return false;
        }
        for (XCapability cap : resModule.getCapabilities()) {
            Set wiredReqs = cap.getWiredRequirements();
            for (XRequirement req : wiredReqs) {
                Bundle bundle = (Bundle)req.getModule().getAttachment(Bundle.class);
                AbstractBundle importer = AbstractBundle.assertBundleState(bundle);
                if (importer.getState() == 1) continue;
                return true;
            }
        }
        return false;
    }

    void addRevision(AbstractRevision rev) {
        this.revisions.add(0, rev);
    }

    public AbstractRevision getCurrentRevision() {
        return this.revisions.get(0);
    }

    public List<AbstractRevision> getRevisions() {
        return Collections.unmodifiableList(this.revisions);
    }

    public void clearRevisions() {
        AbstractRevision rev = this.getCurrentRevision();
        this.revisions.clear();
        this.revisions.add(rev);
    }

    public void addRegisteredService(ServiceState serviceState) {
        log.tracef("Add registered service %s to: %s", (Object)serviceState, (Object)this);
        this.registeredServices.add(serviceState);
    }

    public void removeRegisteredService(ServiceState serviceState) {
        log.tracef("Remove registered service %s from: %s", (Object)serviceState, (Object)this);
        this.registeredServices.remove(serviceState);
    }

    public List<ServiceState> getRegisteredServicesInternal() {
        return Collections.unmodifiableList(this.registeredServices);
    }

    public ServiceReference[] getRegisteredServices() {
        this.assertNotUninstalled();
        List<ServiceState> rs = this.getRegisteredServicesInternal();
        if (rs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> srefs = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : rs) {
            srefs.add(serviceState.getReference());
        }
        return srefs.toArray(new ServiceReference[srefs.size()]);
    }

    public void addServiceInUse(ServiceState serviceState) {
        log.tracef("Add service in use %s to: %s", (Object)serviceState, (Object)this);
        this.usedServices.putIfAbsent(serviceState, new AtomicInteger());
        AtomicInteger count = this.usedServices.get(serviceState);
        count.incrementAndGet();
    }

    public int removeServiceInUse(ServiceState serviceState) {
        log.tracef("Remove service in use %s from: %s", (Object)serviceState, (Object)this);
        AtomicInteger count = this.usedServices.get(serviceState);
        if (count == null) {
            return -1;
        }
        int countVal = count.decrementAndGet();
        if (countVal == 0) {
            this.usedServices.remove(serviceState);
        }
        return countVal;
    }

    public Set<ServiceState> getServicesInUseInternal() {
        return Collections.unmodifiableSet(this.usedServices.keySet());
    }

    public ServiceReference[] getServicesInUse() {
        this.assertNotUninstalled();
        Set<ServiceState> servicesInUse = this.getServicesInUseInternal();
        if (servicesInUse.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> srefs = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : servicesInUse) {
            srefs.add(serviceState.getReference());
        }
        return srefs.toArray(new ServiceReference[srefs.size()]);
    }

    public Bundle getBundleWrapper() {
        if (this.bundleWrapper == null) {
            this.bundleWrapper = this.createBundleWrapper();
        }
        return this.bundleWrapper;
    }

    BundleWrapper createBundleWrapper() {
        return new BundleWrapper(this);
    }

    public void changeState(int state) {
        int bundleEventType;
        int previous = this.getState();
        switch (state) {
            case 8: {
                bundleEventType = 128;
                break;
            }
            case 32: {
                bundleEventType = 2;
                break;
            }
            case 16: {
                bundleEventType = 256;
                break;
            }
            case 1: {
                bundleEventType = 16;
                break;
            }
            case 2: {
                if (previous == 4) {
                    bundleEventType = 64;
                    break;
                }
                bundleEventType = 1;
                break;
            }
            case 4: {
                if (previous == 16) {
                    bundleEventType = 4;
                    break;
                }
                bundleEventType = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown bundle state: " + state);
            }
        }
        if (this.getBundleManager().isFrameworkActive() && this.getBundleId() != 0L) {
            this.interceptorPlugin.handleStateChange(state, this.getBundleWrapper());
        }
        this.bundleState.set(state);
        if (this.getBundleManager().isFrameworkActive()) {
            this.eventsPlugin.fireBundleEvent(this, bundleEventType);
        }
    }

    public int getState() {
        return this.bundleState.get();
    }

    public void start(int options) throws BundleException {
        this.assertNotUninstalled();
        this.startInternal(options);
        log.infof("Bundle started: %s", (Object)this);
    }

    public void start() throws BundleException {
        this.assertNotUninstalled();
        this.startInternal(0);
        log.infof("Bundle started: %s", (Object)this);
    }

    abstract void startInternal(int var1) throws BundleException;

    public void stop(int options) throws BundleException {
        this.assertNotUninstalled();
        this.stopInternal(options);
        log.infof("Bundle stopped: %s", (Object)this);
    }

    public void stop() throws BundleException {
        this.assertNotUninstalled();
        this.stopInternal(0);
        log.infof("Bundle stopped: %s", (Object)this);
    }

    abstract void stopInternal(int var1) throws BundleException;

    public void update(InputStream input) throws BundleException {
        this.assertNotUninstalled();
        this.updateInternal(input);
        log.infof("Bundle updated: %s", (Object)this);
        this.updateLastModified();
    }

    public void update() throws BundleException {
        this.assertNotUninstalled();
        this.updateInternal(null);
        log.infof("Bundle updated: %s", (Object)this);
        this.updateLastModified();
    }

    abstract void updateInternal(InputStream var1) throws BundleException;

    public void uninstall() throws BundleException {
        this.assertNotUninstalled();
        if (this.bundleManager.getBundleById(this.getBundleId()) == null) {
            throw new BundleException("Not installed: " + this);
        }
        this.uninstallInternal();
        log.infof("Bundle uninstalled: %s", (Object)this);
    }

    abstract void uninstallInternal() throws BundleException;

    public boolean hasPermission(Object permission) {
        this.assertNotUninstalled();
        if (permission == null || !(permission instanceof Permission)) {
            return false;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return true;
        }
        return true;
    }

    public Dictionary getHeaders() {
        return this.getHeaders(null);
    }

    public Dictionary getHeaders(String locale) {
        URL entryURL;
        String baseName;
        Dictionary rawHeaders = this.getOSGiMetaData().getHeaders();
        if ("".equals(locale)) {
            return rawHeaders;
        }
        if (locale == null) {
            locale = Locale.getDefault().toString();
        }
        if ((baseName = (String)rawHeaders.get("Bundle-Localization")) == null) {
            baseName = "OSGI-INF/l10n/bundle";
        }
        if ((entryURL = this.getLocalizationEntry(baseName, locale)) == null) {
            String defaultLocale = Locale.getDefault().toString();
            entryURL = this.getLocalizationEntry(baseName, defaultLocale);
        }
        PropertyResourceBundle resBundle = null;
        if (entryURL != null) {
            try {
                resBundle = new PropertyResourceBundle(entryURL.openStream());
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot read resouce bundle: " + entryURL, ex);
            }
        }
        Hashtable<String, String> locHeaders = new Hashtable<String, String>();
        Enumeration e = rawHeaders.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = (String)rawHeaders.get(key);
            if (value.startsWith("%")) {
                value = value.substring(1);
            }
            if (resBundle != null) {
                try {
                    value = resBundle.getString(value);
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            ((Dictionary)locHeaders).put(key, value);
        }
        return new CaseInsensitiveDictionary(locHeaders);
    }

    private URL getLocalizationEntry(String baseName, String locale) {
        String entryPath = baseName + "_" + locale + ".properties";
        URL entryURL = this.getLocalizationEntry(entryPath);
        while (entryURL == null && !entryPath.equals(baseName + ".properties")) {
            int lastIndex = locale.lastIndexOf(95);
            if (lastIndex > 0) {
                locale = locale.substring(0, lastIndex);
                entryPath = baseName + "_" + locale + ".properties";
            } else {
                entryPath = baseName + ".properties";
            }
            entryURL = this.getLocalizationEntry(entryPath);
        }
        return entryURL;
    }

    URL getLocalizationEntry(String entryPath) {
        return this.getCurrentRevision().getLocalizationEntry(entryPath);
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.getCurrentRevision().getModuleIdentifier();
    }

    public URL getResource(String name) {
        return this.getCurrentRevision().getResource(name);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.getCurrentRevision().loadClass(name);
    }

    public Enumeration getResources(String name) throws IOException {
        return this.getCurrentRevision().getResources(name);
    }

    public Enumeration getEntryPaths(String path) {
        return this.getCurrentRevision().getEntryPaths(path);
    }

    public URL getEntry(String path) {
        return this.getCurrentRevision().getEntry(path);
    }

    public Enumeration findEntries(String path, String filePattern, boolean recurse) {
        return this.getCurrentRevision().findEntries(path, filePattern, recurse);
    }

    public Version getVersion() {
        return this.getCurrentRevision().getVersion();
    }

    public OSGiMetaData getOSGiMetaData() {
        return this.getCurrentRevision().getOSGiMetaData();
    }

    public XModule getResolverModule() {
        return this.getCurrentRevision().getResolverModule();
    }

    public Map getSignerCertificates(int signersType) {
        throw new NotImplementedException();
    }

    FrameworkEventsPlugin getFrameworkEventsPlugin() {
        return this.eventsPlugin;
    }

    LifecycleInterceptorPlugin getInterceptorPlugin() {
        return this.interceptorPlugin;
    }

    ResolverPlugin getResolverPlugin() {
        return this.resolverPlugin;
    }

    ModuleManagerPlugin getModuleManagerPlugin() {
        return this.moduleManager;
    }

    ServiceManagerPlugin getServiceManagerPlugin() {
        return this.serviceManager;
    }

    void assertValidBundleContext() {
        if (this.getBundleContext() == null) {
            throw new IllegalStateException("Invalid bundle context: " + this);
        }
    }

    void assertNotUninstalled() {
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle uninstalled: " + this);
        }
    }

    public int hashCode() {
        return (int)this.getBundleId() * 51;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractBundle)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AbstractBundle other = (AbstractBundle)obj;
        return this.getBundleId() == other.getBundleId();
    }

    public String toString() {
        return this.getCanonicalName();
    }
}

