/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleContextWrapper;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.FrameworkState;
import org.jboss.osgi.framework.bundle.ServiceReferenceWrapper;
import org.jboss.osgi.framework.bundle.ServiceState;
import org.jboss.osgi.framework.plugin.BundleStoragePlugin;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugin.ServiceManagerPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public abstract class AbstractBundleContext
implements BundleContext {
    private BundleManager bundleManager;
    private AbstractBundle bundleState;
    private BundleContext contextWrapper;
    private boolean destroyed;

    AbstractBundleContext(AbstractBundle bundleState) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        this.bundleManager = bundleState.getBundleManager();
        this.bundleState = bundleState;
    }

    public static AbstractBundleContext assertBundleContext(BundleContext context) {
        if (context == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (context instanceof BundleContextWrapper) {
            context = ((BundleContextWrapper)context).getInternal();
        }
        if (!(context instanceof AbstractBundleContext)) {
            throw new IllegalArgumentException("Not an AbstractBundleContext: " + context);
        }
        return (AbstractBundleContext)context;
    }

    public BundleManager getBundleManager() {
        return this.bundleManager;
    }

    public AbstractBundle getBundleInternal() {
        return this.bundleState;
    }

    public BundleContext getContextWrapper() {
        this.checkValidBundleContext();
        if (this.contextWrapper == null) {
            this.contextWrapper = new BundleContextWrapper(this);
        }
        return this.contextWrapper;
    }

    void destroy() {
        this.destroyed = true;
    }

    public String getProperty(String key) {
        this.checkValidBundleContext();
        FrameworkState frameworkState = this.bundleState.getBundleManager().getFrameworkState();
        frameworkState.assertFrameworkActive();
        return frameworkState.getProperty(key);
    }

    public Bundle getBundle() {
        this.checkValidBundleContext();
        return this.bundleState.getBundleWrapper();
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        this.checkValidBundleContext();
        AbstractBundle bundleState = this.bundleManager.installBundle(location, input);
        return bundleState.getBundleWrapper();
    }

    public Bundle installBundle(String location) throws BundleException {
        this.checkValidBundleContext();
        AbstractBundle bundleState = this.bundleManager.installBundle(location);
        return bundleState.getBundleWrapper();
    }

    public Bundle getBundle(long id) {
        this.checkValidBundleContext();
        AbstractBundle bundle = this.bundleManager.getBundleById(id);
        if (bundle == null) {
            return null;
        }
        return bundle.getBundleWrapper();
    }

    public Bundle[] getBundles() {
        this.checkValidBundleContext();
        ArrayList<Bundle> result = new ArrayList<Bundle>();
        for (AbstractBundle bundle : this.bundleManager.getBundles()) {
            result.add(bundle.getBundleWrapper());
        }
        return result.toArray(new Bundle[result.size()]);
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().addServiceListener(this.bundleState, listener, filter);
    }

    public void addServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        try {
            this.getFrameworkEventsPlugin().addServiceListener(this.bundleState, listener, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
    }

    public void removeServiceListener(ServiceListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().removeServiceListener(this.bundleState, listener);
    }

    public void addBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().addBundleListener(this.bundleState, listener);
    }

    public void removeBundleListener(BundleListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().removeBundleListener(this.bundleState, listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().addFrameworkListener(this.bundleState, listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.checkValidBundleContext();
        this.getFrameworkEventsPlugin().removeFrameworkListener(this.bundleState, listener);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        this.checkValidBundleContext();
        return this.registerService(new String[]{clazz}, service, properties);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        this.checkValidBundleContext();
        ServiceState serviceState = this.getServiceManager().registerService(this.bundleState, clazzes, service, properties);
        return serviceState.getRegistration();
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        List<ServiceState> srefs = this.getServiceManager().getServiceReferences(this.bundleState, clazz, filter, true);
        if (srefs.isEmpty()) {
            return null;
        }
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        for (ServiceState serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        ArrayList<ServiceReference> result = new ArrayList<ServiceReference>();
        List<ServiceState> srefs = this.getServiceManager().getServiceReferences(this.bundleState, clazz, filter, false);
        if (srefs.isEmpty()) {
            return null;
        }
        for (ServiceState serviceState : srefs) {
            result.add(serviceState.getReference());
        }
        return result.toArray(new ServiceReference[result.size()]);
    }

    public ServiceReference getServiceReference(String clazz) {
        this.checkValidBundleContext();
        ServiceState serviceState = this.getServiceManager().getServiceReference(this.bundleState, clazz);
        if (serviceState == null) {
            return null;
        }
        return new ServiceReferenceWrapper(serviceState);
    }

    public Object getService(ServiceReference sref) {
        this.checkValidBundleContext();
        ServiceState serviceState = ServiceState.assertServiceState(sref);
        Object service = this.getServiceManager().getService(this.bundleState, serviceState);
        return service;
    }

    public boolean ungetService(ServiceReference sref) {
        this.checkValidBundleContext();
        ServiceState serviceState = ServiceState.assertServiceState(sref);
        return this.getServiceManager().ungetService(this.bundleState, serviceState);
    }

    public File getDataFile(String filename) {
        this.checkValidBundleContext();
        BundleStoragePlugin storagePlugin = this.bundleManager.getOptionalPlugin(BundleStoragePlugin.class);
        return storagePlugin != null ? storagePlugin.getDataFile(this.bundleState, filename) : null;
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        this.checkValidBundleContext();
        return FrameworkUtil.createFilter((String)filter);
    }

    void checkValidBundleContext() {
        if (this.destroyed) {
            throw new IllegalStateException("Invalid bundle context: " + this);
        }
    }

    private ServiceManagerPlugin getServiceManager() {
        return this.bundleState.getServiceManagerPlugin();
    }

    private FrameworkEventsPlugin getFrameworkEventsPlugin() {
        return this.bundleState.getFrameworkEventsPlugin();
    }

    public String toString() {
        return "BundleContext[" + this.bundleState + "]";
    }
}

