/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.bundle.EntriesProvider;
import org.jboss.osgi.framework.bundle.ModuleEntriesProvider;
import org.jboss.osgi.framework.bundle.VirtualFileEntriesProvider;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;

public abstract class AbstractUserRevision
extends AbstractRevision {
    static final Logger log = Logger.getLogger(AbstractUserRevision.class);
    private final Deployment deployment;
    private List<VirtualFile> contentRoots;
    private final EntriesProvider entriesProvider;

    AbstractUserRevision(AbstractUserBundle bundleState, Deployment dep) throws BundleException {
        super(bundleState, AbstractUserRevision.getOSGiMetaData(dep), AbstractUserRevision.getXModule(dep), AbstractUserRevision.getRevision(dep));
        this.deployment = dep;
        if (dep.getRoot() != null) {
            this.entriesProvider = new VirtualFileEntriesProvider(dep.getRoot());
            this.contentRoots = this.getBundleClassPath(dep.getRoot(), this.getOSGiMetaData());
        } else {
            this.entriesProvider = new ModuleEntriesProvider((Module)dep.getAttachment(Module.class));
            this.contentRoots = Collections.emptyList();
        }
    }

    private static OSGiMetaData getOSGiMetaData(Deployment dep) {
        return (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
    }

    private static XModule getXModule(Deployment dep) {
        return (XModule)dep.getAttachment(XModule.class);
    }

    private static int getRevision(Deployment dep) {
        BundleStorageState storageState = (BundleStorageState)dep.getAttachment(BundleStorageState.class);
        return storageState.getRevision();
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public String getLocation() {
        return this.deployment.getLocation();
    }

    public VirtualFile getFirstContentRoot() {
        return this.contentRoots.size() > 0 ? this.contentRoots.get(0) : null;
    }

    public List<VirtualFile> getContentRoots() {
        return this.contentRoots;
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntryPaths(path);
    }

    @Override
    public URL getEntry(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntry(path);
    }

    @Override
    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.findEntries(path, pattern, recurse);
    }

    private List<VirtualFile> getBundleClassPath(VirtualFile rootFile, OSGiMetaData metadata) {
        if (rootFile == null) {
            throw new IllegalArgumentException("Null rootFile");
        }
        if (metadata.getBundleClassPath().size() == 0) {
            ArrayList<VirtualFile> rootList = new ArrayList<VirtualFile>(Collections.singleton(rootFile));
            return Collections.unmodifiableList(rootList);
        }
        ArrayList<VirtualFile> rootList = new ArrayList<VirtualFile>();
        for (String path : metadata.getBundleClassPath()) {
            if (path.equals(".")) {
                rootList.add(rootFile);
                continue;
            }
            try {
                VirtualFile child = rootFile.getChild(path);
                if (child == null) continue;
                VirtualFile root = AbstractVFS.toVirtualFile((URL)child.toURL());
                rootList.add(root);
            }
            catch (IOException ex) {
                log.errorf((Throwable)ex, "Cannot get class path element: %s", (Object)path);
            }
        }
        return Collections.unmodifiableList(rootList);
    }
}

