/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.bundle.BundleValidator;
import org.jboss.osgi.framework.bundle.BundleValidatorR3;
import org.jboss.osgi.framework.bundle.BundleValidatorR4;
import org.jboss.osgi.framework.bundle.FragmentBundle;
import org.jboss.osgi.framework.bundle.FrameworkState;
import org.jboss.osgi.framework.bundle.HostBundle;
import org.jboss.osgi.framework.bundle.SystemBundle;
import org.jboss.osgi.framework.plugin.AutoInstallPlugin;
import org.jboss.osgi.framework.plugin.BundleDeploymentPlugin;
import org.jboss.osgi.framework.plugin.BundleStoragePlugin;
import org.jboss.osgi.framework.plugin.DeployerServicePlugin;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugin.LifecycleInterceptorPlugin;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.framework.plugin.NativeCodePlugin;
import org.jboss.osgi.framework.plugin.PackageAdminPlugin;
import org.jboss.osgi.framework.plugin.Plugin;
import org.jboss.osgi.framework.plugin.ResolverPlugin;
import org.jboss.osgi.framework.plugin.ServiceManagerPlugin;
import org.jboss.osgi.framework.plugin.StartLevelPlugin;
import org.jboss.osgi.framework.plugin.SystemPackagesPlugin;
import org.jboss.osgi.framework.plugin.internal.AutoInstallPluginImpl;
import org.jboss.osgi.framework.plugin.internal.BundleDeploymentPluginImpl;
import org.jboss.osgi.framework.plugin.internal.BundleStoragePluginImpl;
import org.jboss.osgi.framework.plugin.internal.DeployerServicePluginImpl;
import org.jboss.osgi.framework.plugin.internal.FrameworkEventsPluginImpl;
import org.jboss.osgi.framework.plugin.internal.LifecycleInterceptorPluginImpl;
import org.jboss.osgi.framework.plugin.internal.ModuleManagerPluginImpl;
import org.jboss.osgi.framework.plugin.internal.NativeCodePluginImpl;
import org.jboss.osgi.framework.plugin.internal.PackageAdminPluginImpl;
import org.jboss.osgi.framework.plugin.internal.ResolverPluginImpl;
import org.jboss.osgi.framework.plugin.internal.ServiceManagerPluginImpl;
import org.jboss.osgi.framework.plugin.internal.StartLevelPluginImpl;
import org.jboss.osgi.framework.plugin.internal.SystemPackagesPluginImpl;
import org.jboss.osgi.framework.plugin.internal.WebXMLVerifierInterceptor;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.resolver.XVersionRange;
import org.jboss.osgi.spi.util.SysPropertyActions;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class BundleManager {
    private final Logger log = Logger.getLogger(BundleManager.class);
    private Map<String, Object> properties = new HashMap<String, Object>();
    private AtomicLong identityGenerator = new AtomicLong();
    private Map<Long, AbstractBundle> bundleMap = Collections.synchronizedMap(new LinkedHashMap());
    private Map<Class<? extends Plugin>, Plugin> plugins = new LinkedHashMap<Class<? extends Plugin>, Plugin>();
    private final ModuleLoader defaultModuleLoader;
    private ServiceContainer serviceContainer;
    private FrameworkState frameworkState;
    private boolean firstInit = true;

    public BundleManager(Map<String, Object> initialProperties) {
        ModuleLoader mlProp;
        String implTitle = this.getClass().getPackage().getImplementationTitle();
        String implVersion = this.getClass().getPackage().getImplementationVersion();
        this.log.infof(implTitle + " - " + implVersion, new Object[0]);
        if (initialProperties != null) {
            this.properties.putAll(initialProperties);
        }
        this.defaultModuleLoader = (mlProp = (ModuleLoader)initialProperties.get(ModuleLoader.class.getName())) != null ? mlProp : Module.getDefaultModuleLoader();
        ServiceContainer scProp = (ServiceContainer)initialProperties.get(ServiceContainer.class.getName());
        this.serviceContainer = scProp != null ? scProp : ServiceContainer.Factory.create();
        this.plugins.put(BundleDeploymentPlugin.class, new BundleDeploymentPluginImpl(this));
        this.plugins.put(BundleStoragePlugin.class, new BundleStoragePluginImpl(this));
        this.plugins.put(FrameworkEventsPlugin.class, new FrameworkEventsPluginImpl(this));
        this.plugins.put(ModuleManagerPlugin.class, new ModuleManagerPluginImpl(this));
        this.plugins.put(NativeCodePlugin.class, new NativeCodePluginImpl(this));
        this.plugins.put(ResolverPlugin.class, new ResolverPluginImpl(this));
        this.plugins.put(ServiceManagerPlugin.class, new ServiceManagerPluginImpl(this));
        this.plugins.put(SystemPackagesPlugin.class, new SystemPackagesPluginImpl(this));
        this.plugins.put(DeployerServicePlugin.class, new DeployerServicePluginImpl(this));
        this.plugins.put(LifecycleInterceptorPlugin.class, new LifecycleInterceptorPluginImpl(this));
        this.plugins.put(WebXMLVerifierInterceptor.class, new WebXMLVerifierInterceptor(this));
        this.plugins.put(PackageAdminPlugin.class, new PackageAdminPluginImpl(this));
        this.plugins.put(StartLevelPlugin.class, new StartLevelPluginImpl(this));
        this.plugins.put(AutoInstallPlugin.class, new AutoInstallPluginImpl(this));
        BundleStoragePlugin storagePlugin = this.getPlugin(BundleStoragePlugin.class);
        String storageClean = (String)this.getProperty("org.osgi.framework.storage.clean");
        if (this.firstInit && "onFirstInit".equals(storageClean)) {
            storagePlugin.cleanStorage();
        }
        this.frameworkState = new FrameworkState(this);
        this.firstInit = false;
    }

    public FrameworkState getFrameworkState() {
        return this.frameworkState;
    }

    public SystemBundle getSystemBundle() {
        return this.frameworkState;
    }

    public ModuleLoader getDefaultModuleLoader() {
        return this.defaultModuleLoader;
    }

    public ServiceContainer getServiceContainer() {
        return this.serviceContainer;
    }

    public IntegrationMode getIntegrationMode() {
        Object value = this.getProperty(IntegrationMode.class.getName());
        return value != null ? (IntegrationMode)((Object)value) : IntegrationMode.STANDALONE;
    }

    public BundleContext getSystemContext() {
        return this.frameworkState.getBundleContext();
    }

    public Object getProperty(String key) {
        Object value = this.properties.get(key);
        if (value == null) {
            value = SysPropertyActions.getProperty((String)key, null);
        }
        return value;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public void setProperty(String key, Object value) {
        if (this.isFrameworkActive()) {
            throw new IllegalStateException("Cannot add property to ACTIVE framwork");
        }
        this.properties.put(key, value);
    }

    public boolean isFrameworkActive() {
        return this.frameworkState != null && this.frameworkState.getState() == 32;
    }

    void addBundleState(AbstractBundle bundleState) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        long bundleId = bundleState.getBundleId();
        if (this.bundleMap.containsKey(bundleId)) {
            throw new IllegalStateException("Bundle already added: " + bundleState);
        }
        this.log.infof("Install bundle: %s", (Object)bundleState);
        this.bundleMap.put(bundleId, bundleState);
        bundleState.changeState(2);
        bundleState.addToResolver();
    }

    void removeBundle(AbstractBundle bundleState) {
        this.log.tracef("Remove bundle: %s", (Object)bundleState);
        bundleState.removeFromResolver();
        this.bundleMap.remove(bundleState.getBundleId());
    }

    void uninstallBundle(AbstractBundle bundleState) {
        bundleState.changeState(1);
        List<AbstractBundle> uninstalled = this.getBundles(1);
        for (AbstractBundle aux : uninstalled) {
            AbstractUserBundle userBundle = AbstractUserBundle.assertBundleState(aux);
            if (userBundle.hasActiveWires()) continue;
            userBundle.remove();
        }
    }

    public AbstractBundle getBundleById(long bundleId) {
        if (bundleId == 0L) {
            return this.frameworkState;
        }
        return this.bundleMap.get(bundleId);
    }

    public AbstractBundle getBundleByLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        AbstractBundle result = null;
        for (AbstractBundle aux : this.getBundles()) {
            String auxLocation = aux.getLocation();
            if (!location.equals(auxLocation)) continue;
            result = aux;
            break;
        }
        return result;
    }

    public AbstractBundle getBundle(String symbolicName, String versionRange) {
        AbstractBundle result = null;
        for (AbstractBundle aux : this.getBundles()) {
            if (!aux.getSymbolicName().equals(symbolicName) || versionRange != null && !XVersionRange.parse((String)versionRange).isInRange(aux.getVersion())) continue;
            result = aux;
            break;
        }
        return result;
    }

    public List<AbstractBundle> getBundles() {
        ArrayList<AbstractBundle> result = new ArrayList<AbstractBundle>();
        for (AbstractBundle aux : this.bundleMap.values()) {
            if (aux.getState() == 1) continue;
            result.add(aux);
        }
        return Collections.unmodifiableList(result);
    }

    public List<AbstractBundle> getBundles(Integer states) {
        ArrayList<AbstractBundle> result = new ArrayList<AbstractBundle>();
        for (AbstractBundle aux : this.bundleMap.values()) {
            if (states != null && (aux.getState() & states) == 0) continue;
            result.add(aux);
        }
        return Collections.unmodifiableList(result);
    }

    public List<Plugin> getPlugins() {
        return Collections.unmodifiableList(new ArrayList<Plugin>(this.plugins.values()));
    }

    public <T extends Plugin> T getPlugin(Class<T> clazz) {
        Plugin plugin = this.plugins.get(clazz);
        if (plugin == null) {
            throw new IllegalStateException("Cannot obtain plugin for: " + clazz.getName());
        }
        return (T)plugin;
    }

    public <T extends Plugin> T getOptionalPlugin(Class<T> clazz) {
        return (T)this.plugins.get(clazz);
    }

    public AbstractBundle installBundle(URL location) throws BundleException {
        VirtualFile rootFile;
        try {
            rootFile = AbstractVFS.toVirtualFile((URL)location);
        }
        catch (IOException ex) {
            throw new BundleException("Cannot obtain virtual file from: " + location, (Throwable)ex);
        }
        return this.installBundleInternal(location.toExternalForm(), rootFile);
    }

    public AbstractBundle installBundle(String location) throws BundleException {
        return this.installBundle(location, null);
    }

    public AbstractBundle installBundle(String location, InputStream input) throws BundleException {
        VirtualFile rootFile = null;
        if (input != null) {
            try {
                rootFile = AbstractVFS.toVirtualFile((String)location, (InputStream)input);
            }
            catch (IOException ex) {
                throw new BundleException("Cannot obtain virtual file from input stream", (Throwable)ex);
            }
        }
        if (rootFile == null) {
            try {
                URL url = new URL(location);
                rootFile = AbstractVFS.toVirtualFile((URL)url);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (rootFile == null) {
            try {
                File file = new File(location);
                if (file.exists()) {
                    rootFile = AbstractVFS.toVirtualFile((URL)file.toURI().toURL());
                }
            }
            catch (IOException ex) {
                throw new BundleException("Cannot obtain virtual file from: " + location, (Throwable)ex);
            }
        }
        if (rootFile == null) {
            throw new BundleException("Cannot obtain virtual file from: " + location);
        }
        return this.installBundleInternal(location, rootFile);
    }

    private AbstractBundle installBundleInternal(String location, VirtualFile rootFile) throws BundleException {
        BundleStorageState storageState;
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        if (rootFile == null) {
            throw new IllegalArgumentException("Null rootFile");
        }
        try {
            BundleStoragePlugin plugin = this.getPlugin(BundleStoragePlugin.class);
            storageState = plugin.createStorageState(this.getNextBundleId(), location, rootFile);
        }
        catch (IOException ex) {
            throw new BundleException("Cannot setup storage for: " + rootFile, (Throwable)ex);
        }
        try {
            BundleDeploymentPlugin deploymentPlugin = this.getPlugin(BundleDeploymentPlugin.class);
            Deployment dep = deploymentPlugin.createDeployment(storageState);
            return this.installBundle(dep);
        }
        catch (BundleException ex) {
            storageState.deleteBundleStorage();
            throw ex;
        }
        catch (RuntimeException ex) {
            storageState.deleteBundleStorage();
            throw ex;
        }
    }

    public Bundle installBundle(ModuleIdentifier identifier) throws BundleException {
        BundleDeploymentPlugin plugin = this.getPlugin(BundleDeploymentPlugin.class);
        Deployment dep = plugin.createDeployment(identifier);
        return this.installBundle(dep);
    }

    public AbstractBundle installBundle(Deployment dep) throws BundleException {
        AbstractBundle bundleState;
        if (dep == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        BundleStorageState storageState = (BundleStorageState)dep.getAttachment(BundleStorageState.class);
        if (storageState == null) {
            try {
                BundleStoragePlugin plugin = this.getPlugin(BundleStoragePlugin.class);
                storageState = plugin.createStorageState(this.getNextBundleId(), dep.getLocation(), dep.getRoot());
                dep.addAttachment(BundleStorageState.class, (Object)storageState);
            }
            catch (IOException ex) {
                throw new BundleException("Cannot setup storage for: " + dep, (Throwable)ex);
            }
        }
        if ((bundleState = this.getBundleByLocation(dep.getLocation())) != null) {
            return bundleState;
        }
        try {
            bundleState = this.createBundle(dep);
        }
        catch (BundleException ex) {
            BundleStorageState bundleStorage = storageState;
            if (bundleStorage != null) {
                bundleStorage.deleteRevisionStorage();
            }
            throw ex;
        }
        this.addBundleState(bundleState);
        return bundleState;
    }

    public long getNextBundleId() {
        return this.identityGenerator.incrementAndGet();
    }

    void installPersistedBundles(List<BundleStorageState> storageStates) {
        BundleDeploymentPlugin deploymentPlugin = this.getPlugin(BundleDeploymentPlugin.class);
        for (BundleStorageState storageState : storageStates) {
            long bundleId = storageState.getBundleId();
            if (bundleId == 0L) continue;
            try {
                Deployment dep = deploymentPlugin.createDeployment(storageState);
                this.installBundle(dep);
            }
            catch (BundleException ex) {
                this.log.errorf((Throwable)ex, "Cannot install persistet bundle: %s", (Object)storageState);
            }
        }
    }

    private AbstractBundle createBundle(Deployment dep) throws BundleException {
        NativeCodePlugin nativeCodePlugin;
        BundleDeploymentPlugin deploymentPlugin = this.getPlugin(BundleDeploymentPlugin.class);
        OSGiMetaData metadata = deploymentPlugin.createOSGiMetaData(dep);
        boolean isFragment = metadata.getFragmentHost() != null;
        AbstractUserBundle bundleState = isFragment ? new FragmentBundle(this, dep) : new HostBundle(this, dep);
        dep.addAttachment(AbstractBundle.class, (Object)bundleState);
        this.validateBundle(bundleState);
        if (metadata.getBundleNativeCode() != null && (nativeCodePlugin = this.getOptionalPlugin(NativeCodePlugin.class)) != null) {
            nativeCodePlugin.deployNativeCode(dep);
        }
        return bundleState;
    }

    private void validateBundle(AbstractBundle bundleState) throws BundleException {
        OSGiMetaData osgiMetaData = bundleState.getOSGiMetaData();
        if (osgiMetaData == null) {
            return;
        }
        BundleValidator validator = osgiMetaData.getBundleManifestVersion() > 1 ? new BundleValidatorR4(this) : new BundleValidatorR3(this);
        validator.validateBundle(bundleState);
    }

    void fireError(Bundle bundle, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getPlugin(FrameworkEventsPlugin.class);
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundle, 2, t);
        } else if (bundle != null) {
            plugin.fireFrameworkEvent(bundle, 2, new BundleException("Error " + context + " bundle: " + bundle, t));
        } else {
            plugin.fireFrameworkEvent(this.getSystemBundle(), 2, new BundleException("Error " + context, t));
        }
    }

    void fireWarning(Bundle bundle, String context, Throwable t) {
        FrameworkEventsPlugin plugin = this.getPlugin(FrameworkEventsPlugin.class);
        if (t instanceof BundleException) {
            plugin.fireFrameworkEvent(bundle, 16, t);
        } else if (bundle != null) {
            plugin.fireFrameworkEvent(bundle, 16, new BundleException("Error " + context + " bundle: " + bundle, t));
        } else {
            plugin.fireFrameworkEvent(this.getSystemBundle(), 16, new BundleException("Error " + context, t));
        }
    }

    void destroy() {
        ArrayList<Plugin> reversePlugins = new ArrayList<Plugin>(this.getPlugins());
        Collections.reverse(reversePlugins);
        for (Plugin plugin : reversePlugins) {
            try {
                plugin.destroyPlugin();
            }
            catch (RuntimeException ex) {
                this.log.errorf((Throwable)ex, "Cannot destroy plugin: %s", (Object)plugin);
            }
        }
        this.bundleMap.clear();
    }

    public static enum IntegrationMode {
        STANDALONE,
        CONTAINER;

    }
}

