/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.HashSet;
import java.util.List;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.BundleValidator;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.osgi.framework.BundleException;

public class BundleValidatorR4
implements BundleValidator {
    private BundleManager bundleManager;

    public BundleValidatorR4(BundleManager bundleManager) {
        this.bundleManager = bundleManager;
    }

    @Override
    public void validateBundle(AbstractBundle bundleState) throws BundleException {
        List exportPackages;
        String packageName;
        OSGiMetaData osgiMetaData = bundleState.getOSGiMetaData();
        String symbolicName = bundleState.getSymbolicName();
        if (symbolicName == null) {
            throw new BundleException("Missing Bundle-SymbolicName in: " + bundleState);
        }
        int manifestVersion = osgiMetaData.getBundleManifestVersion();
        if (manifestVersion > 2) {
            throw new BundleException("Unsupported manifest version " + manifestVersion + " for " + bundleState);
        }
        List importPackages = osgiMetaData.getImportPackages();
        if (importPackages != null && !importPackages.isEmpty()) {
            HashSet<String> packages = new HashSet<String>();
            for (PackageAttribute packageAttribute : importPackages) {
                packageName = packageAttribute.getAttribute();
                if (packages.contains(packageName)) {
                    throw new BundleException("Duplicate import of package " + packageName + " for " + bundleState);
                }
                packages.add(packageName);
                if (packageName.startsWith("java.")) {
                    throw new BundleException("Not allowed to import java.* for " + bundleState);
                }
                String version = (String)packageAttribute.getAttributeValue("version", String.class);
                String specificationVersion = (String)packageAttribute.getAttributeValue("specification-version", String.class);
                if (version == null || specificationVersion == null || version.equals(specificationVersion)) continue;
                throw new BundleException(packageName + " version and specification version should be the same for " + bundleState);
            }
        }
        if ((exportPackages = osgiMetaData.getExportPackages()) != null && !exportPackages.isEmpty()) {
            for (PackageAttribute packageAttribute : exportPackages) {
                packageName = packageAttribute.getAttribute();
                if (!packageName.startsWith("java.")) continue;
                throw new BundleException("Not allowed to export java.* for " + bundleState);
            }
        }
        for (AbstractBundle bundle : this.bundleManager.getBundles()) {
            OSGiMetaData other = bundle.getOSGiMetaData();
            if (!symbolicName.equals(other.getBundleSymbolicName())) continue;
            if (other.isSingleton() && osgiMetaData.isSingleton()) {
                throw new BundleException("Cannot install singleton " + bundleState + " another singleton is already installed: " + bundle.getLocation());
            }
            if (!other.getBundleVersion().equals((Object)osgiMetaData.getBundleVersion())) continue;
            throw new BundleException("Cannot install " + bundleState + " a bundle with that name and version is already installed: " + bundle.getLocation());
        }
    }
}

