/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.AbstractUserRevision;
import org.jboss.osgi.framework.bundle.FragmentBundle;
import org.jboss.osgi.framework.bundle.HostRevision;
import org.jboss.osgi.resolver.XFragmentHostRequirement;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XWire;
import org.osgi.framework.BundleException;

public class FragmentRevision
extends AbstractUserRevision {
    private List<HostRevision> attachedHosts;

    public FragmentRevision(FragmentBundle bundleState, Deployment dep) throws BundleException {
        super(bundleState, dep);
    }

    @Override
    public FragmentBundle getBundleState() {
        return (FragmentBundle)super.getBundleState();
    }

    @Override
    void refreshRevisionInternal(XModule resModule) {
        resModule.addAttachment(FragmentBundle.class, (Object)this.getBundleState());
        this.attachedHosts = null;
    }

    public List<HostRevision> getAttachedHosts() {
        if (this.attachedHosts == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.attachedHosts);
    }

    @Override
    Class<?> loadClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException("Cannot load class from a fragment: " + this);
    }

    @Override
    URL getResource(String name) {
        return null;
    }

    @Override
    Enumeration<URL> getResources(String name) throws IOException {
        return null;
    }

    public void attachToHost() {
        if (this.attachedHosts == null) {
            this.attachedHosts = new CopyOnWriteArrayList<HostRevision>();
        }
        for (XWire wire : this.getResolverModule().getWires()) {
            XRequirement req = wire.getRequirement();
            if (!(req instanceof XFragmentHostRequirement)) continue;
            XModule hostModule = wire.getExporter();
            HostRevision hostRev = (HostRevision)hostModule.getAttachment(AbstractRevision.class);
            hostRev.attachFragment(this);
            this.attachedHosts.add(hostRev);
        }
    }

    @Override
    URL getLocalizationEntry(String path) {
        if (this.getResolverModule().isResolved()) {
            HostRevision highest = null;
            for (HostRevision hostrev : this.getAttachedHosts()) {
                if (highest == null) {
                    highest = hostrev;
                }
                if (highest.getVersion().compareTo((Object)hostrev.getVersion()) >= 0) continue;
                highest = hostrev;
            }
            if (highest == null) {
                throw new IllegalStateException("Cannot abtain attached host for: " + this);
            }
            boolean hostUninstalled = highest.getBundleState().isUninstalled();
            URL entry = hostUninstalled ? this.getEntry(path) : highest.getEntry(path);
            return entry;
        }
        URL entry = this.getEntry(path);
        return entry;
    }
}

