/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.bundle.FrameworkWrapper;
import org.jboss.osgi.framework.bundle.SystemBundle;
import org.jboss.osgi.framework.plugin.BundleStoragePlugin;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugin.Plugin;
import org.jboss.osgi.framework.plugin.ResolverPlugin;
import org.jboss.osgi.framework.plugin.StartLevelPlugin;
import org.jboss.osgi.framework.util.Java;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.jboss.osgi.spi.util.SysPropertyActions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.launch.Framework;

public class FrameworkState
extends SystemBundle
implements Framework {
    final Logger log = Logger.getLogger(FrameworkState.class);
    private static String OSGi_FRAMEWORK_EXECUTIONENVIRONMENT;
    private static String OSGi_FRAMEWORK_LANGUAGE;
    private static String OSGi_FRAMEWORK_OS_NAME;
    private static String OSGi_FRAMEWORK_OS_VERSION;
    private static String OSGi_FRAMEWORK_PROCESSOR;
    private static String OSGi_FRAMEWORK_VENDOR;
    private static String OSGi_FRAMEWORK_VERSION;
    private FrameworkWrapper frameworkWrapper;
    private AtomicBoolean stopMonitor = new AtomicBoolean(false);
    private int stoppedEvent = 64;
    private Executor executor = Executors.newFixedThreadPool(10);

    FrameworkState(BundleManager bundleManager) {
        super(bundleManager);
        if (bundleManager.getProperty("org.osgi.framework.executionenvironment") == null) {
            bundleManager.setProperty("org.osgi.framework.executionenvironment", OSGi_FRAMEWORK_EXECUTIONENVIRONMENT);
        }
        if (bundleManager.getProperty("org.osgi.framework.language") == null) {
            bundleManager.setProperty("org.osgi.framework.language", OSGi_FRAMEWORK_LANGUAGE);
        }
        if (bundleManager.getProperty("org.osgi.framework.os.name") == null) {
            bundleManager.setProperty("org.osgi.framework.os.name", OSGi_FRAMEWORK_OS_NAME);
        }
        if (bundleManager.getProperty("org.osgi.framework.os.version") == null) {
            bundleManager.setProperty("org.osgi.framework.os.version", OSGi_FRAMEWORK_OS_VERSION);
        }
        if (bundleManager.getProperty("org.osgi.framework.processor") == null) {
            bundleManager.setProperty("org.osgi.framework.processor", OSGi_FRAMEWORK_PROCESSOR);
        }
        if (bundleManager.getProperty("org.osgi.framework.vendor") == null) {
            bundleManager.setProperty("org.osgi.framework.vendor", OSGi_FRAMEWORK_VENDOR);
        }
        if (bundleManager.getProperty("org.osgi.framework.version") == null) {
            bundleManager.setProperty("org.osgi.framework.version", OSGi_FRAMEWORK_VERSION);
        }
        this.changeState(2);
    }

    public Framework getBundleWrapper() {
        if (this.frameworkWrapper == null) {
            this.frameworkWrapper = new FrameworkWrapper(this);
        }
        return this.frameworkWrapper;
    }

    public Map<String, Object> getProperties() {
        Map<String, Object> properties = this.getBundleManager().getProperties();
        return Collections.unmodifiableMap(properties);
    }

    public String getProperty(String key) {
        Object value = this.getBundleManager().getProperty(key);
        return value instanceof String ? (String)value : null;
    }

    public void setProperty(String key, Object value) {
        this.getBundleManager().setProperty(key, value);
    }

    boolean isFrameworkActive() {
        return this.getState() == 32;
    }

    void assertFrameworkActive() {
        int systemState = this.getState();
        if (systemState != 32) {
            throw new IllegalStateException("this not ACTIVE, it is: " + ConstantsHelper.bundleState((int)systemState));
        }
    }

    public void init() throws BundleException {
        int state = this.getState();
        if (state == 8 || state == 32 || state == 16) {
            return;
        }
        BundleManager bundleManager = this.getBundleManager();
        for (Plugin plugin : bundleManager.getPlugins()) {
            plugin.initPlugin();
        }
        this.createSystemBundleRevision();
        bundleManager.addBundleState(this);
        this.changeState(8);
        this.createBundleContext();
        FrameworkEventsPlugin eventsPlugin = bundleManager.getPlugin(FrameworkEventsPlugin.class);
        eventsPlugin.setActive(true);
        try {
            BundleStoragePlugin storagePlugin = bundleManager.getPlugin(BundleStoragePlugin.class);
            List<BundleStorageState> storageStates = storagePlugin.getBundleStorageStates();
            bundleManager.installPersistedBundles(storageStates);
        }
        catch (IOException ex) {
            throw new BundleException("Cannot install persisted bundles", (Throwable)ex);
        }
        this.log.debug((Object)"Framework initialized");
    }

    @Override
    public void start() throws BundleException {
        this.start(0);
    }

    @Override
    public void start(int options) throws BundleException {
        Plugin plugin2;
        if (this.getState() != 8) {
            this.init();
        }
        ResolverPlugin resolver = this.getBundleManager().getPlugin(ResolverPlugin.class);
        resolver.resolve(this.getResolverModule());
        this.changeState(32);
        for (Plugin plugin2 : this.getBundleManager().getPlugins()) {
            plugin2.startPlugin();
        }
        StartLevelPlugin startLevel = this.getBundleManager().getOptionalPlugin(StartLevelPlugin.class);
        if (startLevel != null) {
            startLevel.increaseStartLevel(this.getBeginningStartLevel());
        }
        plugin2 = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
        plugin2.fireFrameworkEvent(this, 1, null);
        this.log.info((Object)"Framework started");
    }

    private int getBeginningStartLevel() {
        String beginning = this.getBundleManager().getSystemContext().getProperty("org.osgi.framework.startlevel.beginning");
        if (beginning == null) {
            return 1;
        }
        try {
            return Integer.parseInt(beginning);
        }
        catch (NumberFormatException nfe) {
            this.log.errorf("Could not set beginning start level to: %s", (Object)beginning);
            return 1;
        }
    }

    @Override
    public void stop() throws BundleException {
        this.stop(0);
    }

    @Override
    public void stop(int options) {
        int state = this.getState();
        if (state != 8 && state != 32) {
            return;
        }
        Runnable cmd = new Runnable(){

            @Override
            public void run() {
                try {
                    FrameworkState.this.stopInternal(false);
                }
                catch (Exception ex) {
                    FrameworkState.this.log.errorf((Throwable)ex, "Error stopping framework", new Object[0]);
                }
            }
        };
        this.executor.execute(cmd);
    }

    @Override
    public void update(InputStream input) throws BundleException {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.update();
    }

    @Override
    public void update() {
        int state = this.getState();
        if (state != 8 && state != 32) {
            return;
        }
        final int targetState = this.getState();
        Runnable cmd = new Runnable(){

            @Override
            public void run() {
                try {
                    FrameworkState.this.stopInternal(true);
                    if (targetState == 8) {
                        FrameworkState.this.init();
                    }
                    if (targetState == 32) {
                        FrameworkState.this.start();
                    }
                }
                catch (Exception ex) {
                    FrameworkState.this.log.errorf((Throwable)ex, "Error stopping framework", new Object[0]);
                }
            }
        };
        this.executor.execute(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInternal(boolean stopForUpdate) {
        try {
            AtomicBoolean atomicBoolean = this.stopMonitor;
            synchronized (atomicBoolean) {
                block25: {
                    int state = this.getState();
                    if (state == 8 || state == 32) break block25;
                    return;
                }
                this.stoppedEvent = stopForUpdate ? 128 : 64;
                this.changeState(16);
            }
            StartLevelPlugin startLevel = this.getBundleManager().getOptionalPlugin(StartLevelPlugin.class);
            if (startLevel != null) {
                startLevel.decreaseStartLevel(0);
            } else {
                for (AbstractBundle bundleState : this.getBundleManager().getBundles()) {
                    if (bundleState == this) continue;
                    try {
                        bundleState.stop();
                    }
                    catch (Exception ex) {
                        this.getBundleManager().fireError(bundleState, "stopping bundle", ex);
                    }
                }
            }
            ArrayList<Plugin> reversePlugins = new ArrayList<Plugin>(this.getBundleManager().getPlugins());
            Collections.reverse(reversePlugins);
            for (Plugin plugin : reversePlugins) {
                try {
                    plugin.stopPlugin();
                }
                catch (RuntimeException ex) {
                    this.log.errorf((Throwable)ex, "Cannot stop plugin: %s", (Object)plugin);
                }
            }
            FrameworkEventsPlugin eventsPlugin = this.getBundleManager().getPlugin(FrameworkEventsPlugin.class);
            eventsPlugin.setActive(false);
            this.changeState(4);
            this.getBundleManager().destroy();
            this.destroyBundleContext();
            this.destroySystemBundleRevision();
            this.log.info((Object)"Framework stopped");
        }
        finally {
            AtomicBoolean atomicBoolean = this.stopMonitor;
            synchronized (atomicBoolean) {
                this.stopMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        AtomicBoolean atomicBoolean = this.stopMonitor;
        synchronized (atomicBoolean) {
            int state = this.getState();
            if (state != 8 && state != 32 && state != 16) {
                return new FrameworkEvent(this.stoppedEvent, (Bundle)this, null);
            }
            this.stopMonitor.wait(timeout);
        }
        if (this.getState() != 4) {
            return new FrameworkEvent(512, (Bundle)this, null);
        }
        return new FrameworkEvent(this.stoppedEvent, (Bundle)this, null);
    }

    @Override
    public void uninstall() throws BundleException {
        throw new BundleException("The system bundle cannot be uninstalled");
    }

    static {
        OSGi_FRAMEWORK_LANGUAGE = Locale.getDefault().getISO3Language();
        OSGi_FRAMEWORK_VENDOR = "jboss.org";
        OSGi_FRAMEWORK_VERSION = "1.5";
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ArrayList<String> execEnvironments = new ArrayList<String>();
                if (Java.isCompatible(6)) {
                    execEnvironments.add("J2SE-1.5");
                }
                if (Java.isCompatible(7)) {
                    execEnvironments.add("JavaSE-1.6");
                }
                String envlist = ((Object)execEnvironments).toString();
                envlist = envlist.substring(1, envlist.length() - 1);
                OSGi_FRAMEWORK_EXECUTIONENVIRONMENT = envlist;
                OSGi_FRAMEWORK_OS_NAME = SysPropertyActions.getProperty((String)"os.name", null);
                OSGi_FRAMEWORK_OS_VERSION = SysPropertyActions.getProperty((String)"os.version", null);
                OSGi_FRAMEWORK_PROCESSOR = SysPropertyActions.getProperty((String)"os.arch", null);
                System.setProperty("org.osgi.vendor.framework", "org.jboss.osgi.framework");
                return null;
            }
        });
    }
}

