/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.List;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractBundleContext;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.AbstractUserRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.bundle.HostBundleContext;
import org.jboss.osgi.framework.bundle.HostRevision;
import org.jboss.osgi.framework.bundle.ModuleActivatorBridge;
import org.jboss.osgi.framework.bundle.ServiceState;
import org.jboss.osgi.framework.plugin.StartLevelPlugin;
import org.jboss.osgi.modules.ModuleActivator;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;

public class HostBundle
extends AbstractUserBundle {
    private BundleActivator bundleActivator;
    private int startLevel = -1;

    HostBundle(BundleManager bundleManager, Deployment deployment) throws BundleException {
        super(bundleManager, deployment);
        StartLevelPlugin sl = this.getBundleManager().getOptionalPlugin(StartLevelPlugin.class);
        if (sl != null) {
            this.startLevel = sl.getInitialBundleStartLevel();
        }
    }

    public static HostBundle assertBundleState(Bundle bundle) {
        AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
        if (!(bundleState instanceof HostBundle)) {
            throw new IllegalArgumentException("Not an InternalBundle: " + bundleState);
        }
        return (HostBundle)bundleState;
    }

    @Override
    AbstractUserRevision createRevisionInternal(Deployment dep) throws BundleException {
        return new HostRevision(this, dep);
    }

    @Override
    public HostRevision getCurrentRevision() {
        return (HostRevision)super.getCurrentRevision();
    }

    @Override
    public List<VirtualFile> getContentRoots() {
        return this.getCurrentRevision().getContentRoots();
    }

    public boolean isDestroyed() {
        return this.getBundleManager().getBundleById(this.getBundleId()) == null;
    }

    @Override
    public boolean isFragment() {
        return false;
    }

    @Override
    public boolean ensureResolved() {
        boolean result = true;
        if (this.getState() == 2) {
            try {
                this.getResolverPlugin().resolve(this.getResolverModule());
            }
            catch (BundleException ex) {
                this.getFrameworkEventsPlugin().fireFrameworkEvent(this, 2, ex);
                result = false;
            }
        }
        return result;
    }

    @Override
    AbstractBundleContext createContextInternal() {
        return new HostBundleContext(this, null);
    }

    public int getStartLevel() {
        return this.startLevel;
    }

    public void setStartLevel(int sl) {
        this.startLevel = sl;
    }

    public boolean isPersistentlyStarted() {
        BundleStorageState storageState = this.getBundleStorageState();
        return storageState.isPersistentlyStarted();
    }

    public void setPersistentlyStarted(boolean started) {
        BundleStorageState storageState = this.getBundleStorageState();
        storageState.setPersistentlyStarted(started);
    }

    @Override
    void startInternal(int options) throws BundleException {
        StartLevelPlugin plugin;
        if (this.getState() == 32) {
            return;
        }
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(true);
        }
        if ((plugin = this.getBundleManager().getOptionalPlugin(StartLevelPlugin.class)) != null && plugin.getStartLevel() < this.getStartLevel()) {
            return;
        }
        XModule resModule = this.getResolverModule();
        this.getResolverPlugin().resolve(resModule);
        try {
            this.createBundleContext();
            this.changeState(8);
            String bundleActivatorClassName = resModule.getModuleActivator();
            if (bundleActivatorClassName != null) {
                Object result = this.loadClass(bundleActivatorClassName).newInstance();
                if (result instanceof ModuleActivator) {
                    this.bundleActivator = new ModuleActivatorBridge((ModuleActivator)result);
                    this.bundleActivator.start(this.getBundleContext());
                } else if (result instanceof BundleActivator) {
                    this.bundleActivator = (BundleActivator)result;
                    this.bundleActivator.start(this.getBundleContext());
                } else {
                    throw new BundleException(bundleActivatorClassName + " is not an implementation of " + BundleActivator.class.getName());
                }
            }
            this.changeState(32);
        }
        catch (Throwable t) {
            this.changeState(16);
            this.stopInternal(options);
            this.destroyBundleContext();
            this.changeState(4);
            if (t instanceof BundleException) {
                throw (BundleException)t;
            }
            throw new BundleException("Cannot start bundle: " + this, t);
        }
    }

    @Override
    void stopInternal(int options) throws BundleException {
        if (this.getState() == 1) {
            throw new IllegalStateException("Bundle already uninstalled: " + this);
        }
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(false);
        }
        if (this.getState() != 8 && this.getState() != 32) {
            return;
        }
        int priorState = this.getState();
        this.changeState(16);
        Throwable rethrow = null;
        if (priorState == 32 && this.bundleActivator != null && this.getBundleContext() != null) {
            try {
                if (this.bundleActivator instanceof ModuleActivatorBridge) {
                    this.bundleActivator.stop(this.getBundleContextInternal());
                } else {
                    this.bundleActivator.stop(this.getBundleContext());
                }
            }
            catch (Throwable t) {
                rethrow = t;
            }
        }
        for (ServiceState serviceState : this.getRegisteredServicesInternal()) {
            serviceState.unregister();
        }
        if (this.getState() == 1) {
            throw new BundleException("Bundle uninstalled during activator stop: " + this);
        }
        this.destroyBundleContext();
        this.changeState(4);
        if (rethrow != null) {
            throw new BundleException("Error during stop of bundle: " + this, rethrow);
        }
    }

    @Override
    void uninstallInternal() throws BundleException {
        BundleManager bundleManager = this.getBundleManager();
        int state = this.getState();
        if (state == 32 || state == 8 || state == 16) {
            try {
                this.stopInternal(0);
            }
            catch (Exception ex) {
                bundleManager.fireError(this, "Error stopping bundle: " + this, ex);
            }
        }
        bundleManager.uninstallBundle(this);
    }
}

