/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractUserRevision;
import org.jboss.osgi.framework.bundle.FragmentRevision;
import org.jboss.osgi.framework.bundle.HostBundle;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;

public class HostRevision
extends AbstractUserRevision {
    static final Logger log = Logger.getLogger(HostRevision.class);
    private List<FragmentRevision> attachedFragments;

    public HostRevision(HostBundle hostBundle, Deployment dep) throws BundleException {
        super(hostBundle, dep);
    }

    @Override
    public HostBundle getBundleState() {
        return (HostBundle)super.getBundleState();
    }

    @Override
    void refreshRevisionInternal(XModule resModule) {
        resModule.addAttachment(HostBundle.class, (Object)this.getBundleState());
        this.attachedFragments = null;
    }

    public void attachFragment(FragmentRevision fragRev) {
        if (this.attachedFragments == null) {
            this.attachedFragments = new CopyOnWriteArrayList<FragmentRevision>();
        }
        this.attachedFragments.add(fragRev);
    }

    public List<FragmentRevision> getAttachedFragments() {
        if (this.attachedFragments == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.attachedFragments);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        this.getBundleState().assertNotUninstalled();
        if (!this.getBundleState().ensureResolved()) {
            throw new ClassNotFoundException("Class '" + className + "' not found in: " + this);
        }
        ModuleClassLoader loader = this.getModuleClassLoader();
        return loader.loadClass(className, true);
    }

    @Override
    public URL getResource(String path) {
        this.getBundleState().assertNotUninstalled();
        if (this.getBundleState().ensureResolved()) {
            return this.getModuleClassLoader().getResource(path);
        }
        return this.getEntry(path);
    }

    @Override
    public Enumeration<URL> getResources(String path) throws IOException {
        this.getBundleState().assertNotUninstalled();
        if (this.getBundleState().ensureResolved()) {
            Enumeration resources = this.getModuleClassLoader().getResources(path);
            return resources.hasMoreElements() ? resources : null;
        }
        Iterator<VirtualFile> i$ = this.getContentRoots().iterator();
        if (i$.hasNext()) {
            VirtualFile rootFile = i$.next();
            try {
                VirtualFile child = rootFile.getChild(path);
                if (child == null) {
                    return null;
                }
                Vector<URL> vector = new Vector<URL>();
                vector.add(child.toURL());
                return vector.elements();
            }
            catch (IOException ex) {
                log.errorf((Throwable)ex, "Cannot get resources: %s", (Object)path);
                return null;
            }
        }
        return null;
    }

    @Override
    URL getLocalizationEntry(String path) {
        URL entry = this.getEntry(path);
        if (entry != null) {
            return entry;
        }
        for (FragmentRevision fragrev : this.getAttachedFragments()) {
            if (fragrev.getBundleState().isUninstalled() || (entry = fragrev.getEntry(path)) == null) continue;
            return entry;
        }
        return null;
    }
}

