/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractBundleContext;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.modules.ModuleActivator;
import org.jboss.osgi.modules.ModuleContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ModuleActivatorBridge
implements BundleActivator {
    private BundleManager bundleManager;
    private ModuleActivator moduleActivator;
    private ModuleContext moduleContext;

    public ModuleActivatorBridge(ModuleActivator moduleActivator) {
        this.moduleActivator = moduleActivator;
    }

    public void start(BundleContext context) throws Exception {
        AbstractBundle bundleState = AbstractBundleContext.assertBundleContext(context).getBundleInternal();
        this.bundleManager = bundleState.getBundleManager();
        ModuleManagerPlugin moduleManager = this.bundleManager.getPlugin(ModuleManagerPlugin.class);
        ModuleIdentifier identifier = bundleState.getModuleIdentifier();
        Module module = moduleManager.getModule(identifier);
        ServiceContainer serviceContainer = this.bundleManager.getServiceContainer();
        BundleContext systemContext = this.bundleManager.getSystemContext();
        this.moduleContext = new ModuleContextImpl(serviceContainer, module, systemContext, context.getBundle());
        this.moduleActivator.start(this.moduleContext);
    }

    public void stop(BundleContext context) throws Exception {
        this.moduleActivator.stop(this.moduleContext);
    }

    class ModuleContextImpl
    implements ModuleContext {
        private ServiceContainer serviceContainer;
        private Module module;
        private BundleContext systemContext;
        private Bundle bundle;

        ModuleContextImpl(ServiceContainer serviceContainer, Module module, BundleContext systemContext, Bundle bundle) {
            if (serviceContainer == null) {
                throw new IllegalArgumentException("Null serviceContainer");
            }
            if (module == null) {
                throw new IllegalArgumentException("Null module");
            }
            if (systemContext == null) {
                throw new IllegalArgumentException("Null systemContext");
            }
            if (bundle == null) {
                throw new IllegalArgumentException("Null bundle");
            }
            this.serviceContainer = serviceContainer;
            this.module = module;
            this.systemContext = systemContext;
            this.bundle = bundle;
        }

        @Override
        public ServiceName getServiceName(Class<?> service) {
            if (service == null) {
                throw new IllegalArgumentException("Null service");
            }
            return ServiceName.of((String[])new String[]{"jbosgi", service.getName()});
        }

        @Override
        public ServiceContainer getServiceContainer() {
            return this.serviceContainer;
        }

        @Override
        public Module getModule() {
            return this.module;
        }

        @Override
        public BundleContext getSystemContext() {
            return this.systemContext;
        }

        @Override
        public Bundle getBundle() {
            return this.bundle;
        }
    }
}

