/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.BundleManager;

public final class OSGiModuleLoader
extends ModuleLoader {
    private Map<ModuleIdentifier, ModuleHolder> modules = new ConcurrentHashMap<ModuleIdentifier, ModuleHolder>();

    public OSGiModuleLoader(BundleManager bundleManager) {
    }

    public ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ModuleHolder holder = this.getModuleHolder(identifier);
        return holder != null ? holder.getModuleSpec() : null;
    }

    public Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        ModuleHolder holder = this.getModuleHolder(identifier);
        if (holder == null) {
            throw new IllegalStateException("Cannot find module: " + identifier);
        }
        Module module = holder.getModule();
        if (module == null) {
            module = super.preloadModule(identifier);
            holder.setModule(module);
        }
        return module;
    }

    public void addModule(AbstractRevision bundleRev, ModuleSpec moduleSpec) {
        ModuleIdentifier identifier = moduleSpec.getModuleIdentifier();
        if (this.modules.get(identifier) != null) {
            throw new IllegalStateException("Module already exists: " + identifier);
        }
        this.modules.put(identifier, new ModuleHolder(bundleRev, moduleSpec));
    }

    public void addModule(AbstractRevision bundleRev, Module module) {
        ModuleIdentifier identifier = module.getIdentifier();
        if (this.modules.get(identifier) != null) {
            throw new IllegalStateException("Module already exists: " + identifier);
        }
        this.modules.put(identifier, new ModuleHolder(bundleRev, module));
    }

    public Module removeModule(ModuleIdentifier identifier) {
        ModuleHolder moduleHolder = this.modules.remove(identifier);
        if (moduleHolder == null) {
            return null;
        }
        Module module = moduleHolder.module;
        if (module.getModuleLoader() == this) {
            this.unloadModuleLocal(module);
        }
        return module;
    }

    public Set<ModuleIdentifier> getModuleIdentifiers() {
        return Collections.unmodifiableSet(this.modules.keySet());
    }

    public AbstractRevision getBundleRevision(ModuleIdentifier identifier) {
        ModuleHolder holder = this.getModuleHolder(identifier);
        return holder != null ? holder.getBundleRevision() : null;
    }

    public AbstractBundle getBundleState(ModuleIdentifier identifier) {
        AbstractRevision bundleRev = this.getBundleRevision(identifier);
        return bundleRev != null ? bundleRev.getBundleState() : null;
    }

    public Module getModule(ModuleIdentifier identifier) {
        ModuleHolder holder = this.getModuleHolder(identifier);
        return holder != null ? holder.getModule() : null;
    }

    private ModuleHolder getModuleHolder(ModuleIdentifier identifier) {
        ModuleHolder holder = this.modules.get(identifier);
        return holder;
    }

    public String toString() {
        return "OSGiModuleLoader";
    }

    static class ModuleHolder {
        private final AbstractRevision bundleRev;
        private ModuleSpec moduleSpec;
        private Module module;

        public ModuleHolder(AbstractRevision bundleRev, ModuleSpec moduleSpec) {
            if (bundleRev == null) {
                throw new IllegalArgumentException("Null bundleRev");
            }
            if (moduleSpec == null) {
                throw new IllegalArgumentException("Null moduleSpec");
            }
            this.bundleRev = bundleRev;
            this.moduleSpec = moduleSpec;
        }

        ModuleHolder(AbstractRevision bundleRev, Module module) {
            if (bundleRev == null) {
                throw new IllegalArgumentException("Null bundleRev");
            }
            if (module == null) {
                throw new IllegalArgumentException("Null module");
            }
            this.bundleRev = bundleRev;
            this.module = module;
        }

        AbstractRevision getBundleRevision() {
            return this.bundleRev;
        }

        ModuleSpec getModuleSpec() {
            return this.moduleSpec;
        }

        Module getModule() {
            return this.module;
        }

        void setModule(Module module) {
            this.module = module;
        }
    }
}

