/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.ServiceReferenceComparator;
import org.jboss.osgi.framework.bundle.ServiceReferenceWrapper;
import org.jboss.osgi.framework.bundle.ServiceRegistrationWrapper;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugin.ServiceManagerPlugin;
import org.jboss.osgi.metadata.CaseInsensitiveDictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class ServiceState
implements ServiceRegistration,
ServiceReference {
    private static final Logger log = Logger.getLogger(ServiceState.class);
    private long serviceId;
    private AbstractBundle ownerBundle;
    private Set<AbstractBundle> usingBundles;
    private List<ServiceName> serviceNames;
    private ServiceRegistration registration;
    private ServiceReference reference;
    private Map<Long, ServiceFactoryHolder> factoryValues;
    private Object value;
    private CaseInsensitiveDictionary prevProperties;
    private CaseInsensitiveDictionary currProperties;
    private ServiceManagerPlugin serviceManager;
    private FrameworkEventsPlugin eventsPlugin;

    public ServiceState(AbstractBundle owner, long serviceId, ServiceName[] serviceNames, String[] clazzes, Object value, Dictionary properties) {
        if (owner == null) {
            throw new IllegalArgumentException("Null owner");
        }
        if (serviceNames == null || serviceNames.length == 0) {
            throw new IllegalArgumentException("Null names");
        }
        if (clazzes == null || clazzes.length == 0) {
            throw new IllegalArgumentException("Null clazzes");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        this.serviceManager = owner.getServiceManagerPlugin();
        this.eventsPlugin = owner.getFrameworkEventsPlugin();
        this.serviceNames = Arrays.asList(serviceNames);
        this.serviceId = serviceId;
        this.ownerBundle = owner;
        this.value = value;
        if (!this.checkValidClassNames(owner, clazzes, value)) {
            throw new IllegalArgumentException("Invalid object class in: " + Arrays.asList(clazzes));
        }
        if (properties == null) {
            properties = new Hashtable<String, Long>();
        }
        ((Dictionary)properties).put("service.id", serviceId);
        ((Dictionary)properties).put("objectClass", (Long)clazzes);
        this.currProperties = new CaseInsensitiveDictionary(properties);
        this.registration = new ServiceRegistrationWrapper(this);
        this.reference = new ServiceReferenceWrapper(this);
    }

    public static ServiceState assertServiceState(ServiceReference sref) {
        if (sref == null) {
            throw new IllegalArgumentException("Null sref");
        }
        if (sref instanceof ServiceReferenceWrapper) {
            sref = ((ServiceReferenceWrapper)sref).getServiceState();
        }
        return (ServiceState)sref;
    }

    public long getServiceId() {
        return this.serviceId;
    }

    public Object getRawValue() {
        return this.value;
    }

    public Object getScopedValue(AbstractBundle bundleState) {
        if (!(this.value instanceof ServiceFactory)) {
            return this.value;
        }
        Object result = null;
        try {
            ServiceFactoryHolder factoryHolder;
            if (this.factoryValues == null) {
                this.factoryValues = new HashMap<Long, ServiceFactoryHolder>();
            }
            if ((factoryHolder = this.factoryValues.get(bundleState.getBundleId())) == null) {
                ServiceFactory factory = (ServiceFactory)this.value;
                factoryHolder = new ServiceFactoryHolder(bundleState, factory);
                this.factoryValues.put(bundleState.getBundleId(), factoryHolder);
            }
            if ((result = factoryHolder.getService()) == null) {
                ServiceException sex = new ServiceException("Cannot get factory value", 2);
                this.eventsPlugin.fireFrameworkEvent(bundleState, 2, (Throwable)sex);
            }
        }
        catch (Throwable th) {
            ServiceException sex = new ServiceException("Cannot get factory value", 3, th);
            this.eventsPlugin.fireFrameworkEvent(bundleState, 2, (Throwable)sex);
        }
        return result;
    }

    public void ungetScopedValue(AbstractBundle bundleState) {
        if (this.value instanceof ServiceFactory) {
            try {
                ServiceFactoryHolder factoryHolder = this.factoryValues.get(bundleState.getBundleId());
                factoryHolder.ungetService();
            }
            catch (RuntimeException rte) {
                ServiceException sex = new ServiceException("Cannot unget factory value", 3, (Throwable)rte);
                this.eventsPlugin.fireFrameworkEvent(bundleState, 16, (Throwable)sex);
            }
        }
    }

    public ServiceRegistration getRegistration() {
        return this.registration;
    }

    public List<ServiceName> getServiceNames() {
        return Collections.unmodifiableList(this.serviceNames);
    }

    public ServiceReference getReference() {
        this.assertNotUnregistered();
        return this.reference;
    }

    public void unregister() {
        this.assertNotUnregistered();
        this.serviceManager.unregisterService(this);
        this.usingBundles = null;
        this.registration = null;
    }

    public Object getProperty(String key) {
        if (key == null) {
            return null;
        }
        return this.currProperties.get((Object)key);
    }

    public String[] getPropertyKeys() {
        ArrayList result = new ArrayList();
        if (this.currProperties != null) {
            Enumeration keys = this.currProperties.keys();
            while (keys.hasMoreElements()) {
                result.add(keys.nextElement());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public void setProperties(Dictionary properties) {
        this.assertNotUnregistered();
        this.prevProperties = this.currProperties;
        if (properties == null) {
            properties = new Hashtable<String, Object>();
        }
        ((Dictionary)properties).put("service.id", this.currProperties.get((Object)"service.id"));
        ((Dictionary)properties).put("objectClass", this.currProperties.get((Object)"objectClass"));
        this.currProperties = new CaseInsensitiveDictionary(properties);
        this.eventsPlugin.fireServiceEvent(this.ownerBundle, 2, this);
    }

    public Dictionary getPreviousProperties() {
        return this.prevProperties;
    }

    public AbstractBundle getServiceOwner() {
        return this.ownerBundle;
    }

    public Bundle getBundle() {
        if (this.isUnregistered()) {
            return null;
        }
        return this.ownerBundle.getBundleWrapper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUsingBundle(AbstractBundle bundleState) {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles == null) {
                this.usingBundles = new HashSet<AbstractBundle>();
            }
            this.usingBundles.add(bundleState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUsingBundle(AbstractBundle bundleState) {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles != null) {
                this.usingBundles.remove(bundleState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<AbstractBundle> getUsingBundlesInternal() {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles == null) {
                return Collections.emptySet();
            }
            return Collections.unmodifiableSet(new HashSet<AbstractBundle>(this.usingBundles));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getUsingBundles() {
        ServiceState serviceState = this;
        synchronized (serviceState) {
            if (this.usingBundles == null) {
                return null;
            }
            HashSet<Bundle> bundles = new HashSet<Bundle>();
            for (AbstractBundle aux : this.usingBundles) {
                bundles.add(aux.getBundleWrapper());
            }
            return bundles.toArray(new Bundle[bundles.size()]);
        }
    }

    public boolean isAssignableTo(Bundle bundle, String className) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (className == null) {
            throw new IllegalArgumentException("Null className");
        }
        if (this.ownerBundle == AbstractBundle.assertBundleState(bundle)) {
            return true;
        }
        Class targetClass = null;
        try {
            targetClass = bundle.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            log.warnf("Requesting bundle cannot load class: %s", (Object)className);
            return true;
        }
        Class ownerClass = null;
        try {
            ownerClass = this.ownerBundle.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            log.warnf("Owner bundle cannot load class: %s", (Object)className);
            return false;
        }
        if (targetClass != ownerClass) {
            log.debugf("Not assignable: %s", (Object)this.value.getClass().getName());
            return false;
        }
        return true;
    }

    public int compareTo(Object sref) {
        if (!(sref instanceof ServiceReference)) {
            throw new IllegalArgumentException("Invalid sref: " + sref);
        }
        Comparator<ServiceReference> comparator = ServiceReferenceComparator.getInstance();
        return comparator.compare(this, (ServiceReference)sref);
    }

    int getServiceRanking() {
        Object prop = this.getProperty("service.ranking");
        if (!(prop instanceof Integer)) {
            return 0;
        }
        return (Integer)prop;
    }

    public boolean isUnregistered() {
        return this.registration == null;
    }

    void assertNotUnregistered() {
        if (this.isUnregistered()) {
            throw new IllegalStateException("Service is unregistered: " + this);
        }
    }

    private boolean checkValidClassNames(AbstractBundle bundleState, String[] classNames, Object value) {
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        if (classNames == null || classNames.length == 0) {
            throw new IllegalArgumentException("Null classNames");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null value");
        }
        if (value instanceof ServiceFactory) {
            return true;
        }
        for (String className : classNames) {
            if (className == null) {
                throw new IllegalArgumentException("Null className");
            }
            try {
                Class clazz = bundleState.loadClass(className);
                if (clazz.isAssignableFrom(value.getClass())) continue;
                log.errorf("Service interface [%s] is not assignable from [%s]", (Object)className, (Object)value.getClass().getName());
                return false;
            }
            catch (ClassNotFoundException ex) {
                log.errorf("Cannot load [%s] from: %s", (Object)className, (Object)bundleState);
                return false;
            }
        }
        return true;
    }

    public String toString() {
        Hashtable<String, List<String>> props = new Hashtable<String, List<String>>((Map<String, List<String>>)this.currProperties);
        String[] classes = (String[])props.get("objectClass");
        props.put("objectClass", Arrays.asList(classes));
        return "ServiceState" + props;
    }

    class ServiceFactoryHolder {
        ServiceFactory factory;
        AbstractBundle bundleState;
        AtomicInteger useCount;
        Object value;

        ServiceFactoryHolder(AbstractBundle bundleState, ServiceFactory factory) {
            this.bundleState = bundleState;
            this.factory = factory;
            this.useCount = new AtomicInteger();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Object getService() {
            if (this.useCount.get() == 0) {
                AbstractBundle abstractBundle = this.bundleState;
                synchronized (abstractBundle) {
                    Object retValue = this.factory.getService(this.bundleState.getBundleWrapper(), ServiceState.this.getRegistration());
                    if (retValue == null) {
                        return null;
                    }
                    if (!ServiceState.this.checkValidClassNames(ServiceState.this.ownerBundle, (String[])ServiceState.this.getProperty("objectClass"), retValue)) {
                        return null;
                    }
                    this.value = retValue;
                }
            }
            this.useCount.incrementAndGet();
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ungetService() {
            if (this.useCount.get() == 0) {
                return;
            }
            if (this.useCount.decrementAndGet() == 0) {
                AbstractBundle abstractBundle = this.bundleState;
                synchronized (abstractBundle) {
                    this.factory.ungetService(this.bundleState.getBundleWrapper(), ServiceState.this.getRegistration(), this.value);
                    this.value = null;
                }
            }
        }
    }
}

