/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractBundleContext;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.BundleStorageState;
import org.jboss.osgi.framework.bundle.SystemBundleContext;
import org.jboss.osgi.framework.bundle.SystemBundleRevision;
import org.jboss.osgi.framework.plugin.BundleStoragePlugin;
import org.jboss.osgi.framework.plugin.SystemPackagesPlugin;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.spi.NotImplementedException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class SystemBundle
extends AbstractBundle {
    private final OSGiMetaData metadata;
    private SystemBundleRevision systemRevision;

    public SystemBundle(BundleManager bundleManager) {
        super(bundleManager, "system.bundle", SystemBundle.getSystemBundleStorage(bundleManager));
        OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)this.getSymbolicName(), (Version)this.getVersion());
        SystemPackagesPlugin plugin = this.getBundleManager().getPlugin(SystemPackagesPlugin.class);
        ArrayList<String> exportedPackages = new ArrayList<String>(plugin.getSystemPackages());
        if (bundleManager.getIntegrationMode() == BundleManager.IntegrationMode.CONTAINER) {
            exportedPackages.addAll(plugin.getFrameworkPackages());
        }
        if (exportedPackages.isEmpty()) {
            throw new IllegalStateException("Framework system packages not available");
        }
        Iterator i$ = exportedPackages.iterator();
        while (i$.hasNext()) {
            String packageSpec;
            String packname = packageSpec = (String)i$.next();
            Version version = Version.emptyVersion;
            int versionIndex = packname.indexOf(";version=");
            if (versionIndex > 0) {
                packname = packageSpec.substring(0, versionIndex);
                version = Version.parseVersion((String)packageSpec.substring(versionIndex + 9));
            }
            builder.addExportPackages(new String[]{packname + ";version=" + version});
        }
        this.metadata = builder.getOSGiMetaData();
    }

    void createSystemBundleRevision() throws BundleException {
        this.systemRevision = new SystemBundleRevision(this, this.metadata);
    }

    void destroySystemBundleRevision() {
        this.systemRevision = null;
    }

    private static BundleStorageState getSystemBundleStorage(BundleManager bundleManager) {
        try {
            BundleStoragePlugin plugin = bundleManager.getPlugin(BundleStoragePlugin.class);
            return plugin.createStorageState(0L, "system.bundle", null);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot create system persistence storage", ex);
        }
    }

    public static SystemBundle assertBundleState(Bundle bundle) {
        AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
        if (!(bundleState instanceof SystemBundle)) {
            throw new IllegalArgumentException("Not a SystemBundle: " + bundleState);
        }
        return (SystemBundle)bundleState;
    }

    @Override
    public OSGiMetaData getOSGiMetaData() {
        return this.metadata;
    }

    @Override
    public boolean isFragment() {
        return false;
    }

    @Override
    public List<XModule> getAllResolverModules() {
        return Collections.singletonList(this.getResolverModule());
    }

    public String getLocation() {
        return "System Bundle";
    }

    @Override
    public boolean ensureResolved() {
        return true;
    }

    @Override
    public void removeFromResolver() {
        this.getResolverPlugin().removeModule(this.getResolverModule());
    }

    @Override
    AbstractBundleContext createContextInternal() {
        return new SystemBundleContext(this);
    }

    @Override
    void startInternal(int options) throws BundleException {
        this.createBundleContext();
    }

    @Override
    void stopInternal(int options) throws BundleException {
        this.destroyBundleContext();
    }

    @Override
    void updateInternal(InputStream input) throws BundleException {
        throw new NotImplementedException();
    }

    @Override
    void uninstallInternal() throws BundleException {
        throw new NotImplementedException();
    }

    @Override
    public AbstractRevision getCurrentRevision() {
        return this.systemRevision;
    }

    @Override
    public Version getVersion() {
        return Version.emptyVersion;
    }
}

