/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.bundle;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.EntriesProvider;
import org.jboss.osgi.vfs.VirtualFile;

public class VirtualFileEntriesProvider
implements EntriesProvider {
    static final Logger log = Logger.getLogger(VirtualFileEntriesProvider.class);
    private final VirtualFile rootFile;

    VirtualFileEntriesProvider(VirtualFile rootFile) {
        if (rootFile == null) {
            throw new IllegalArgumentException("Null rootFile");
        }
        this.rootFile = rootFile;
    }

    @Override
    public Enumeration<String> getEntryPaths(String path) {
        try {
            return this.rootFile.getEntryPaths(path);
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public URL getEntry(String path) {
        try {
            VirtualFile child = this.rootFile.getChild(path);
            return child != null ? child.toURL() : null;
        }
        catch (IOException ex) {
            log.errorf((Throwable)ex, "Cannot get entry: %s", (Object)path);
            return null;
        }
    }

    @Override
    public Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        try {
            return this.rootFile.findEntries(path, pattern, recurse);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

