/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.loading;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Resource;
import org.jboss.osgi.framework.bundle.FragmentRevision;
import org.jboss.osgi.framework.bundle.HostRevision;
import org.jboss.osgi.framework.loading.VirtualFileResourceLoader;
import org.jboss.osgi.vfs.VFSUtils;

public class FragmentLocalLoader
extends ConcurrentClassLoader
implements LocalLoader {
    private static final Logger log = Logger.getLogger(FragmentLocalLoader.class);
    private final FragmentRevision fragRevision;
    private final VirtualFileResourceLoader resourceLoader;
    private final Set<String> paths;

    public FragmentLocalLoader(FragmentRevision fragRevision) {
        if (fragRevision == null) {
            throw new IllegalArgumentException("Null fragmentRev");
        }
        this.fragRevision = fragRevision;
        this.resourceLoader = new VirtualFileResourceLoader(fragRevision.getFirstContentRoot());
        this.paths = Collections.unmodifiableSet(new HashSet<String>(this.resourceLoader.getPaths()));
    }

    public List<HostRevision> getAttachedHosts() {
        return this.fragRevision.getAttachedHosts();
    }

    public Set<String> getPaths() {
        return this.paths;
    }

    public Class<?> loadClassLocal(String className, boolean exportOnly) {
        try {
            return super.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    protected Class<?> findClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        Class result;
        ClassSpec classSpec;
        Class loadedClass = this.findLoadedClass(className);
        if (loadedClass != null) {
            return loadedClass;
        }
        log.tracef("Attempt to find fragment class [%s] in %s ...", (Object)className, (Object)this.fragRevision);
        String path = VFSUtils.getPathFromClassName((String)className);
        if (!this.paths.contains(path)) {
            log.tracef("Not found in fragment [%s]", (Object)className);
            return null;
        }
        try {
            classSpec = this.resourceLoader.getClassSpec(className);
        }
        catch (Throwable th) {
            log.tracef(th, "Unexpected exception in module loader", new Object[0]);
            return null;
        }
        if (classSpec == null) {
            log.tracef("No local specification found for class [%s] in %s", (Object)className, (Object)this.fragRevision);
            return null;
        }
        try {
            byte[] bytes = classSpec.getBytes();
            result = this.defineClass(className, bytes, 0, bytes.length, classSpec.getCodeSource());
        }
        catch (Throwable th) {
            log.tracef(th, "Failed to define class [%s] in %s", (Object)className, (Object)this.fragRevision);
            return null;
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    public List<Resource> loadResourceLocal(String name) {
        Resource result = this.resourceLoader.getResource(name);
        if (result == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(result);
    }

    public Resource loadResourceLocal(String root, String name) {
        Resource result = this.resourceLoader.getResource(root + File.pathSeparator + name);
        return result;
    }
}

