/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.loading;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.logging.Logger;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.Resource;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.vfs.VFSUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

public class ModuleClassLoaderExt
implements LocalLoader,
BundleReference {
    private static final Logger log = Logger.getLogger(ModuleClassLoaderExt.class);
    private static ThreadLocal<Map<String, AtomicInteger>> dynamicLoadAttempts;
    private final ModuleManagerPlugin moduleManager;
    private final BundleManager bundleManager;
    private final ModuleIdentifier id;

    public ModuleClassLoaderExt(BundleManager bundleManager, ModuleIdentifier id) {
        this.bundleManager = bundleManager;
        this.id = id;
        this.moduleManager = bundleManager.getPlugin(ModuleManagerPlugin.class);
    }

    public Bundle getBundle() {
        AbstractBundle bundleState = this.moduleManager.getBundleState(this.id);
        return bundleState.getBundleWrapper();
    }

    public Class<?> loadClassLocal(String className, boolean resolve) {
        Class<?> result;
        String matchingPattern = this.findMatchingDynamicImportPattern(className);
        if (matchingPattern != null && (result = this.loadClassDynamically(className)) != null) {
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClassDynamically(String className) {
        if (dynamicLoadAttempts == null) {
            dynamicLoadAttempts = new ThreadLocal();
        }
        Map<String, AtomicInteger> mapping = dynamicLoadAttempts.get();
        boolean removeThreadLocalMapping = false;
        try {
            AtomicInteger recursiveDepth;
            if (mapping == null) {
                mapping = new HashMap<String, AtomicInteger>();
                dynamicLoadAttempts.set(mapping);
                removeThreadLocalMapping = true;
            }
            if ((recursiveDepth = mapping.get(className)) == null) {
                recursiveDepth = new AtomicInteger();
                mapping.put(className, recursiveDepth);
            }
            if (recursiveDepth.incrementAndGet() == 1) {
                Class<?> result = this.findInResolvedModules(className);
                if (result != null) {
                    Class<?> clazz = result;
                    return clazz;
                }
                result = this.findInUnresolvedModules(className);
                if (result != null) {
                    Class<?> clazz = result;
                    return clazz;
                }
            }
        }
        finally {
            if (removeThreadLocalMapping) {
                dynamicLoadAttempts.remove();
            } else {
                AtomicInteger recursiveDepth = mapping.get(className);
                if (recursiveDepth.decrementAndGet() == 0) {
                    mapping.remove(className);
                }
            }
        }
        return null;
    }

    private String findMatchingDynamicImportPattern(String className) {
        AbstractRevision bundleRev = this.moduleManager.getBundleRevision(this.id);
        XModule resModule = bundleRev.getResolverModule();
        List dynamicRequirements = resModule.getDynamicPackageRequirements();
        if (dynamicRequirements.isEmpty()) {
            return null;
        }
        String foundMatch = null;
        for (XPackageRequirement dynreq : dynamicRequirements) {
            String pattern = dynreq.getName();
            if (pattern.equals("*")) {
                foundMatch = pattern;
                break;
            }
            if (pattern.endsWith(".*")) {
                pattern = pattern.substring(0, pattern.length() - 2);
            }
            pattern = pattern.replace('.', '/');
            String path = VFSUtils.getPathFromClassName((String)className);
            if (!path.startsWith(pattern)) continue;
            foundMatch = pattern;
            break;
        }
        if (foundMatch != null) {
            log.tracef("Found match for class [%s] with Dynamic-ImportPackage pattern: %s", (Object)className, foundMatch);
        } else {
            log.tracef("Class [%s] does not match Dynamic-ImportPackage patterns", (Object)className);
        }
        return foundMatch;
    }

    private Class<?> findInResolvedModules(String className) {
        log.tracef("Attempt to find class dynamically in resolved modules ...", new Object[0]);
        for (ModuleIdentifier aux : this.moduleManager.getModuleIdentifiers()) {
            try {
                Module candidate = this.moduleManager.getModule(aux);
                log.tracef("Attempt to find class dynamically [%s] in %s ...", (Object)className, (Object)candidate);
                ModuleClassLoader classLoader = candidate.getClassLoader();
                Class result = classLoader.loadClass(className);
                log.tracef("Found class [%s] in %s", (Object)className, (Object)candidate);
                return result;
            }
            catch (ClassNotFoundException ex) {
            }
        }
        return null;
    }

    private Class<?> findInUnresolvedModules(String className) {
        log.tracef("Attempt to find class dynamically in unresolved modules ...", new Object[0]);
        for (AbstractBundle aux : this.bundleManager.getBundles()) {
            AbstractBundle bundle;
            if (aux.getState() != 2 || !(bundle = AbstractBundle.assertBundleState(aux)).ensureResolved()) continue;
            ModuleIdentifier identifier = bundle.getModuleIdentifier();
            Module candidate = this.moduleManager.getModule(identifier);
            try {
                log.tracef("Attempt to find class dynamically [%s] in %s ...", (Object)className, (Object)candidate);
                ModuleClassLoader classLoader = candidate.getClassLoader();
                Class result = classLoader.loadClass(className);
                log.tracef("Found class [%s] in %s", (Object)className, (Object)candidate);
                return result;
            }
            catch (ClassNotFoundException ex) {
            }
        }
        return null;
    }

    public List<Resource> loadResourceLocal(String name) {
        return Collections.emptyList();
    }

    public Resource loadResourceLocal(String root, String name) {
        return null;
    }
}

