/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.loading;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Resource;
import org.jboss.osgi.spi.NotImplementedException;
import org.jboss.osgi.vfs.VFSUtils;

public class SystemLocalLoader
implements LocalLoader {
    private static final Logger log = Logger.getLogger(SystemLocalLoader.class);
    private final ClassLoader systemClassLoader;
    private final Set<String> exportedPaths;

    public SystemLocalLoader(Set<String> exportedPaths) {
        if (exportedPaths == null) {
            throw new IllegalArgumentException("Null loaderPaths");
        }
        this.exportedPaths = exportedPaths;
        this.systemClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    public Set<String> getExportedPaths() {
        return Collections.unmodifiableSet(this.exportedPaths);
    }

    public Class<?> loadClassLocal(String className, boolean exportOnly) {
        log.tracef("Attempt to find system class [%s] ...", (Object)className);
        String path = VFSUtils.getPathFromClassName((String)className);
        if (this.exportedPaths.contains(path)) {
            Class<?> result = null;
            try {
                result = this.loadSystemClass(className);
                log.tracef("Found system class [%s]", (Object)className);
                return result;
            }
            catch (ClassNotFoundException ex) {
                log.tracef("Cannot find system class [%s]", (Object)className);
            }
        } else {
            log.tracef("Cannot find filtered class [%s]", (Object)className);
        }
        return null;
    }

    public Class<?> loadSystemClass(String className) throws ClassNotFoundException {
        return this.systemClassLoader.loadClass(className);
    }

    public List<Resource> loadResourceLocal(String name) {
        throw new NotImplementedException();
    }

    public Resource loadResourceLocal(String root, String name) {
        throw new NotImplementedException();
    }
}

