/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.FrameworkState;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.AutoInstallPlugin;
import org.jboss.osgi.spi.util.StringPropertyReplacer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class AutoInstallPluginImpl
extends AbstractPlugin
implements AutoInstallPlugin {
    final Logger log = Logger.getLogger(AutoInstallPluginImpl.class);
    private List<URL> autoInstall;
    private List<URL> autoStart;
    private Map<URL, Bundle> autoBundles;

    public AutoInstallPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    public void setAutoInstall(List<URL> autoInstall) {
        this.autoInstall = autoInstall;
    }

    public void setAutoStart(List<URL> autoStart) {
        this.autoStart = autoStart;
    }

    @Override
    public void initPlugin() {
        URL url;
        FrameworkState framework = this.getBundleManager().getFrameworkState();
        String propValue = framework.getProperty("org.jboss.osgi.auto.install");
        if (propValue != null) {
            for (String path : propValue.split(",")) {
                url = this.toURL(path.trim());
                if (url == null) continue;
                this.addAutoInstall(url);
            }
        }
        if ((propValue = framework.getProperty("org.jboss.osgi.auto.start")) != null) {
            for (String path : propValue.split(",")) {
                url = this.toURL(path.trim());
                if (url == null) continue;
                this.addAutoStart(url);
            }
        }
    }

    @Override
    public void startPlugin() {
        try {
            this.installBundles();
            this.startBundles();
        }
        catch (BundleException ex) {
            throw new IllegalStateException("Cannot start auto install bundles", ex);
        }
    }

    @Override
    public void destroyPlugin() {
        this.autoInstall = null;
        this.autoStart = null;
    }

    @Override
    public void installBundles() throws BundleException {
        if (this.autoStart != null) {
            for (URL bundleURL : this.autoStart) {
                this.addAutoInstall(bundleURL);
            }
        }
        if (this.autoInstall != null) {
            for (URL bundleURL : this.autoInstall) {
                AbstractBundle bundle = this.getBundleManager().installBundle(bundleURL);
                this.registerBundle(bundleURL, bundle);
            }
        }
    }

    @Override
    public void startBundles() throws BundleException {
        if (this.autoStart != null) {
            for (URL bundleURL : this.autoStart) {
                Bundle bundle = this.autoBundles.get(bundleURL);
                if (bundle == null) continue;
                bundle.start();
            }
        }
    }

    private void addAutoInstall(URL bundleURL) {
        if (this.autoInstall == null) {
            this.autoInstall = new ArrayList<URL>();
        }
        this.autoInstall.add(bundleURL);
    }

    private void addAutoStart(URL bundleURL) {
        if (this.autoStart == null) {
            this.autoStart = new ArrayList<URL>();
        }
        this.autoStart.add(bundleURL);
    }

    private void registerBundle(URL bundleURL, Bundle bundle) {
        if (this.autoBundles == null) {
            this.autoBundles = new HashMap<URL, Bundle>();
        }
        this.autoBundles.put(bundleURL, bundle);
    }

    private URL toURL(String path) {
        URL pathURL = null;
        StringPropertyReplacer.PropertyProvider provider = new StringPropertyReplacer.PropertyProvider(){

            public String getProperty(String key) {
                return AutoInstallPluginImpl.this.getBundleManager().getFrameworkState().getProperty(key);
            }
        };
        String realPath = StringPropertyReplacer.replaceProperties((String)path, (StringPropertyReplacer.PropertyProvider)provider);
        try {
            pathURL = new URL(realPath);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (pathURL == null) {
            try {
                File file = new File(realPath);
                if (file.exists()) {
                    pathURL = file.toURI().toURL();
                }
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Invalid path: " + realPath, ex);
            }
        }
        if (pathURL == null) {
            throw new IllegalArgumentException("Invalid path: " + realPath);
        }
        return pathURL;
    }
}

