/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.DefaultDeploymentRegistryService;
import org.jboss.osgi.deployment.deployer.DeployerService;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.deployer.DeploymentRegistryService;
import org.jboss.osgi.deployment.deployer.SystemDeployerService;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.DeployerServicePlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class DeployerServicePluginImpl
extends AbstractPlugin
implements DeployerServicePlugin {
    final Logger log = Logger.getLogger(DeployerServicePluginImpl.class);
    private DeploymentRegistryService registry;
    private DeployerService delegate;

    public DeployerServicePluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void startPlugin() {
        BundleContext sysContext = this.getBundleManager().getSystemContext();
        this.registry = new DefaultDeploymentRegistryService(sysContext);
        sysContext.registerService(DeploymentRegistryService.class.getName(), (Object)this.registry, null);
        this.delegate = new DeployerServiceImpl(sysContext, this.registry);
        Properties props = new Properties();
        props.put("provider", "system");
        sysContext.registerService(DeployerService.class.getName(), (Object)this, (Dictionary)props);
    }

    @Override
    public void stopPlugin() {
        this.registry = null;
        this.delegate = null;
    }

    public Bundle deploy(Deployment bundleDep) throws BundleException {
        return this.delegate.deploy(bundleDep);
    }

    public Bundle undeploy(Deployment bundleDep) throws BundleException {
        return this.delegate.undeploy(bundleDep);
    }

    public void deploy(Deployment[] bundleDeps) throws BundleException {
        this.delegate.deploy(bundleDeps);
    }

    public void undeploy(Deployment[] bundleDeps) throws BundleException {
        this.delegate.undeploy(bundleDeps);
    }

    private class DeployerServiceImpl
    extends SystemDeployerService {
        public DeployerServiceImpl(BundleContext sysContext, DeploymentRegistryService registry) {
            super(sysContext, registry);
        }

        protected Bundle installBundle(Deployment dep) throws BundleException {
            AbstractBundle bundleState = DeployerServicePluginImpl.this.getBundleManager().installBundle(dep);
            return bundleState.getBundleWrapper();
        }
    }
}

