/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.ServiceReferenceWrapper;
import org.jboss.osgi.framework.bundle.ServiceState;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.util.NoFilter;
import org.jboss.osgi.framework.util.RemoveOnlyCollection;
import org.jboss.osgi.spi.util.ConstantsHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.framework.hooks.service.EventHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class FrameworkEventsPluginImpl
extends AbstractPlugin
implements FrameworkEventsPlugin {
    final Logger log = Logger.getLogger(FrameworkEventsPluginImpl.class);
    private boolean active;
    private final Map<Bundle, List<BundleListener>> bundleListeners = new ConcurrentHashMap<Bundle, List<BundleListener>>();
    private final Map<Bundle, List<FrameworkListener>> frameworkListeners = new ConcurrentHashMap<Bundle, List<FrameworkListener>>();
    private final Map<Bundle, List<ServiceListenerRegistration>> serviceListeners = new ConcurrentHashMap<Bundle, List<ServiceListenerRegistration>>();
    private ExecutorService executorService;
    private Set<Integer> asyncBundleEvents = new HashSet<Integer>();
    private Set<String> infoEvents = new HashSet<String>();

    public FrameworkEventsPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
        this.executorService = Executors.newCachedThreadPool();
        this.asyncBundleEvents.add(new Integer(1));
        this.asyncBundleEvents.add(new Integer(32));
        this.asyncBundleEvents.add(new Integer(2));
        this.asyncBundleEvents.add(new Integer(4));
        this.asyncBundleEvents.add(new Integer(8));
        this.asyncBundleEvents.add(new Integer(64));
        this.asyncBundleEvents.add(new Integer(16));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)4));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)2));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)16));
        this.infoEvents.add(ConstantsHelper.frameworkEvent((int)32));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)1));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)2));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)4));
        this.infoEvents.add(ConstantsHelper.bundleEvent((int)16));
    }

    @Override
    public void destroyPlugin() {
        this.setActive(false);
        this.bundleListeners.clear();
        this.serviceListeners.clear();
        this.frameworkListeners.clear();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBundleListener(Bundle bundle, BundleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        bundle = FrameworkEventsPluginImpl.assertBundle(bundle);
        Map<Bundle, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            List<BundleListener> listeners = this.bundleListeners.get(bundle);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<BundleListener>();
                this.bundleListeners.put(bundle, listeners);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundleListener(Bundle bundle, BundleListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        bundle = FrameworkEventsPluginImpl.assertBundle(bundle);
        Map<Bundle, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            List<BundleListener> listeners = this.bundleListeners.get(bundle);
            if (listeners != null) {
                if (listeners.size() > 1) {
                    listeners.remove(listener);
                } else {
                    this.removeBundleListeners(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBundleListeners(Bundle bundle) {
        Map<Bundle, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            bundle = FrameworkEventsPluginImpl.assertBundle(bundle);
            this.bundleListeners.remove(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFrameworkListener(Bundle bundle, FrameworkListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        bundle = FrameworkEventsPluginImpl.assertBundle(bundle);
        Map<Bundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            List<FrameworkListener> listeners = this.frameworkListeners.get(bundle);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<FrameworkListener>();
                this.frameworkListeners.put(bundle, listeners);
            }
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrameworkListener(Bundle bundle, FrameworkListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        bundle = FrameworkEventsPluginImpl.assertBundle(bundle);
        Map<Bundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            List<FrameworkListener> listeners = this.frameworkListeners.get(bundle);
            if (listeners != null) {
                if (listeners.size() > 1) {
                    listeners.remove(listener);
                } else {
                    this.removeFrameworkListeners(bundle);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFrameworkListeners(Bundle bundle) {
        Map<Bundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            bundle = FrameworkEventsPluginImpl.assertBundle(bundle);
            this.frameworkListeners.remove(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addServiceListener(Bundle bundle, ServiceListener listener, String filterstr) throws InvalidSyntaxException {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        bundle = FrameworkEventsPluginImpl.assertBundle(bundle);
        Map<Bundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(bundle);
            if (listeners == null) {
                listeners = new CopyOnWriteArrayList<ServiceListenerRegistration>();
                this.serviceListeners.put(bundle, listeners);
            }
            this.removeServiceListener(bundle, listener);
            Filter filter = filterstr != null ? FrameworkUtil.createFilter((String)filterstr) : NoFilter.INSTANCE;
            ServiceListenerRegistration slreg = new ServiceListenerRegistration(bundle, listener, filter);
            for (ListenerHook hook : this.getServiceListenerHooks()) {
                try {
                    hook.added(Collections.singleton(slreg.getListenerInfo()));
                }
                catch (RuntimeException ex) {
                    this.log.errorf((Throwable)ex, "Error processing ListenerHook: %s", (Object)hook);
                }
            }
            listeners.add(slreg);
        }
    }

    @Override
    public Collection<ListenerHook.ListenerInfo> getServiceListenerInfos(Bundle bundle) {
        ArrayList<ListenerHook.ListenerInfo> listeners = new ArrayList<ListenerHook.ListenerInfo>();
        for (Map.Entry<Bundle, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
            if (bundle != null && !FrameworkEventsPluginImpl.assertBundle(bundle).equals(entry.getKey())) continue;
            for (ServiceListenerRegistration aux : entry.getValue()) {
                ListenerHook.ListenerInfo info = aux.getListenerInfo();
                listeners.add(info);
            }
        }
        return Collections.unmodifiableCollection(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListener(Bundle bundle, ServiceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        bundle = FrameworkEventsPluginImpl.assertBundle(bundle);
        Map<Bundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            ServiceListenerRegistration slreg;
            int index;
            List<ServiceListenerRegistration> listeners = this.serviceListeners.get(bundle);
            if (listeners != null && (index = listeners.indexOf(slreg = new ServiceListenerRegistration(bundle, listener, NoFilter.INSTANCE))) >= 0) {
                slreg = listeners.remove(index);
                for (ListenerHook hook : this.getServiceListenerHooks()) {
                    try {
                        ListenerInfoImpl info = (ListenerInfoImpl)slreg.getListenerInfo();
                        info.setRemoved(true);
                        hook.removed(Collections.singleton(info));
                    }
                    catch (RuntimeException ex) {
                        this.log.errorf((Throwable)ex, "Error processing ListenerHook: %s", (Object)hook);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeServiceListeners(Bundle bundle) {
        Map<Bundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            Collection<ListenerHook.ListenerInfo> listenerInfos = this.getServiceListenerInfos(bundle);
            this.serviceListeners.remove(FrameworkEventsPluginImpl.assertBundle(bundle));
            for (ListenerHook hook : this.getServiceListenerHooks()) {
                try {
                    hook.removed(listenerInfos);
                }
                catch (RuntimeException ex) {
                    this.log.errorf((Throwable)ex, "Error processing ListenerHook: %s", (Object)hook);
                }
            }
        }
    }

    private List<ListenerHook> getServiceListenerHooks() {
        BundleContext context = this.getBundleManager().getSystemContext();
        ServiceReference[] srefs = null;
        try {
            srefs = context.getServiceReferences(ListenerHook.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (srefs == null) {
            return Collections.emptyList();
        }
        ArrayList<ListenerHook> hooks = new ArrayList<ListenerHook>();
        for (ServiceReference sref : srefs) {
            hooks.add((ListenerHook)context.getService(sref));
        }
        return Collections.unmodifiableList(hooks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireBundleEvent(final Bundle bundle, final int type) {
        final ArrayList<BundleListener> listeners = new ArrayList<BundleListener>();
        Map<Bundle, List<BundleListener>> map = this.bundleListeners;
        synchronized (map) {
            for (Map.Entry<Bundle, List<BundleListener>> entry : this.bundleListeners.entrySet()) {
                for (BundleListener listener : entry.getValue()) {
                    listeners.add(listener);
                }
            }
        }
        final BundleEventImpl event = new BundleEventImpl(type, FrameworkEventsPluginImpl.assertBundle(bundle));
        final String typeName = ConstantsHelper.bundleEvent((int)event.getType());
        this.log.tracef("Bundle %s: %s", (Object)typeName, (Object)bundle);
        if (!this.getBundleManager().isFrameworkActive()) {
            return;
        }
        if (listeners.isEmpty()) {
            return;
        }
        for (BundleListener listener : listeners) {
            try {
                if (!(listener instanceof SynchronousBundleListener)) continue;
                listener.bundleChanged((BundleEvent)event);
            }
            catch (Throwable th) {
                this.log.warnf(th, "Error while firing %s for bundle: %s", (Object)typeName, (Object)bundle);
            }
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (FrameworkEventsPluginImpl.this.asyncBundleEvents.contains(type)) {
                    for (BundleListener listener : listeners) {
                        try {
                            if (listener instanceof SynchronousBundleListener) continue;
                            listener.bundleChanged(event);
                        }
                        catch (Throwable th) {
                            FrameworkEventsPluginImpl.this.log.warnf(th, "Error while firing %s for bundle: ", (Object)typeName, (Object)bundle);
                        }
                    }
                }
            }
        };
        this.fireEvent(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireFrameworkEvent(final Bundle bundle, final int type, Throwable th) {
        final ArrayList<FrameworkListener> listeners = new ArrayList<FrameworkListener>();
        Map<Bundle, List<FrameworkListener>> map = this.frameworkListeners;
        synchronized (map) {
            for (Map.Entry<Bundle, List<FrameworkListener>> entry : this.frameworkListeners.entrySet()) {
                for (FrameworkListener listener : entry.getValue()) {
                    listeners.add(listener);
                }
            }
        }
        final FrameworkEventImpl event = new FrameworkEventImpl(type, FrameworkEventsPluginImpl.assertBundle(bundle), th);
        final String typeName = ConstantsHelper.frameworkEvent((int)event.getType());
        switch (event.getType()) {
            case 2: {
                this.log.errorf(th, "Framwork %s", (Object)typeName);
                break;
            }
            case 16: {
                this.log.warnf(th, "Framwork %s", (Object)typeName);
                break;
            }
            default: {
                this.log.tracef(th, "Framwork %s", (Object)typeName);
            }
        }
        if (!this.getBundleManager().isFrameworkActive()) {
            return;
        }
        if (listeners.isEmpty()) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (FrameworkListener listener : listeners) {
                    try {
                        listener.frameworkEvent(event);
                    }
                    catch (RuntimeException ex) {
                        FrameworkEventsPluginImpl.this.log.warnf((Throwable)ex, "Error while firing %s for framework", (Object)typeName);
                        if (type == 2) continue;
                        FrameworkEventsPluginImpl.this.fireFrameworkEvent(bundle, 2, ex);
                    }
                    catch (Throwable th) {
                        FrameworkEventsPluginImpl.this.log.warnf(th, "Error while firing %s for framework", (Object)typeName);
                    }
                }
            }
        };
        this.fireEvent(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fireServiceEvent(Bundle bundle, int type, ServiceState serviceState) {
        List<ServiceListenerRegistration> listeners = new ArrayList<ServiceListenerRegistration>();
        Map<Bundle, List<ServiceListenerRegistration>> map = this.serviceListeners;
        synchronized (map) {
            for (Map.Entry<Bundle, List<ServiceListenerRegistration>> entry : this.serviceListeners.entrySet()) {
                for (ServiceListenerRegistration listener : entry.getValue()) {
                    BundleContext context = listener.getBundleContext();
                    if (context == null) continue;
                    listeners.add(listener);
                }
            }
        }
        ServiceEventImpl event = new ServiceEventImpl(type, new ServiceReferenceWrapper(serviceState));
        String typeName = ConstantsHelper.serviceEvent((int)event.getType());
        this.log.tracef("Service %s: %s", (Object)typeName, (Object)serviceState);
        if (!this.getBundleManager().isFrameworkActive()) {
            return;
        }
        if ((listeners = this.processEventHooks(listeners, event)).isEmpty()) {
            return;
        }
        for (ServiceListenerRegistration listener : listeners) {
            try {
                String filterstr = listener.filter.toString();
                if (listener.filter.match((ServiceReference)serviceState)) {
                    listener.listener.serviceChanged((ServiceEvent)event);
                    continue;
                }
                if (filterstr == null || 2 != event.getType() || !listener.filter.match(serviceState.getPreviousProperties())) continue;
                event = new ServiceEventImpl(8, new ServiceReferenceWrapper(serviceState));
                listener.listener.serviceChanged((ServiceEvent)event);
            }
            catch (Throwable th) {
                this.log.warnf(th, "Error while firing %s for service: %s", (Object)typeName, (Object)serviceState);
            }
        }
    }

    private List<ServiceListenerRegistration> processEventHooks(List<ServiceListenerRegistration> listeners, ServiceEvent event) {
        Collection<BundleContext> contexts = new HashSet();
        for (ServiceListenerRegistration listener : listeners) {
            BundleContext context = listener.getBundleContext();
            if (context == null) continue;
            contexts.add(context);
        }
        contexts = new RemoveOnlyCollection(contexts);
        List<EventHook> eventHooks = this.getEventHooks();
        for (EventHook hook : eventHooks) {
            try {
                hook.event(event, contexts);
            }
            catch (Exception ex) {
                this.log.warnf((Throwable)ex, "Error while calling EventHook: %s", (Object)hook);
            }
        }
        if (contexts.size() != listeners.size()) {
            Iterator<ServiceListenerRegistration> it = listeners.iterator();
            while (it.hasNext()) {
                ServiceListenerRegistration slreg = it.next();
                if (contexts.contains(slreg.getBundleContext())) continue;
                it.remove();
            }
        }
        return listeners;
    }

    private List<EventHook> getEventHooks() {
        ArrayList<EventHook> hooks = new ArrayList<EventHook>();
        BundleContext context = this.getBundleManager().getSystemContext();
        ServiceReference[] srefs = null;
        try {
            srefs = context.getServiceReferences(EventHook.class.getName(), null);
        }
        catch (InvalidSyntaxException e) {
            // empty catch block
        }
        if (srefs != null) {
            ArrayList<ServiceReference> sortedRefs = new ArrayList<ServiceReference>(Arrays.asList(srefs));
            Collections.reverse(sortedRefs);
            for (ServiceReference sref : sortedRefs) {
                hooks.add((EventHook)context.getService(sref));
            }
        }
        return hooks;
    }

    private static Bundle assertBundle(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Null bundle");
        }
        if (bundle instanceof AbstractBundle) {
            bundle = ((AbstractBundle)bundle).getBundleWrapper();
        }
        return bundle;
    }

    private void fireEvent(Runnable runnable) {
        this.executorService.execute(runnable);
    }

    static class ServiceEventImpl
    extends ServiceEvent {
        private static final long serialVersionUID = 62018288275708239L;

        public ServiceEventImpl(int type, ServiceReference sref) {
            super(type, sref);
            if (sref instanceof ServiceState) {
                throw new IllegalArgumentException("Event must expose impl details");
            }
        }

        public String toString() {
            return "ServiceEvent[type=" + ConstantsHelper.serviceEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class BundleEventImpl
    extends BundleEvent {
        private static final long serialVersionUID = -2705304702665185935L;

        public BundleEventImpl(int type, Bundle bundle) {
            super(type, bundle);
            if (bundle instanceof AbstractBundle) {
                throw new IllegalArgumentException("Event must expose impl details");
            }
        }

        public String toString() {
            return "BundleEvent[type=" + ConstantsHelper.bundleEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class FrameworkEventImpl
    extends FrameworkEvent {
        private static final long serialVersionUID = 6505331543651318189L;

        public FrameworkEventImpl(int type, Bundle bundle, Throwable throwable) {
            super(type, bundle, throwable);
            if (bundle instanceof AbstractBundle) {
                throw new IllegalArgumentException("Event must expose impl details");
            }
        }

        public String toString() {
            return "FrameworkEvent[type=" + ConstantsHelper.frameworkEvent((int)this.getType()) + ",source=" + this.getSource() + "]";
        }
    }

    static class ListenerInfoImpl
    implements ListenerHook.ListenerInfo {
        private BundleContext context;
        private ServiceListener listener;
        private String filter;
        private boolean removed;

        ListenerInfoImpl(ServiceListenerRegistration slreg) {
            this.context = slreg.bundle.getBundleContext();
            this.listener = slreg.listener;
            this.filter = slreg.filter.toString();
        }

        public BundleContext getBundleContext() {
            return this.context;
        }

        public String getFilter() {
            return this.filter;
        }

        public boolean isRemoved() {
            return this.removed;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "ListenerInfo[" + this.context + "," + className + "," + this.removed + "]";
        }
    }

    static class ServiceListenerRegistration {
        private Bundle bundle;
        private ServiceListener listener;
        private Filter filter;
        private ListenerHook.ListenerInfo info;
        AccessControlContext accessControlContext;

        ServiceListenerRegistration(Bundle bundle, ServiceListener listener, Filter filter) {
            if (bundle == null) {
                throw new IllegalArgumentException("Null bundle");
            }
            if (listener == null) {
                throw new IllegalArgumentException("Null listener");
            }
            if (filter == null) {
                throw new IllegalArgumentException("Null filter");
            }
            this.bundle = FrameworkEventsPluginImpl.assertBundle(bundle);
            this.listener = listener;
            this.filter = filter;
            this.info = new ListenerInfoImpl(this);
            if (System.getSecurityManager() != null) {
                this.accessControlContext = AccessController.getContext();
            }
        }

        public BundleContext getBundleContext() {
            return this.bundle.getBundleContext();
        }

        public ListenerHook.ListenerInfo getListenerInfo() {
            return this.info;
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ServiceListenerRegistration)) {
                return false;
            }
            ServiceListenerRegistration other = (ServiceListenerRegistration)obj;
            return other.listener.equals(this.listener);
        }

        public String toString() {
            String className = this.listener.getClass().getName();
            return "ServiceListener[" + this.bundle + "," + className + "," + this.filter + "]";
        }
    }
}

