/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import org.jboss.logging.Logger;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptorService;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorService;
import org.jboss.osgi.deployment.internal.InvocationContextImpl;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.LifecycleInterceptorPlugin;
import org.jboss.osgi.spi.Attachments;
import org.jboss.osgi.spi.util.AttachmentSupport;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class LifecycleInterceptorPluginImpl
extends AbstractPlugin
implements LifecycleInterceptorPlugin {
    final Logger log = Logger.getLogger(LifecycleInterceptorPluginImpl.class);
    private AbstractLifecycleInterceptorService delegate;
    private ServiceRegistration registration;

    public LifecycleInterceptorPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void startPlugin() {
        BundleContext sysContext = this.getBundleManager().getSystemContext();
        this.delegate = new AbstractLifecycleInterceptorService(sysContext){

            protected InvocationContext getInvocationContext(Bundle bundle) {
                AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
                if (bundleState == null) {
                    throw new IllegalStateException("Cannot obtain bundleState for: " + bundle);
                }
                AbstractUserBundle userBundle = AbstractUserBundle.assertBundleState(bundleState);
                Deployment dep = userBundle.getDeployment();
                InvocationContext inv = (InvocationContext)dep.getAttachment(InvocationContext.class);
                if (inv == null) {
                    BundleContext context = userBundle.getBundleManager().getSystemContext();
                    VirtualFile rootFile = userBundle.getFirstContentRoot();
                    LifecycleInterceptorAttachments att = new LifecycleInterceptorAttachments();
                    inv = new InvocationContextImpl(context, bundle, rootFile, (Attachments)att);
                    dep.addAttachment(InvocationContext.class, (Object)inv);
                }
                return inv;
            }
        };
        this.registration = sysContext.registerService(LifecycleInterceptorService.class.getName(), (Object)this.delegate, null);
    }

    @Override
    public void stopPlugin() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
            this.delegate = null;
        }
    }

    @Override
    public void handleStateChange(int state, Bundle bundle) {
        if (this.delegate != null) {
            this.delegate.handleStateChange(state, bundle);
        }
    }

    static class LifecycleInterceptorAttachments
    extends AttachmentSupport {
        LifecycleInterceptorAttachments() {
        }
    }
}

