/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleLogger;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PathFilter;
import org.jboss.modules.PathFilters;
import org.jboss.modules.ResourceLoader;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.FragmentRevision;
import org.jboss.osgi.framework.bundle.HostBundle;
import org.jboss.osgi.framework.bundle.OSGiModuleLoader;
import org.jboss.osgi.framework.loading.FragmentLocalLoader;
import org.jboss.osgi.framework.loading.FrameworkLocalLoader;
import org.jboss.osgi.framework.loading.JBossLoggingModuleLogger;
import org.jboss.osgi.framework.loading.ModuleClassLoaderExt;
import org.jboss.osgi.framework.loading.NativeResourceLoader;
import org.jboss.osgi.framework.loading.VirtualFileResourceLoader;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.framework.plugin.SystemPackagesPlugin;
import org.jboss.osgi.framework.plugin.internal.NativeCodePluginImpl;
import org.jboss.osgi.metadata.NativeLibrary;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequireBundleRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XWire;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.Bundle;

public class ModuleManagerPluginImpl
extends AbstractPlugin
implements ModuleManagerPlugin {
    final Logger log = Logger.getLogger(ModuleManagerPluginImpl.class);
    private OSGiModuleLoader moduleLoader;
    private ModuleIdentifier frameworkIdentifier;
    private Module frameworkModule;

    public ModuleManagerPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void initPlugin() {
        this.moduleLoader = new OSGiModuleLoader(this.getBundleManager());
        if (this.getBundleManager().getIntegrationMode() == BundleManager.IntegrationMode.STANDALONE) {
            Module.setModuleLogger((ModuleLogger)new JBossLoggingModuleLogger(Logger.getLogger(ModuleClassLoader.class)));
        }
    }

    @Override
    public void destroyPlugin() {
        this.moduleLoader = null;
        this.frameworkModule = null;
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return this.moduleLoader;
    }

    @Override
    public ModuleIdentifier getModuleIdentifier(XModule resModule) {
        ModuleIdentifier identifier;
        if (resModule.isFragment()) {
            throw new IllegalArgumentException("A fragment is not a module");
        }
        ModuleIdentifier id = (ModuleIdentifier)resModule.getAttachment(ModuleIdentifier.class);
        if (id != null) {
            return id;
        }
        Module module = (Module)resModule.getAttachment(Module.class);
        ModuleIdentifier moduleIdentifier = identifier = module != null ? module.getIdentifier() : null;
        if (identifier == null) {
            XModuleIdentity moduleId = resModule.getModuleId();
            if (this.frameworkIdentifier != null && "system.bundle".equals(moduleId.getName())) {
                identifier = this.frameworkIdentifier;
            }
            if (identifier == null) {
                String slot = moduleId.getVersion().toString();
                int revision = moduleId.getRevision();
                if (revision > 0) {
                    slot = slot + "-rev" + revision;
                }
                String name = "jbosgi." + moduleId.getName();
                identifier = ModuleIdentifier.create((String)name, (String)slot);
            }
        }
        resModule.addAttachment(ModuleIdentifier.class, (Object)identifier);
        return identifier;
    }

    @Override
    public Set<ModuleIdentifier> getModuleIdentifiers() {
        return this.moduleLoader.getModuleIdentifiers();
    }

    @Override
    public Module getModule(ModuleIdentifier identifier) {
        if (identifier.equals(this.frameworkIdentifier) && this.frameworkModule != null) {
            return this.frameworkModule;
        }
        return this.moduleLoader.getModule(identifier);
    }

    @Override
    public AbstractRevision getBundleRevision(ModuleIdentifier identifier) {
        return this.moduleLoader.getBundleRevision(identifier);
    }

    @Override
    public AbstractBundle getBundleState(ModuleIdentifier identifier) {
        return this.moduleLoader.getBundleState(identifier);
    }

    @Override
    public ModuleIdentifier addModule(XModule resModule) {
        ModuleIdentifier identifier;
        if (resModule == null) {
            throw new IllegalArgumentException("Null module");
        }
        Module module = (Module)resModule.getAttachment(Module.class);
        if (module == null) {
            if (resModule.getModuleId().getName().equals("system.bundle")) {
                identifier = this.createFrameworkModule(resModule);
            } else {
                Bundle bundle = (Bundle)resModule.getAttachment(Bundle.class);
                HostBundle bundleState = HostBundle.assertBundleState(bundle);
                List<VirtualFile> contentRoots = bundleState.getContentRoots();
                identifier = this.createModule(resModule, contentRoots);
            }
        } else {
            AbstractRevision bundleRev = (AbstractRevision)resModule.getAttachment(AbstractRevision.class);
            this.moduleLoader.addModule(bundleRev, module);
            identifier = module.getIdentifier();
        }
        return identifier;
    }

    private ModuleIdentifier createFrameworkModule(XModule resModule) {
        if (resModule == null || !resModule.getName().equals("system.bundle")) {
            throw new IllegalArgumentException("Invalid resolver module: " + resModule);
        }
        Module providedModule = (Module)this.getBundleManager().getProperty(Module.class.getName());
        AbstractRevision bundleRev = (AbstractRevision)resModule.getAttachment(AbstractRevision.class);
        if (providedModule != null) {
            this.frameworkIdentifier = providedModule.getIdentifier();
            this.frameworkModule = providedModule;
        } else {
            this.frameworkIdentifier = DEFAULT_FRAMEWORK_IDENTIFIER;
            ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)DEFAULT_FRAMEWORK_IDENTIFIER);
            FrameworkLocalLoader frameworkLoader = new FrameworkLocalLoader(this.getBundleManager());
            specBuilder.addDependency(DependencySpec.createLocalDependencySpec((LocalLoader)frameworkLoader, frameworkLoader.getExportedPaths(), (boolean)true));
            ModuleSpec frameworkSpec = specBuilder.create();
            this.moduleLoader.addModule(bundleRev, frameworkSpec);
        }
        return this.frameworkIdentifier;
    }

    private ModuleIdentifier createModule(XModule resModule, List<VirtualFile> contentRoots) {
        ModuleSpec moduleSpec = (ModuleSpec)resModule.getAttachment(ModuleSpec.class);
        if (moduleSpec == null) {
            ModuleIdentifier identifier = this.getModuleIdentifier(resModule);
            ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)identifier);
            PathFilter importFilter = PathFilters.acceptAll();
            PathFilter exportFilter = PathFilters.in(this.getPlugin(SystemPackagesPlugin.class).getExportedPaths());
            ModuleLoader frameworkLoader = this.getModule(this.frameworkIdentifier).getModuleLoader();
            DependencySpec frameworkDep = DependencySpec.createModuleDependencySpec((PathFilter)importFilter, (PathFilter)exportFilter, (ModuleLoader)frameworkLoader, (ModuleIdentifier)this.frameworkIdentifier, (boolean)false);
            specBuilder.addDependency(frameworkDep);
            LinkedHashMap<XModule, DependencyHolder> specHolderMap = new LinkedHashMap<XModule, DependencyHolder>();
            HostBundle hostBundle = (HostBundle)resModule.getAttachment(HostBundle.class);
            if (resModule.getWires().isEmpty() && hostBundle != null) {
                List<FragmentRevision> fragRevs = hostBundle.getCurrentRevision().getAttachedFragments();
                for (FragmentRevision fragRev : fragRevs) {
                    List fragWires = fragRev.getResolverModule().getWires();
                    this.processModuleWires(fragWires, specHolderMap);
                    FragmentLocalLoader localLoader = new FragmentLocalLoader(fragRev);
                    specHolderMap.put(fragRev.getResolverModule(), new LocalDependencyHolder(localLoader, localLoader.getPaths()));
                }
            }
            this.processModuleWires(resModule.getWires(), specHolderMap);
            for (DependencyHolder aux : specHolderMap.values()) {
                specBuilder.addDependency(aux.create());
            }
            for (VirtualFile contentRoot : contentRoots) {
                specBuilder.addResourceRoot((ResourceLoader)new VirtualFileResourceLoader(contentRoot));
            }
            specBuilder.addDependency(DependencySpec.createLocalDependencySpec());
            Bundle bundle = (Bundle)resModule.getAttachment(Bundle.class);
            AbstractUserBundle bundleState = AbstractUserBundle.assertBundleState(bundle);
            Deployment deployment = bundleState.getDeployment();
            NativeLibraryMetaData libMetaData = (NativeLibraryMetaData)deployment.getAttachment(NativeLibraryMetaData.class);
            if (libMetaData != null) {
                NativeResourceLoader nativeLoader = new NativeResourceLoader();
                for (NativeLibrary library : libMetaData.getNativeLibraries()) {
                    String libpath = library.getLibraryPath();
                    String libfile = new File(libpath).getName();
                    String libname = libfile.substring(0, libfile.lastIndexOf(46));
                    NativeCodePluginImpl.BundleNativeLibraryProvider libProvider = new NativeCodePluginImpl.BundleNativeLibraryProvider(bundleState, libname, libpath);
                    nativeLoader.addNativeLibrary(libProvider);
                    if (!libname.startsWith("lib")) continue;
                    libname = libname.substring(3);
                    libProvider = new NativeCodePluginImpl.BundleNativeLibraryProvider(bundleState, libname, libpath);
                    nativeLoader.addNativeLibrary(libProvider);
                }
                specBuilder.addResourceRoot((ResourceLoader)nativeLoader);
            }
            specBuilder.setFallbackLoader((LocalLoader)new ModuleClassLoaderExt(this.getBundleManager(), identifier));
            moduleSpec = specBuilder.create();
        }
        AbstractRevision bundleRev = (AbstractRevision)resModule.getAttachment(AbstractRevision.class);
        this.moduleLoader.addModule(bundleRev, moduleSpec);
        return moduleSpec.getModuleIdentifier();
    }

    private void processModuleWires(List<XWire> wires, Map<XModule, DependencyHolder> depBuilderMap) {
        for (XWire wire : wires) {
            ModuleDependencyHolder holder;
            ModuleIdentifier exporterId;
            XRequirement req = wire.getRequirement();
            XModule importer = wire.getImporter();
            XModule exporter = wire.getExporter();
            if (exporter == importer || (exporterId = this.getModuleIdentifier(exporter)).equals(this.frameworkIdentifier)) continue;
            if (req instanceof XPackageRequirement) {
                holder = this.getDependencyHolder(depBuilderMap, exporter);
                holder.addImportPath(VFSUtils.getPathFromPackageName((String)req.getName()));
                continue;
            }
            if (!(req instanceof XRequireBundleRequirement)) continue;
            holder = this.getDependencyHolder(depBuilderMap, exporter);
            XRequireBundleRequirement bndreq = (XRequireBundleRequirement)req;
            boolean reexport = "reexport".equals(bndreq.getVisibility());
            if (!reexport) continue;
            holder.setExportFilter(PathFilters.acceptAll());
        }
    }

    private ModuleDependencyHolder getDependencyHolder(Map<XModule, DependencyHolder> depBuilderMap, XModule exporter) {
        ModuleIdentifier exporterId = this.getModuleIdentifier(exporter);
        ModuleDependencyHolder holder = (ModuleDependencyHolder)depBuilderMap.get(exporter);
        if (holder == null) {
            holder = new ModuleDependencyHolder(exporterId);
            depBuilderMap.put(exporter, holder);
        }
        return holder;
    }

    @Override
    public Module loadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        if (!identifier.equals(this.frameworkIdentifier)) {
            return this.moduleLoader.loadModule(identifier);
        }
        if (this.frameworkModule == null) {
            this.frameworkModule = this.moduleLoader.loadModule(this.frameworkIdentifier);
        }
        return this.frameworkModule;
    }

    @Override
    public Module removeModule(ModuleIdentifier identifier) {
        return this.moduleLoader.removeModule(identifier);
    }

    class LocalDependencyHolder
    extends DependencyHolder {
        private LocalLoader localLoader;
        private Set<String> loaderPaths;

        LocalDependencyHolder(LocalLoader localLoader, Set<String> loaderPaths) {
            this.localLoader = localLoader;
            this.loaderPaths = loaderPaths;
        }

        @Override
        DependencySpec createInternal() {
            PathFilter importFilter = PathFilters.acceptAll();
            PathFilter exportFilter = PathFilters.in(this.loaderPaths);
            return DependencySpec.createLocalDependencySpec((PathFilter)importFilter, (PathFilter)exportFilter, (LocalLoader)this.localLoader, this.loaderPaths);
        }
    }

    class ModuleDependencyHolder
    extends DependencyHolder {
        private ModuleIdentifier identifier;
        private Set<String> importPaths;
        private PathFilter exportFilter;
        private boolean optional;

        ModuleDependencyHolder(ModuleIdentifier identifier) {
            this.exportFilter = PathFilters.rejectAll();
            this.identifier = identifier;
        }

        void addImportPath(String path) {
            this.assertNotCreated();
            if (this.importPaths == null) {
                this.importPaths = new HashSet<String>();
            }
            this.importPaths.add(path);
        }

        void setExportFilter(PathFilter exportFilter) {
            this.assertNotCreated();
            this.exportFilter = exportFilter;
        }

        void setOptional(boolean optional) {
            this.assertNotCreated();
            this.optional = optional;
        }

        @Override
        DependencySpec createInternal() {
            PathFilter importFilter = this.importPaths != null ? PathFilters.in(this.importPaths) : PathFilters.acceptAll();
            return DependencySpec.createModuleDependencySpec((PathFilter)importFilter, (PathFilter)this.exportFilter, (ModuleLoader)ModuleManagerPluginImpl.this.moduleLoader, (ModuleIdentifier)this.identifier, (boolean)this.optional);
        }
    }

    abstract class DependencyHolder {
        private DependencySpec dependencySpec;

        DependencyHolder() {
        }

        DependencySpec create() {
            this.assertNotCreated();
            this.dependencySpec = this.createInternal();
            return this.dependencySpec;
        }

        abstract DependencySpec createInternal();

        void assertNotCreated() {
            if (this.dependencySpec != null) {
                throw new IllegalStateException("DependencySpec already created");
            }
        }
    }
}

