/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.FrameworkState;
import org.jboss.osgi.framework.loading.NativeLibraryProvider;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.BundleStoragePlugin;
import org.jboss.osgi.framework.plugin.NativeCodePlugin;
import org.jboss.osgi.metadata.NativeLibrary;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;

public class NativeCodePluginImpl
extends AbstractPlugin
implements NativeCodePlugin {
    private static Map<String, String> processorAlias = new HashMap<String, String>();
    private static Map<String, String> osAlias;

    public NativeCodePluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void deployNativeCode(Deployment dep) {
        AbstractBundle bundleState = (AbstractBundle)dep.getAttachment(AbstractBundle.class);
        if (bundleState == null) {
            throw new IllegalStateException("Cannot obtain Bundle from: " + dep);
        }
        OSGiMetaData osgiMetaData = bundleState.getOSGiMetaData();
        List nativeCodeParams = osgiMetaData.getBundleNativeCode();
        if (nativeCodeParams == null) {
            throw new IllegalArgumentException("Cannot find Bundle-NativeCode header for: " + bundleState);
        }
        ArrayList<ParameterizedAttribute> matchedParams = new ArrayList<ParameterizedAttribute>();
        for (ParameterizedAttribute param : nativeCodeParams) {
            if (!this.matchParameter(param)) continue;
            matchedParams.add(param);
        }
        if (matchedParams.size() == 0) {
            throw new IllegalStateException("No native clauses selected from: " + nativeCodeParams);
        }
        if (matchedParams.size() > 1) {
            // empty if block
        }
        NativeLibraryMetaData nativeLibraries = new NativeLibraryMetaData();
        dep.addAttachment(NativeLibraryMetaData.class, (Object)nativeLibraries);
        for (ParameterizedAttribute param : matchedParams) {
            Parameter osnameParam = param.getAttribute("osname");
            Parameter procParam = param.getAttribute("processor");
            List<String> osNames = osnameParam.isCollection() ? (List<String>)osnameParam.getValue() : Collections.singletonList((String)osnameParam.getValue());
            String libpath = param.getAttribute();
            String libsource = bundleState.getCanonicalName();
            NativeLibrary library = new NativeLibrary(osNames, libpath, libsource);
            if (procParam != null) {
                List<String> processors = procParam.isCollection() ? (List<String>)procParam.getValue() : Collections.singletonList((String)procParam.getValue());
                library.setProcessors(processors);
            }
            nativeLibraries.addNativeLibrary(library);
        }
    }

    @Override
    public void resolveNativeCode(AbstractUserBundle depBundle) {
    }

    private boolean matchParameter(ParameterizedAttribute param) {
        Iterator<String> i$;
        boolean match;
        FrameworkState frameworkState = this.getBundleManager().getFrameworkState();
        String fwOSName = frameworkState.getProperty("org.osgi.framework.os.name");
        String fwProcessor = frameworkState.getProperty("org.osgi.framework.processor");
        Parameter osnameParam = param.getAttribute("osname");
        Parameter procParam = param.getAttribute("processor");
        boolean bl = match = osnameParam != null;
        if (match && osnameParam != null) {
            String osname;
            List<String> osNames = osnameParam.isCollection() ? (List<String>)osnameParam.getValue() : Collections.singletonList((String)osnameParam.getValue());
            boolean osmatch = false;
            i$ = osNames.iterator();
            while (i$.hasNext() && !(osmatch = (osname = i$.next()).equalsIgnoreCase(fwOSName) || osname.equalsIgnoreCase(osAlias.get(fwOSName)))) {
            }
            match &= osmatch;
        }
        if ((match &= procParam != null) && procParam != null) {
            String proc;
            List<String> processors = procParam.isCollection() ? (List<String>)procParam.getValue() : Collections.singletonList((String)procParam.getValue());
            boolean procmatch = false;
            i$ = processors.iterator();
            while (i$.hasNext() && !(procmatch = (proc = i$.next()).equals(fwProcessor) || proc.equals(processorAlias.get(fwProcessor)))) {
            }
            match &= procmatch;
        }
        return match;
    }

    static {
        processorAlias.put("amd64", "x86-64");
        processorAlias.put("em64t", "x86-64");
        processorAlias.put("i386", "x86");
        processorAlias.put("i486", "x86");
        processorAlias.put("i586", "x86");
        processorAlias.put("i686", "x86");
        processorAlias.put("pentium", "x86");
        processorAlias.put("x86_64", "x86-64");
        osAlias = new HashMap<String, String>();
        osAlias.put("hp-ux", "HPUX");
        osAlias.put("Mac OS", "MacOS");
        osAlias.put("Mac OS X", "MacOSX");
        osAlias.put("OS/2", "OS2");
        osAlias.put("procnto", "QNX");
        osAlias.put("SymbianOS", "Epoc32");
        osAlias.put("Win2000", "Windows2000");
        osAlias.put("Win2003", "Windows2003");
        osAlias.put("Win32", "Windows");
        osAlias.put("Win95", "Windows95");
        osAlias.put("Win98", "Windows98");
        osAlias.put("WinCE", "WindowsCE");
        osAlias.put("Windows 2000", "Windows2000");
        osAlias.put("Windows 2003", "Windows2003");
        osAlias.put("Windows 7", "Windows7");
        osAlias.put("Windows 95", "Windows95");
        osAlias.put("Windows 98", "Windows98");
        osAlias.put("Windows CE", "WindowsCE");
        osAlias.put("Windows NT", "WindowsNT");
        osAlias.put("Windows Server 2003", "Windows2003");
        osAlias.put("Windows Vista", "WindowsVista");
        osAlias.put("Windows XP", "WindowsXP");
        osAlias.put("WinNT", "WindowsNT");
        osAlias.put("WinVista", "WindowsVista");
        osAlias.put("WinXP", "WindowsXP");
    }

    public static class BundleNativeLibraryProvider
    implements NativeLibraryProvider {
        private AbstractUserBundle bundleState;
        private String libpath;
        private String libname;
        private File libraryFile;

        public BundleNativeLibraryProvider(AbstractUserBundle bundleState, String libname, String libpath) {
            this.bundleState = bundleState;
            this.libpath = libpath;
            this.libname = libname;
            URL entryURL = bundleState.getEntry(libpath);
            if (entryURL == null) {
                throw new IllegalStateException("Cannot find native library: " + libpath);
            }
        }

        @Override
        public String getLibraryName() {
            return this.libname;
        }

        @Override
        public String getLibraryPath() {
            return this.libpath;
        }

        @Override
        public File getLibraryLocation() throws IOException {
            VirtualFile contentRoot = this.bundleState.getFirstContentRoot();
            if (this.libraryFile == null && contentRoot != null) {
                VirtualFile fileSource = contentRoot.getChild(this.libpath);
                this.libraryFile = this.getUniqueLibraryFile(this.bundleState, this.libpath);
                this.libraryFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(this.libraryFile);
                VFSUtils.copyStream((InputStream)fileSource.openStream(), (OutputStream)fos);
                fos.close();
            }
            return this.libraryFile;
        }

        private File getUniqueLibraryFile(AbstractUserBundle bundleState, String libpath) {
            BundleManager bundleManager = bundleState.getBundleManager();
            String timestamp = new SimpleDateFormat("-yyyyMMdd-HHmmssSSS").format(new Date(bundleState.getLastModified()));
            String uniquePath = new StringBuffer(libpath).insert(libpath.lastIndexOf("."), timestamp).toString();
            BundleStoragePlugin plugin = bundleManager.getPlugin(BundleStoragePlugin.class);
            return plugin.getDataFile(bundleState, uniquePath);
        }
    }
}

