/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractRevision;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.FragmentRevision;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.ModuleManagerPlugin;
import org.jboss.osgi.framework.plugin.NativeCodePlugin;
import org.jboss.osgi.framework.plugin.ResolverPlugin;
import org.jboss.osgi.metadata.NativeLibraryMetaData;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleBuilder;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XResolverCallback;
import org.jboss.osgi.resolver.XResolverException;
import org.jboss.osgi.resolver.XResolverFactory;
import org.jboss.osgi.resolver.XWire;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class ResolverPluginImpl
extends AbstractPlugin
implements ResolverPlugin {
    final Logger log = Logger.getLogger(ResolverPluginImpl.class);
    private final XResolverFactory factory = XResolverFactory.getInstance((ClassLoader)this.getClass().getClassLoader());
    private final NativeCodePlugin nativeCodePlugin = this.getOptionalPlugin(NativeCodePlugin.class);
    private final ModuleManagerPlugin moduleManager = this.getPlugin(ModuleManagerPlugin.class);
    private XResolver resolver;

    public ResolverPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void initPlugin() {
        this.resolver = this.factory.newResolver();
    }

    @Override
    public void destroyPlugin() {
        this.resolver = null;
    }

    @Override
    public XResolver getResolver() {
        return this.resolver;
    }

    @Override
    public XModuleBuilder getModuleBuilder() {
        return this.factory.newModuleBuilder();
    }

    @Override
    public void addModule(XModule resModule) {
        this.resolver.addModule(resModule);
    }

    @Override
    public void removeModule(XModule resModule) {
        this.resolver.removeModule(resModule);
    }

    @Override
    public XModule getModuleById(XModuleIdentity moduleId) {
        return this.resolver != null ? this.resolver.getModuleById(moduleId) : null;
    }

    @Override
    public void resolve(XModule resModule) throws BundleException {
        ArrayList<XModule> resolved = new ArrayList<XModule>();
        this.resolver.setCallbackHandler((XResolverCallback)new ResolverCallback(resolved));
        try {
            this.resolver.resolve(resModule);
        }
        catch (XResolverException ex) {
            throw new BundleException("Cannot resolve bundle resModule: " + resModule, (Throwable)ex);
        }
        this.applyResolverResults(resolved);
    }

    @Override
    public boolean resolveAll(Set<XModule> resModules) {
        LinkedHashSet<XModule> unresolved = new LinkedHashSet<XModule>();
        if (resModules == null) {
            for (AbstractBundle abstractBundle : this.getBundleManager().getBundles()) {
                if (abstractBundle.getState() != 2) continue;
                unresolved.add(abstractBundle.getResolverModule());
            }
        } else {
            for (XModule xModule : resModules) {
                if (xModule.isResolved()) continue;
                unresolved.add(xModule);
            }
        }
        ArrayList<XModule> resolved = new ArrayList<XModule>();
        this.resolver.setCallbackHandler((XResolverCallback)new ResolverCallback(resolved));
        this.log.debugf("Resolve modules: %s", unresolved);
        boolean bl = this.resolver.resolveAll(unresolved);
        if (!bl) {
            for (XModule xModule : unresolved) {
                if (xModule.isResolved()) continue;
                XResolverException ex = (XResolverException)((Object)xModule.getAttachment(XResolverException.class));
                this.log.errorf((Throwable)ex, "Cannot resolve: %s", (Object)xModule);
            }
        }
        this.applyResolverResults(resolved);
        return bl;
    }

    private void applyResolverResults(List<XModule> resolved) {
        this.attachFragmentsToHost(resolved);
        this.addModules(resolved);
        this.loadModules(resolved);
        this.resolveNativeCodeLibraries(resolved);
        this.setBundleToResolved(resolved);
    }

    private void attachFragmentsToHost(List<XModule> resolved) {
        for (XModule aux : resolved) {
            if (!aux.isFragment()) continue;
            FragmentRevision fragRev = (FragmentRevision)aux.getAttachment(AbstractRevision.class);
            fragRev.attachToHost();
        }
    }

    private void addModules(List<XModule> resolved) {
        for (XModule aux : resolved) {
            if (aux.isFragment()) continue;
            this.moduleManager.addModule(aux);
        }
    }

    private void loadModules(List<XModule> resolved) {
        for (XModule aux : resolved) {
            if (aux.isFragment()) continue;
            ModuleIdentifier identifier = this.moduleManager.getModuleIdentifier(aux);
            try {
                this.moduleManager.loadModule(identifier);
            }
            catch (ModuleLoadException ex) {
                throw new IllegalStateException("Cannot load module: " + identifier, ex);
            }
        }
    }

    private void resolveNativeCodeLibraries(List<XModule> resolved) {
        XModule systemModule = this.getBundleManager().getSystemBundle().getResolverModule();
        for (XModule aux : resolved) {
            if (aux == systemModule) continue;
            Bundle bundle = (Bundle)aux.getAttachment(Bundle.class);
            AbstractUserBundle bundleState = AbstractUserBundle.assertBundleState(bundle);
            Deployment deployment = bundleState.getDeployment();
            NativeLibraryMetaData libMetaData = (NativeLibraryMetaData)deployment.getAttachment(NativeLibraryMetaData.class);
            if (this.nativeCodePlugin == null || libMetaData == null) continue;
            this.nativeCodePlugin.resolveNativeCode(bundleState);
        }
    }

    private void setBundleToResolved(List<XModule> resolved) {
        for (XModule aux : resolved) {
            Bundle bundle = (Bundle)aux.getAttachment(Bundle.class);
            AbstractBundle bundleState = AbstractBundle.assertBundleState(bundle);
            bundleState.changeState(4);
        }
    }

    class ResolverCallback
    implements XResolverCallback {
        private List<XModule> resolved;

        ResolverCallback(List<XModule> resolved) {
            this.resolved = resolved;
        }

        public void markResolved(XModule module) {
            if (ResolverPluginImpl.this.log.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer("Mark resolved: " + module);
                for (XWire wire : module.getWires()) {
                    buffer.append("\n " + wire.toString());
                }
                ResolverPluginImpl.this.log.debugf(buffer.toString(), new Object[0]);
            }
            this.resolved.add(module);
        }
    }
}

