/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.logging.Logger;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.ServiceReferenceComparator;
import org.jboss.osgi.framework.bundle.ServiceState;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugin.PackageAdminPlugin;
import org.jboss.osgi.framework.plugin.ServiceManagerPlugin;
import org.jboss.osgi.framework.util.NoFilter;
import org.jboss.osgi.framework.util.RemoveOnlyCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.FindHook;
import org.osgi.framework.hooks.service.ListenerHook;

public class ServiceManagerPluginImpl
extends AbstractPlugin
implements ServiceManagerPlugin {
    private final Logger log = Logger.getLogger(ServiceManagerPluginImpl.class);
    private AtomicLong identityGenerator = new AtomicLong();
    private Map<String, List<ServiceName>> serviceNameMap = new ConcurrentHashMap<String, List<ServiceName>>();
    private FrameworkEventsPlugin eventsPlugin;
    private PackageAdminPlugin packageAdmin;

    public ServiceManagerPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void initPlugin() {
        this.eventsPlugin = this.getPlugin(FrameworkEventsPlugin.class);
        this.packageAdmin = this.getPlugin(PackageAdminPlugin.class);
    }

    @Override
    public void destroyPlugin() {
        this.serviceNameMap.clear();
    }

    @Override
    public long getNextServiceId() {
        return this.identityGenerator.incrementAndGet();
    }

    @Override
    public ServiceState registerService(AbstractBundle bundleState, String[] clazzes, Object serviceValue, Dictionary properties) {
        if (clazzes == null || clazzes.length == 0) {
            throw new IllegalArgumentException("Null service classes");
        }
        Collection<ListenerHook.ListenerInfo> listenerInfos = null;
        if (serviceValue instanceof ListenerHook) {
            listenerInfos = this.eventsPlugin.getServiceListenerInfos(null);
        }
        HashMap<ServiceName, String> associations = new HashMap<ServiceName, String>();
        long serviceId = this.getNextServiceId();
        ServiceName[] serviceNames = new ServiceName[clazzes.length];
        for (int i = 0; i < clazzes.length; ++i) {
            if (clazzes[i] == null) {
                throw new IllegalArgumentException("Null service class at index: " + i);
            }
            String prefix = i == 0 ? "jbosgi-service" : "jbosgi-alias";
            String shortName = clazzes[i].substring(clazzes[i].lastIndexOf(".") + 1);
            serviceNames[i] = ServiceName.of((String[])new String[]{prefix, bundleState.getSymbolicName(), shortName, new Long(serviceId).toString()});
        }
        final ServiceState serviceState = new ServiceState(bundleState, serviceId, serviceNames, clazzes, serviceValue, properties);
        BatchBuilder batchBuilder = this.getBundleManager().getServiceContainer().batchBuilder();
        Service service = new Service(){

            public Object getValue() throws IllegalStateException {
                return serviceState;
            }

            public void start(StartContext context) throws StartException {
            }

            public void stop(StopContext context) {
            }
        };
        this.log.debugf("Register service: %s", (Object)serviceState);
        ServiceName rootServiceName = serviceNames[0];
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(rootServiceName, service);
        associations.put(rootServiceName, clazzes[0]);
        serviceBuilder.setInitialMode(ServiceController.Mode.PASSIVE);
        for (int i = 1; i < serviceNames.length; ++i) {
            ServiceName alias = serviceNames[i];
            associations.put(alias, clazzes[1]);
            serviceBuilder.addAliases(new ServiceName[]{alias});
        }
        try {
            batchBuilder.install();
            for (Map.Entry aux : associations.entrySet()) {
                bundleState.addRegisteredService(serviceState);
                this.registerNameAssociation((String)aux.getValue(), (ServiceName)aux.getKey());
            }
        }
        catch (ServiceRegistryException ex) {
            this.log.errorf((Throwable)ex, "Cannot register services: %s", Arrays.asList(serviceNames));
        }
        if (serviceValue instanceof ListenerHook) {
            ListenerHook listenerHook = (ListenerHook)serviceValue;
            listenerHook.added(listenerInfos);
        }
        this.eventsPlugin.fireServiceEvent(bundleState, 1, serviceState);
        return serviceState;
    }

    @Override
    public List<ServiceState> getRegisteredServices(AbstractBundle bundleState) {
        return bundleState.getRegisteredServicesInternal();
    }

    @Override
    public ServiceState getServiceReference(AbstractBundle bundleState, String clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        boolean checkAssignable = bundleState.getBundleId() != 0L;
        List<ServiceState> result = this.getServiceReferencesInternal(bundleState, clazz, null, checkAssignable);
        if ((result = this.processFindHooks(bundleState, clazz, null, true, result)).isEmpty()) {
            return null;
        }
        int lastIndex = result.size() - 1;
        return result.get(lastIndex);
    }

    @Override
    public List<ServiceState> getServiceReferences(AbstractBundle bundleState, String clazz, String filterStr, boolean checkAssignable) throws InvalidSyntaxException {
        Filter filter = null;
        if (filterStr != null) {
            filter = FrameworkUtil.createFilter((String)filterStr);
        }
        List<ServiceState> result = this.getServiceReferencesInternal(bundleState, clazz, filter, checkAssignable);
        result = this.processFindHooks(bundleState, clazz, filterStr, checkAssignable, result);
        return result;
    }

    public List<ServiceState> getServiceReferencesInternal(AbstractBundle bundleState, String clazz, Filter filter, boolean checkAssignable) {
        List<ServiceName> serviceNames;
        if (bundleState == null) {
            throw new IllegalArgumentException("Null bundleState");
        }
        if (clazz != null) {
            serviceNames = this.serviceNameMap.get(clazz);
            if (serviceNames == null) {
                serviceNames = new ArrayList<ServiceName>();
            }
            ServiceName xserviceName = ServiceName.of((String[])new String[]{"jbosgi", clazz});
            ServiceController xservice = this.getBundleManager().getServiceContainer().getService(xserviceName);
            if (xservice != null) {
                serviceNames.add(xserviceName);
            }
        } else {
            HashSet<ServiceName> allServiceNames = new HashSet<ServiceName>();
            for (List<ServiceName> auxList : this.serviceNameMap.values()) {
                for (ServiceName auxName : auxList) {
                    if (!auxName.getCanonicalName().startsWith("jbosgi-service")) continue;
                    allServiceNames.add(auxName);
                }
            }
            serviceNames = new ArrayList<ServiceName>(allServiceNames);
        }
        if (serviceNames.isEmpty()) {
            return Collections.emptyList();
        }
        if (filter == null) {
            filter = NoFilter.INSTANCE;
        }
        ArrayList<ServiceState> result = new ArrayList<ServiceState>();
        for (ServiceName serviceName : serviceNames) {
            ServiceState serviceState;
            ServiceController controller = this.getBundleManager().getServiceContainer().getService(serviceName);
            if (controller == null) {
                throw new IllegalStateException("Cannot obtain service for: " + serviceName);
            }
            Object value = controller.getValue();
            if (!(value instanceof ServiceState) && serviceName.toString().contains("jbosgi")) {
                long serviceId = this.getNextServiceId();
                Bundle bundle = this.packageAdmin.getBundle(value.getClass());
                AbstractBundle owner = AbstractBundle.assertBundleState(bundle);
                value = new ServiceState(owner, serviceId, new ServiceName[]{serviceName}, new String[]{clazz}, value, null);
            }
            if (!filter.match((ServiceReference)(serviceState = (ServiceState)value))) continue;
            Object rawValue = serviceState.getRawValue();
            checkAssignable &= clazz != null;
            checkAssignable &= bundleState.getBundleId() != 0L;
            if ((checkAssignable &= !(rawValue instanceof ServiceFactory)) && !serviceState.isAssignableTo(bundleState, clazz)) continue;
            result.add(serviceState);
        }
        Collections.sort(result, ServiceReferenceComparator.getInstance());
        return Collections.unmodifiableList(result);
    }

    @Override
    public Object getService(AbstractBundle bundleState, ServiceState serviceState) {
        if (serviceState.isUnregistered()) {
            return null;
        }
        bundleState.addServiceInUse(serviceState);
        serviceState.addUsingBundle(bundleState);
        Object value = serviceState.getScopedValue(bundleState);
        if (value == null) {
            bundleState.removeServiceInUse(serviceState);
            serviceState.removeUsingBundle(bundleState);
        }
        return value;
    }

    @Override
    public boolean ungetService(AbstractBundle bundleState, ServiceState serviceState) {
        serviceState.ungetScopedValue(bundleState);
        int useCount = bundleState.removeServiceInUse(serviceState);
        if (useCount == 0) {
            serviceState.removeUsingBundle(bundleState);
        }
        return useCount >= 0;
    }

    @Override
    public Set<ServiceState> getServicesInUse(AbstractBundle bundleState) {
        return bundleState.getServicesInUseInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNameAssociation(String className, ServiceName serviceName) {
        Map<String, List<ServiceName>> map = this.serviceNameMap;
        synchronized (map) {
            List<ServiceName> names = this.serviceNameMap.get(className);
            if (names == null) {
                names = new CopyOnWriteArrayList<ServiceName>();
                this.serviceNameMap.put(className, names);
            }
            names.add(serviceName);
        }
    }

    private boolean unregisterNameAssociation(String className, ServiceName serviceName) {
        boolean removed = false;
        List<ServiceName> names = this.serviceNameMap.get(className);
        if (names != null) {
            removed = names.remove(serviceName);
            if (names.isEmpty()) {
                this.serviceNameMap.remove(className);
            }
        }
        return removed;
    }

    @Override
    public Set<AbstractBundle> getUsingBundles(ServiceState serviceState) {
        return serviceState.getUsingBundlesInternal();
    }

    @Override
    public void unregisterService(ServiceState serviceState) {
        List<ServiceName> serviceNames = serviceState.getServiceNames();
        this.log.debugf("Unregister service: %s", serviceNames);
        AbstractBundle serviceOwner = serviceState.getServiceOwner();
        this.eventsPlugin.fireServiceEvent(serviceOwner, 4, serviceState);
        for (AbstractBundle bundleState : serviceState.getUsingBundlesInternal()) {
            while (this.ungetService(bundleState, serviceState)) {
            }
        }
        serviceOwner.removeRegisteredService(serviceState);
        String[] clazzes = (String[])serviceState.getProperty("objectClass");
        for (ServiceName serviceName : serviceNames) {
            for (String clazz : clazzes) {
                this.unregisterNameAssociation(clazz, serviceName);
            }
        }
        ServiceName rootServiceName = serviceNames.get(0);
        try {
            ServiceController controller = this.getBundleManager().getServiceContainer().getService(rootServiceName);
            if (controller != null) {
                controller.setMode(ServiceController.Mode.REMOVE);
            }
        }
        catch (RuntimeException ex) {
            this.log.errorf((Throwable)ex, "Cannot remove service: %s", (Object)rootServiceName);
        }
    }

    private List<ServiceState> processFindHooks(AbstractBundle bundle, String clazz, String filterStr, boolean checkAssignable, List<ServiceState> serviceStates) {
        BundleContext context = bundle.getBundleContext();
        List<ServiceState> hookRefs = this.getServiceReferencesInternal(bundle, FindHook.class.getName(), null, true);
        if (hookRefs.isEmpty()) {
            return serviceStates;
        }
        if (clazz != null && clazz.startsWith(FindHook.class.getPackage().getName())) {
            return serviceStates;
        }
        ArrayList<ServiceState> sortedHookRefs = new ArrayList<ServiceState>(hookRefs);
        Collections.reverse(sortedHookRefs);
        ArrayList<FindHook> hooks = new ArrayList<FindHook>();
        for (ServiceReference serviceReference : sortedHookRefs) {
            hooks.add((FindHook)context.getService(serviceReference));
        }
        Collection hookParam = new ArrayList<ServiceReference>();
        for (ServiceState aux : serviceStates) {
            hookParam.add(aux.getReference());
        }
        hookParam = new RemoveOnlyCollection(hookParam);
        for (FindHook hook : hooks) {
            try {
                hook.find(context, clazz, filterStr, !checkAssignable, hookParam);
            }
            catch (Exception ex) {
                this.log.warnf((Throwable)ex, "Error while calling FindHook: %s", (Object)hook);
            }
        }
        ArrayList<ServiceState> arrayList = new ArrayList<ServiceState>();
        for (ServiceReference aux : hookParam) {
            ServiceState serviceState = ServiceState.assertServiceState(aux);
            arrayList.add(serviceState);
        }
        return arrayList;
    }
}

