/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.AbstractBundle;
import org.jboss.osgi.framework.bundle.AbstractUserBundle;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.bundle.HostBundle;
import org.jboss.osgi.framework.bundle.SystemBundle;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.FrameworkEventsPlugin;
import org.jboss.osgi.framework.plugin.StartLevelPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.launch.Framework;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelPluginImpl
extends AbstractPlugin
implements StartLevelPlugin {
    final Logger log = Logger.getLogger(StartLevelPluginImpl.class);
    private final FrameworkEventsPlugin eventsPlugin;
    private Executor executor = Executors.newSingleThreadExecutor();
    private int initialBundleStartLevel = 1;
    private ServiceRegistration registration;
    private int startLevel = 0;

    public StartLevelPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
        this.eventsPlugin = this.getPlugin(FrameworkEventsPlugin.class);
    }

    @Override
    public void startPlugin() {
        BundleContext sc = this.getBundleManager().getSystemContext();
        this.registration = sc.registerService(StartLevel.class.getName(), (Object)this, null);
    }

    @Override
    public void stopPlugin() {
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }

    public synchronized int getStartLevel() {
        return this.startLevel;
    }

    public synchronized void setStartLevel(final int sl) {
        if (sl > this.getStartLevel()) {
            this.log.infof("About to increase start level from %s to %s", (Object)this.getStartLevel(), (Object)sl);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    StartLevelPluginImpl.this.log.infof("Increasing start level from %s to %s", (Object)StartLevelPluginImpl.this.getStartLevel(), (Object)sl);
                    StartLevelPluginImpl.this.increaseStartLevel(sl);
                    StartLevelPluginImpl.this.eventsPlugin.fireFrameworkEvent(StartLevelPluginImpl.this.getBundleManager().getSystemContext().getBundle(), 8, null);
                }
            });
        } else if (sl < this.getStartLevel()) {
            this.log.infof("About to decrease start level from %s to %s", (Object)this.getStartLevel(), (Object)sl);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    StartLevelPluginImpl.this.log.infof("Decreasing start level from %s to %s", (Object)StartLevelPluginImpl.this.getStartLevel(), (Object)sl);
                    StartLevelPluginImpl.this.decreaseStartLevel(sl);
                    StartLevelPluginImpl.this.eventsPlugin.fireFrameworkEvent(StartLevelPluginImpl.this.getBundleManager().getSystemContext().getBundle(), 8, null);
                }
            });
        }
    }

    public int getBundleStartLevel(Bundle bundle) {
        if (bundle instanceof Framework) {
            return 0;
        }
        AbstractBundle b = AbstractBundle.assertBundleState(bundle);
        if (b instanceof SystemBundle) {
            return 0;
        }
        if (b instanceof HostBundle) {
            return ((HostBundle)b).getStartLevel();
        }
        return -1;
    }

    public void setBundleStartLevel(Bundle bundle, int sl) {
        if (bundle.getBundleId() == 0L) {
            throw new IllegalArgumentException("Cannot set the start level of the System Bundle");
        }
        final HostBundle hostBundle = HostBundle.assertBundleState(bundle);
        hostBundle.setStartLevel(sl);
        if (sl <= this.getStartLevel() && hostBundle.isPersistentlyStarted()) {
            if ((bundle.getState() & 0x28) > 0) {
                return;
            }
            this.log.infof("Start Level Service about to start: %s", (Object)hostBundle);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    StartLevelPluginImpl.this.log.infof("Start Level Service starting: %s", (Object)hostBundle);
                    try {
                        int opts = 1;
                        if (StartLevelPluginImpl.this.isBundleActivationPolicyUsed(hostBundle)) {
                            opts |= 2;
                        }
                        hostBundle.start(opts);
                    }
                    catch (BundleException e) {
                        StartLevelPluginImpl.this.eventsPlugin.fireFrameworkEvent(hostBundle, 2, e);
                    }
                }
            });
        } else {
            if ((bundle.getState() & 0x28) == 0) {
                return;
            }
            this.log.infof("Start Level Service about to stop: %s", (Object)hostBundle);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    StartLevelPluginImpl.this.log.infof("Start Level Service stopping: %s", (Object)hostBundle);
                    try {
                        hostBundle.stop(1);
                    }
                    catch (BundleException e) {
                        StartLevelPluginImpl.this.eventsPlugin.fireFrameworkEvent(hostBundle, 2, e);
                    }
                }
            });
        }
    }

    public synchronized int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public synchronized void setInitialBundleStartLevel(int startlevel) {
        this.initialBundleStartLevel = startlevel;
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        if (bundle.getBundleId() == 0L) {
            return true;
        }
        AbstractUserBundle userBundle = AbstractUserBundle.assertBundleState(bundle);
        if (userBundle instanceof HostBundle) {
            return ((HostBundle)userBundle).isPersistentlyStarted();
        }
        return false;
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle) {
        return false;
    }

    @Override
    public synchronized void increaseStartLevel(int sl) {
        List<AbstractBundle> bundles = this.getBundleManager().getBundles();
        while (this.startLevel < sl) {
            ++this.startLevel;
            this.log.infof("Starting bundles for start level: %s", (Object)this.startLevel);
            for (AbstractBundle b : bundles) {
                HostBundle hb;
                if (!(b instanceof HostBundle) || (hb = (HostBundle)b).getStartLevel() != this.startLevel || !hb.isPersistentlyStarted() || !hb.isPersistentlyStarted()) continue;
                try {
                    int opts = 1;
                    if (this.isBundleActivationPolicyUsed(b)) {
                        opts |= 2;
                    }
                    b.start(opts);
                }
                catch (Throwable e) {
                    this.eventsPlugin.fireFrameworkEvent(b, 2, e);
                }
            }
        }
    }

    @Override
    public synchronized void decreaseStartLevel(int sl) {
        List<AbstractBundle> bundles = this.getBundleManager().getBundles();
        while (this.startLevel > sl) {
            this.log.infof("Stopping bundles for start level: %s", (Object)this.startLevel);
            for (AbstractBundle b : bundles) {
                HostBundle hb;
                if (!(b instanceof HostBundle) || (hb = (HostBundle)b).getStartLevel() != this.startLevel) continue;
                try {
                    b.stop(1);
                }
                catch (Throwable e) {
                    this.eventsPlugin.fireFrameworkEvent(b, 2, e);
                }
            }
            --this.startLevel;
        }
    }
}

