/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.framework.plugin.SystemPackagesPlugin;

public class SystemPackagesPluginImpl
extends AbstractPlugin
implements SystemPackagesPlugin {
    final Logger log = Logger.getLogger(SystemPackagesPluginImpl.class);
    private List<String> allPackages = new ArrayList<String>();
    private List<String> bootDelegationPackages = new ArrayList<String>();
    private Set<String> exportedPaths;

    public SystemPackagesPluginImpl(BundleManager bundleManager) {
        super(bundleManager);
        String systemPackages = (String)bundleManager.getProperty("org.osgi.framework.system.packages");
        if (systemPackages != null) {
            this.allPackages.addAll(this.packagesAsList(systemPackages));
        } else {
            this.allPackages.add("javax.imageio");
            this.allPackages.add("javax.imageio.stream");
            this.allPackages.add("javax.management");
            this.allPackages.add("javax.management.loading");
            this.allPackages.add("javax.management.modelmbean");
            this.allPackages.add("javax.management.monitor");
            this.allPackages.add("javax.management.openmbean");
            this.allPackages.add("javax.management.relation");
            this.allPackages.add("javax.management.remote");
            this.allPackages.add("javax.management.remote.rmi");
            this.allPackages.add("javax.management.timer");
            this.allPackages.add("javax.naming");
            this.allPackages.add("javax.naming.event");
            this.allPackages.add("javax.naming.spi");
            this.allPackages.add("javax.net");
            this.allPackages.add("javax.net.ssl");
            this.allPackages.add("javax.security.cert");
            this.allPackages.add("javax.xml.datatype");
            this.allPackages.add("javax.xml.namespace");
            this.allPackages.add("javax.xml.parsers");
            this.allPackages.add("javax.xml.validation");
            this.allPackages.add("javax.xml.transform");
            this.allPackages.add("javax.xml.transform.dom");
            this.allPackages.add("javax.xml.transform.sax");
            this.allPackages.add("javax.xml.transform.stream");
            this.allPackages.add("org.jboss.modules");
            this.allPackages.add("org.w3c.dom");
            this.allPackages.add("org.w3c.dom.bootstrap");
            this.allPackages.add("org.w3c.dom.ls");
            this.allPackages.add("org.w3c.dom.events");
            this.allPackages.add("org.w3c.dom.ranges");
            this.allPackages.add("org.w3c.dom.views");
            this.allPackages.add("org.w3c.dom.traversal");
            this.allPackages.add("org.xml.sax");
            this.allPackages.add("org.xml.sax.ext");
            this.allPackages.add("org.xml.sax.helpers");
            if (bundleManager.getIntegrationMode() == BundleManager.IntegrationMode.STANDALONE) {
                this.allPackages.addAll(this.getFrameworkPackages());
            }
            String asString = this.packagesAsString(this.allPackages);
            bundleManager.setProperty("org.osgi.framework.system.packages", asString);
        }
        String extraPackages = (String)bundleManager.getProperty("org.osgi.framework.system.packages.extra");
        if (extraPackages != null) {
            this.allPackages.addAll(this.packagesAsList(extraPackages));
        }
        Collections.sort(this.allPackages);
        String bootDelegationProp = (String)bundleManager.getProperty("org.osgi.framework.bootdelegation");
        if (bootDelegationProp != null) {
            String[] packageNames;
            for (String packageName : packageNames = bootDelegationProp.split(",")) {
                this.bootDelegationPackages.add(packageName);
            }
        } else {
            this.bootDelegationPackages.add("sun.reflect");
        }
    }

    @Override
    public List<String> getFrameworkPackages() {
        ArrayList<String> packages = new ArrayList<String>();
        packages.add("org.jboss.msc.service");
        packages.add("org.jboss.osgi.deployment.deployer");
        packages.add("org.jboss.osgi.deployment.interceptor");
        packages.add("org.jboss.osgi.modules");
        packages.add("org.osgi.framework;version=1.5");
        packages.add("org.osgi.framework.hooks;version=1.0");
        packages.add("org.osgi.framework.hooks.service;version=1.0");
        packages.add("org.osgi.framework.launch;version=1.0");
        packages.add("org.osgi.service.condpermadmin;version=1.1");
        packages.add("org.osgi.service.packageadmin;version=1.2");
        packages.add("org.osgi.service.permissionadmin;version=1.2");
        packages.add("org.osgi.service.startlevel;version=1.1");
        packages.add("org.osgi.service.url;version=1.0");
        packages.add("org.osgi.util.tracker;version=1.4");
        return packages;
    }

    @Override
    public boolean isFrameworkPackage(String name) {
        this.assertInitialized();
        return this.isPackageNameInList(this.getFrameworkPackages(), name);
    }

    @Override
    public List<String> getBootDelegationPackages() {
        this.assertInitialized();
        return Collections.unmodifiableList(this.bootDelegationPackages);
    }

    @Override
    public boolean isBootDelegationPackage(String name) {
        this.assertInitialized();
        if (name == null) {
            throw new IllegalArgumentException("Null package name");
        }
        if (name.startsWith("java.")) {
            return true;
        }
        if (this.bootDelegationPackages.contains(name)) {
            return true;
        }
        for (String aux : this.bootDelegationPackages) {
            if (!aux.endsWith(".*") || !name.startsWith(aux.substring(0, aux.length() - 2))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getSystemPackages() {
        this.assertInitialized();
        return Collections.unmodifiableList(this.allPackages);
    }

    @Override
    public boolean isSystemPackage(String name) {
        this.assertInitialized();
        return this.isPackageNameInList(this.allPackages, name);
    }

    @Override
    public Set<String> getExportedPaths() {
        this.assertInitialized();
        if (this.exportedPaths == null) {
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            List<String> bootDelegationPackages = this.getBootDelegationPackages();
            for (String packageName : bootDelegationPackages) {
                if (packageName.endsWith(".*")) {
                    packageName = packageName.substring(0, packageName.length() - 2);
                }
                result.add(packageName.replace('.', '/'));
            }
            List<String> systemPackages = this.getSystemPackages();
            for (String packageSpec : systemPackages) {
                int index = packageSpec.indexOf(59);
                if (index > 0) {
                    packageSpec = packageSpec.substring(0, index);
                }
                result.add(packageSpec.replace('.', '/'));
            }
            this.exportedPaths = Collections.unmodifiableSet(result);
        }
        return this.exportedPaths;
    }

    private boolean isPackageNameInList(List<String> packages, String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null package name");
        }
        int index = name.indexOf(59);
        if (index > 0) {
            name = name.substring(0, index);
        }
        if (packages.contains(name)) {
            return true;
        }
        for (String aux : packages) {
            if (!aux.startsWith(name + ";")) continue;
            return true;
        }
        return false;
    }

    private String packagesAsString(List<String> sysPackages) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < sysPackages.size(); ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(sysPackages.get(i));
        }
        return result.toString();
    }

    private List<String> packagesAsList(String sysPackages) {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : sysPackages.split(",")) {
            if ((name = name.trim()).length() <= 0) continue;
            result.add(name);
        }
        return result;
    }

    private void assertInitialized() {
        if (this.allPackages.isEmpty()) {
            throw new IllegalStateException("SystemPackagesPlugin not initialized");
        }
    }
}

