/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.plugin.internal;

import java.util.Set;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.bundle.BundleManager;
import org.jboss.osgi.framework.plugin.AbstractPlugin;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleContext;

public class WebXMLVerifierInterceptor
extends AbstractPlugin
implements LifecycleInterceptor {
    private LifecycleInterceptor delegate;

    public WebXMLVerifierInterceptor(BundleManager bundleManager) {
        super(bundleManager);
    }

    @Override
    public void initPlugin() {
        this.delegate = new AbstractLifecycleInterceptor(){

            public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
                if (state == 8) {
                    try {
                        VirtualFile root = context.getRoot();
                        if (root != null) {
                            boolean isWebApp;
                            VirtualFile webXML = root.getChild("/WEB-INF/web.xml");
                            String contextPath = (String)context.getBundle().getHeaders().get("Web-ContextPath");
                            boolean bl = isWebApp = contextPath != null || root.getName().endsWith(".war");
                            if (isWebApp && webXML == null) {
                                throw new LifecycleInterceptorException("Cannot obtain web.xml from: " + root.toURL());
                            }
                        }
                    }
                    catch (RuntimeException rte) {
                        throw rte;
                    }
                    catch (Exception ex) {
                        throw new LifecycleInterceptorException("Cannot check for web.xml", (Throwable)ex);
                    }
                }
            }
        };
    }

    @Override
    public void destroyPlugin() {
        this.delegate = null;
    }

    @Override
    public void startPlugin() {
        BundleContext sysContext = this.getBundleManager().getSystemContext();
        sysContext.registerService(LifecycleInterceptor.class.getName(), (Object)this.delegate, null);
    }

    public Set<Class<?>> getInput() {
        return this.delegate.getInput();
    }

    public Set<Class<?>> getOutput() {
        return this.delegate.getOutput();
    }

    public int getRelativeOrder() {
        return this.delegate.getRelativeOrder();
    }

    public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
        this.delegate.invoke(state, context);
    }
}

