/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.hornetq.api.core.TransportConfiguration;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.ElementUtils;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public abstract class AbstractTransportElement<E extends AbstractTransportElement<E>>
extends AbstractModelElement<E> {
    private static final long serialVersionUID = -2921301251096974402L;
    private final Element element;
    private final String name;
    private String socketBindingRef;
    private Map<String, Object> params;

    protected AbstractTransportElement(Element element, String name) {
        this.element = element;
        this.name = name;
    }

    public abstract String getFactoryClassName();

    protected void setFactoryClassName(String factoryClass) {
        throw new IllegalStateException("factory class cannot be defined on this class");
    }

    Element getElement() {
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public String getSocketBindingRef() {
        return this.socketBindingRef;
    }

    public void setSocketBindingRef(String socketBindingRef) {
        this.socketBindingRef = socketBindingRef;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    protected void processHQConfig(TransportConfiguration transport) {
        if (this.params != null) {
            transport.getParams().putAll(this.params);
        }
        if (this.socketBindingRef != null) {
            transport.getParams().put("socket-ref", this.socketBindingRef);
        }
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.name != null) {
            streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        }
        if (this.socketBindingRef != null) {
            streamWriter.writeAttribute(Attribute.SOCKET_BINDING.getLocalName(), this.socketBindingRef);
        }
        if (this.isWriteFactoryClass() && this.getFactoryClassName() != null) {
            ElementUtils.writeSimpleElement(Element.FACTORY_CLASS, this.getFactoryClassName(), streamWriter);
        }
        if (this.params != null && !this.params.isEmpty()) {
            for (Map.Entry<String, Object> entry : this.params.entrySet()) {
                streamWriter.writeEmptyElement(Element.PARAM.getLocalName());
                streamWriter.writeAttribute(Attribute.KEY.getLocalName(), entry.getKey());
                streamWriter.writeAttribute(Attribute.VALUE.getLocalName(), entry.getValue().toString());
            }
        }
        streamWriter.writeEndElement();
    }

    protected boolean isWriteFactoryClass() {
        return false;
    }
}

