/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import javax.xml.stream.XMLStreamException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.ElementUtils;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class AddressSettingsElement
extends AbstractModelElement<AddressSettingsElement> {
    private static final long serialVersionUID = -9199912333707812250L;
    private final String match;
    private SimpleString deadLetterAddress;
    private SimpleString expiryAddress;
    private Long redeliveryDelay;
    private Integer messageCounterHistoryDayLimit;
    private AddressFullMessagePolicy addressFullMessagePolicy;
    private Boolean lastValueQueue;
    private Integer maxDeliveryAttempts;
    private Long redistributionDelay;
    private Boolean sendToDLAOnNoRoute;
    private Long maxSizeBytes;
    private Long pageSizeBytes;

    public AddressSettingsElement(String match) {
        this.match = match;
    }

    public String getMatch() {
        return this.match;
    }

    public SimpleString getDeadLetterAddress() {
        return this.deadLetterAddress;
    }

    public void setDeadLetterAddress(SimpleString deadLetterAddress) {
        this.deadLetterAddress = deadLetterAddress;
    }

    public SimpleString getExpiryAddress() {
        return this.expiryAddress;
    }

    public void setExpiryAddress(SimpleString expiryAddress) {
        this.expiryAddress = expiryAddress;
    }

    public Long getRedeliveryDelay() {
        return this.redeliveryDelay;
    }

    public void setRedeliveryDelay(long redeliveryDelay) {
        this.redeliveryDelay = redeliveryDelay;
    }

    public Integer getMessageCounterHistoryDayLimit() {
        return this.messageCounterHistoryDayLimit;
    }

    public void setMessageCounterHistoryDayLimit(int messageCounterHistoryDayLimit) {
        this.messageCounterHistoryDayLimit = messageCounterHistoryDayLimit;
    }

    public AddressFullMessagePolicy getAddressFullMessagePolicy() {
        return this.addressFullMessagePolicy;
    }

    public void setAddressFullMessagePolicy(AddressFullMessagePolicy addressFullMessagePolicy) {
        this.addressFullMessagePolicy = addressFullMessagePolicy;
    }

    public Boolean isLastValueQueue() {
        return this.lastValueQueue;
    }

    public void setLastValueQueue(boolean lastValueQueue) {
        this.lastValueQueue = lastValueQueue;
    }

    public Integer getMaxDeliveryAttempts() {
        return this.maxDeliveryAttempts;
    }

    public void setMaxDeliveryAttempts(int maxDeliveryAttempts) {
        this.maxDeliveryAttempts = maxDeliveryAttempts;
    }

    public Long getRedistributionDelay() {
        return this.redistributionDelay;
    }

    public void setRedistributionDelay(long redistributionDelay) {
        this.redistributionDelay = redistributionDelay;
    }

    public Boolean isSendToDLAOnNoRoute() {
        return this.sendToDLAOnNoRoute;
    }

    public void setSendToDLAOnNoRoute(boolean sendToDLAOnNoRoute) {
        this.sendToDLAOnNoRoute = sendToDLAOnNoRoute;
    }

    public Long getMaxSizeBytes() {
        return this.maxSizeBytes;
    }

    public void setMaxSizeBytes(long maxSizeBytes) {
        this.maxSizeBytes = maxSizeBytes;
    }

    public Long getPageSizeBytes() {
        return this.pageSizeBytes;
    }

    public void setPageSizeBytes(long pageSizeBytes) {
        this.pageSizeBytes = pageSizeBytes;
    }

    protected Class<AddressSettingsElement> getElementClass() {
        return AddressSettingsElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        AddressFullMessagePolicy policy;
        streamWriter.writeAttribute(Attribute.MATCH.getLocalName(), this.match);
        ElementUtils.writeSimpleElement(Element.DEAD_LETTER_ADDRESS_NODE_NAME, this.getDeadLetterAddress(), streamWriter);
        ElementUtils.writeSimpleElement(Element.EXPIRY_ADDRESS_NODE_NAME, this.getExpiryAddress(), streamWriter);
        if (this.getRedeliveryDelay() != null) {
            ElementUtils.writeSimpleElement(Element.REDELIVERY_DELAY_NODE_NAME, String.valueOf(this.getRedeliveryDelay()), streamWriter);
        }
        if (this.getMaxSizeBytes() != null) {
            ElementUtils.writeSimpleElement(Element.MAX_SIZE_BYTES_NODE_NAME, String.valueOf(this.getMaxSizeBytes()), streamWriter);
        }
        if (this.getPageSizeBytes() != null) {
            ElementUtils.writeSimpleElement(Element.PAGE_SIZE_BYTES_NODE_NAME, String.valueOf(this.getPageSizeBytes()), streamWriter);
        }
        if (this.getMessageCounterHistoryDayLimit() != null) {
            ElementUtils.writeSimpleElement(Element.MESSAGE_COUNTER_HISTORY_DAY_LIMIT_NODE_NAME, String.valueOf(this.getMessageCounterHistoryDayLimit()), streamWriter);
        }
        if ((policy = this.getAddressFullMessagePolicy()) != null) {
            ElementUtils.writeSimpleElement(Element.ADDRESS_FULL_MESSAGE_POLICY_NODE_NAME, policy.toString(), streamWriter);
        }
        if (this.isLastValueQueue() != null) {
            ElementUtils.writeSimpleElement(Element.LVQ_NODE_NAME, String.valueOf(this.isLastValueQueue()), streamWriter);
        }
        if (this.getMaxDeliveryAttempts() != null) {
            ElementUtils.writeSimpleElement(Element.MAX_DELIVERY_ATTEMPTS, String.valueOf(this.getMaxDeliveryAttempts()), streamWriter);
        }
        if (this.getRedistributionDelay() != null) {
            ElementUtils.writeSimpleElement(Element.REDISTRIBUTION_DELAY_NODE_NAME, String.valueOf(this.getRedistributionDelay()), streamWriter);
        }
        if (this.isSendToDLAOnNoRoute() != null) {
            ElementUtils.writeSimpleElement(Element.SEND_TO_DLA_ON_NO_ROUTE, String.valueOf(this.isSendToDLAOnNoRoute()), streamWriter);
        }
        streamWriter.writeEndElement();
    }
}

