/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.CoreQueueConfiguration;
import org.hornetq.core.config.impl.ConfigurationImpl;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressSettings;
import org.jboss.as.messaging.AbstractTransportElement;
import org.jboss.as.messaging.AddressSettingsElement;
import org.jboss.as.messaging.DirectoryElement;
import org.jboss.as.messaging.HornetQService;
import org.jboss.as.messaging.MessagingSubsystemElement;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.QueueElement;
import org.jboss.as.messaging.SecuritySettingsElement;
import org.jboss.as.messaging.jms.JMSService;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.services.net.SocketBinding;
import org.jboss.as.services.path.RelativePathService;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class MessagingSubsystemAdd
extends AbstractSubsystemAdd<MessagingSubsystemElement> {
    private static final long serialVersionUID = -1306547303259739030L;
    private static final ServiceName PATH_BASE = MessagingSubsystemElement.JBOSS_MESSAGING.append(new String[]{"paths"});
    private static final String PATH_RELATIVE_TO = "jboss.server.data.dir";
    private DirectoryElement bindingsDirectory;
    private DirectoryElement journalDirectory;
    private DirectoryElement largeMessagesDirectory;
    private DirectoryElement pagingDirectory;
    private Boolean clustered;
    private Boolean persistenceEnabled;
    private Integer journalMinFiles;
    private Integer journalFileSize;
    private JournalType journalType;
    private Set<AbstractTransportElement<?>> acceptors = new HashSet();
    private Set<AbstractTransportElement<?>> connectors = new HashSet();
    private Set<SecuritySettingsElement> securitySettings = new HashSet<SecuritySettingsElement>();
    private Set<AddressSettingsElement> addressSettings = new HashSet<AddressSettingsElement>();
    private Set<QueueElement> queues = new HashSet<QueueElement>();

    public MessagingSubsystemAdd() {
        super(Namespace.MESSAGING_1_0.getUriString());
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        HornetQService hqservice = new HornetQService();
        ConfigurationImpl hqConfig = new ConfigurationImpl();
        if (this.clustered != null) {
            hqConfig.setClustered(this.clustered.booleanValue());
        }
        if (this.journalMinFiles != null) {
            hqConfig.setJournalMinFiles(this.journalMinFiles.intValue());
        }
        if (this.journalFileSize != null) {
            hqConfig.setJournalFileSize(this.journalFileSize.intValue());
        }
        if (this.journalType != null) {
            hqConfig.setJournalType(this.journalType);
        }
        if (this.persistenceEnabled != null) {
            hqConfig.setPersistenceEnabled(this.persistenceEnabled.booleanValue());
        }
        Map configAddressSettings = hqConfig.getAddressesSettings();
        for (AddressSettingsElement addressSpec : this.addressSettings) {
            AddressSettings settings = new AddressSettings();
            settings.setAddressFullMessagePolicy(addressSpec.getAddressFullMessagePolicy());
            settings.setDeadLetterAddress(addressSpec.getDeadLetterAddress());
            settings.setExpiryAddress(addressSpec.getExpiryAddress());
            if (addressSpec.isLastValueQueue() != null) {
                settings.setLastValueQueue(addressSpec.isLastValueQueue().booleanValue());
            }
            if (addressSpec.getMaxDeliveryAttempts() != null) {
                settings.setMaxDeliveryAttempts(addressSpec.getMaxDeliveryAttempts().intValue());
            }
            if (addressSpec.getMaxSizeBytes() != null) {
                settings.setMaxSizeBytes(addressSpec.getMaxSizeBytes().longValue());
            }
            if (addressSpec.getMessageCounterHistoryDayLimit() != null) {
                settings.setMessageCounterHistoryDayLimit(addressSpec.getMessageCounterHistoryDayLimit().intValue());
            }
            if (addressSpec.getPageSizeBytes() != null) {
                settings.setPageSizeBytes(addressSpec.getPageSizeBytes().longValue());
            }
            if (addressSpec.getRedeliveryDelay() != null) {
                settings.setRedeliveryDelay(addressSpec.getRedeliveryDelay().longValue());
            }
            if (addressSpec.getRedistributionDelay() != null) {
                settings.setRedistributionDelay(addressSpec.getRedistributionDelay().longValue());
            }
            if (addressSpec.isSendToDLAOnNoRoute() != null) {
                settings.setSendToDLAOnNoRoute(addressSpec.isSendToDLAOnNoRoute().booleanValue());
            }
            configAddressSettings.put(addressSpec.getMatch(), settings);
        }
        Map hqSecurityRoles = hqConfig.getSecurityRoles();
        for (SecuritySettingsElement securitySetting : this.securitySettings) {
            hqSecurityRoles.put(securitySetting.getMatch(), securitySetting.getRoles());
        }
        for (QueueElement queue : this.queues) {
            hqConfig.getQueueConfigurations().add(new CoreQueueConfiguration(queue.getAddress(), queue.getName(), queue.getFilter(), queue.isDurable().booleanValue()));
        }
        hqservice.setConfiguration((Configuration)hqConfig);
        BatchBuilder batchBuilder = updateContext.getBatchBuilder();
        BatchServiceBuilder serviceBuilder = batchBuilder.addService(MessagingSubsystemElement.JBOSS_MESSAGING, (Service)hqservice).addOptionalDependency(ServiceName.JBOSS.append(new String[]{"mbean", "server"}), MBeanServer.class, hqservice.getMBeanServer());
        JMSService.addService(batchBuilder);
        MessagingSubsystemAdd.createRelativePathService("bindings", this.bindingsDirectory, batchBuilder);
        MessagingSubsystemAdd.addPathDependency("bindings", hqservice, serviceBuilder);
        MessagingSubsystemAdd.createRelativePathService("journal", this.journalDirectory, batchBuilder);
        MessagingSubsystemAdd.addPathDependency("journal", hqservice, serviceBuilder);
        MessagingSubsystemAdd.createRelativePathService("largemessages", this.largeMessagesDirectory, batchBuilder);
        MessagingSubsystemAdd.addPathDependency("largemessages", hqservice, serviceBuilder);
        MessagingSubsystemAdd.createRelativePathService("paging", this.pagingDirectory, batchBuilder);
        MessagingSubsystemAdd.addPathDependency("paging", hqservice, serviceBuilder);
        Map connectors = hqConfig.getConnectorConfigurations();
        for (AbstractTransportElement<?> connectorSpec : this.connectors) {
            TransportConfiguration transport = new TransportConfiguration(connectorSpec.getFactoryClassName(), new HashMap(), connectorSpec.getName());
            connectorSpec.processHQConfig(transport);
            connectors.put(connectorSpec.getName(), transport);
            String socketRef = connectorSpec.getSocketBindingRef();
            if (socketRef == null) continue;
            ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketRef});
            serviceBuilder.addDependency(socketName, SocketBinding.class, hqservice.getSocketBindingInjector(socketRef));
        }
        Set acceptors = hqConfig.getAcceptorConfigurations();
        for (AbstractTransportElement<?> acceptorSpec : this.acceptors) {
            TransportConfiguration transport = new TransportConfiguration(acceptorSpec.getFactoryClassName(), new HashMap(), acceptorSpec.getName());
            acceptorSpec.processHQConfig(transport);
            acceptors.add(transport);
            String socketRef = acceptorSpec.getSocketBindingRef();
            if (socketRef == null) continue;
            ServiceName socketName = SocketBinding.JBOSS_BINDING_NAME.append(new String[]{socketRef});
            serviceBuilder.addDependency(socketName, SocketBinding.class, hqservice.getSocketBindingInjector(socketRef));
        }
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
    }

    protected MessagingSubsystemElement createSubsystemElement() {
        MessagingSubsystemElement element = new MessagingSubsystemElement();
        if (this.bindingsDirectory != null) {
            element.setBindingsDirectory(this.getBindingsDirectory());
        }
        if (this.journalDirectory != null) {
            element.setJournalDirectory(this.getJournalDirectory());
        }
        if (this.largeMessagesDirectory != null) {
            element.setLargeMessagesDirectory(this.getLargeMessagesDirectory());
        }
        if (this.pagingDirectory != null) {
            element.setPagingDirectory(this.getPagingDirectory());
        }
        if (this.clustered != null) {
            element.setClustered(this.isClustered());
        }
        if (this.persistenceEnabled != null) {
            element.setPersistenceEnabled(this.persistenceEnabled);
        }
        if (this.journalMinFiles != null) {
            element.setJournalMinFiles(this.getJournalMinFiles());
        }
        if (this.journalFileSize != null) {
            element.setJournalFileSize(this.getJournalFileSize());
        }
        if (this.journalType != null) {
            element.setJournalType(this.getJournalType());
        }
        for (AbstractTransportElement<?> abstractTransportElement : this.acceptors) {
            element.addAcceptor(abstractTransportElement);
        }
        for (AddressSettingsElement addressSettingsElement : this.addressSettings) {
            element.addAddressSettings(addressSettingsElement);
        }
        for (AbstractTransportElement abstractTransportElement : this.connectors) {
            element.addConnector(abstractTransportElement);
        }
        for (SecuritySettingsElement securitySettingsElement : this.securitySettings) {
            element.addSecuritySetting(securitySettingsElement);
        }
        for (QueueElement queueElement : this.queues) {
            element.addQueue(queueElement);
        }
        return element;
    }

    public DirectoryElement getBindingsDirectory() {
        return this.bindingsDirectory;
    }

    public void setBindingsDirectory(DirectoryElement bindingsDirectory) {
        this.bindingsDirectory = bindingsDirectory;
    }

    public DirectoryElement getJournalDirectory() {
        return this.journalDirectory;
    }

    public void setJournalDirectory(DirectoryElement journalDirectory) {
        this.journalDirectory = journalDirectory;
    }

    public DirectoryElement getLargeMessagesDirectory() {
        return this.largeMessagesDirectory;
    }

    public void setLargeMessagesDirectory(DirectoryElement largeMessagesDirectory) {
        this.largeMessagesDirectory = largeMessagesDirectory;
    }

    public DirectoryElement getPagingDirectory() {
        return this.pagingDirectory;
    }

    public void setPagingDirectory(DirectoryElement pagingDirectory) {
        this.pagingDirectory = pagingDirectory;
    }

    public Boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public Integer getJournalMinFiles() {
        return this.journalMinFiles;
    }

    public void setJournalMinFiles(int journalMinFiles) {
        this.journalMinFiles = journalMinFiles;
    }

    public Integer getJournalFileSize() {
        return this.journalFileSize;
    }

    public void setJournalFileSize(int journalFileSize) {
        this.journalFileSize = journalFileSize;
    }

    public JournalType getJournalType() {
        return this.journalType;
    }

    public void setJournalType(JournalType journalType) {
        this.journalType = journalType;
    }

    public void setPersistenceEnabled(Boolean enabled) {
        this.persistenceEnabled = enabled;
    }

    void addAcceptor(AbstractTransportElement<?> transportSpecification) {
        this.acceptors.add(transportSpecification);
    }

    void addConnector(AbstractTransportElement<?> transportSpecification) {
        this.connectors.add(transportSpecification);
    }

    void addAddressSettings(AddressSettingsElement addressSettingsSpecification) {
        this.addressSettings.add(addressSettingsSpecification);
    }

    void addSecuritySettings(SecuritySettingsElement securitySettingsSpecification) {
        this.securitySettings.add(securitySettingsSpecification);
    }

    void addQueue(QueueElement queue) {
        this.queues.add(queue);
    }

    static void addPathDependency(String name, HornetQService hqService, BatchServiceBuilder<?> serviceBuilder) {
        serviceBuilder.addDependency(PATH_BASE.append(new String[]{name}), String.class, hqService.getPathInjector(name));
    }

    static void createRelativePathService(String name, DirectoryElement dir, BatchBuilder builder) {
        if (dir != null) {
            MessagingSubsystemAdd.createRelativePathService(name, dir.getRelativeTo(), dir.getPath(), builder);
        } else {
            MessagingSubsystemAdd.createRelativePathService(name, PATH_RELATIVE_TO, "hornetq/" + name, builder);
        }
    }

    static void createRelativePathService(String name, String relativeTo, String relativePath, BatchBuilder builder) {
        RelativePathService.addService((ServiceName)PATH_BASE.append(new String[]{name}), (String)(relativePath != null ? relativePath : "hornetq/" + name), (String)(relativeTo != null ? relativeTo : PATH_RELATIVE_TO), (BatchBuilder)builder);
    }
}

