/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.hornetq.core.server.JournalType;
import org.jboss.as.messaging.AbstractTransportElement;
import org.jboss.as.messaging.AddressSettingsElement;
import org.jboss.as.messaging.DirectoryElement;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.ElementUtils;
import org.jboss.as.messaging.MessagingSubsystemAdd;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.QueueElement;
import org.jboss.as.messaging.SecuritySettingsElement;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class MessagingSubsystemElement
extends AbstractSubsystemElement<MessagingSubsystemElement> {
    private static final long serialVersionUID = 8225457441023207312L;
    public static final ServiceName JBOSS_MESSAGING = ServiceName.JBOSS.append(new String[]{"messaging"});
    public static final ServiceName CORE_QUEUE_BASE = JBOSS_MESSAGING.append(new String[]{"queue"});
    private DirectoryElement bindingsDirectory;
    private DirectoryElement journalDirectory;
    private DirectoryElement largeMessagesDirectory;
    private DirectoryElement pagingDirectory;
    private Boolean clustered;
    private Boolean persistenceEnabled;
    private int journalMinFiles = -1;
    private int journalFileSize = -1;
    private JournalType journalType;
    private final NavigableMap<String, AbstractTransportElement<?>> acceptors = new TreeMap();
    private final NavigableMap<String, AbstractTransportElement<?>> connectors = new TreeMap();
    private final NavigableMap<String, AddressSettingsElement> addressSettings = new TreeMap<String, AddressSettingsElement>();
    private final NavigableMap<String, SecuritySettingsElement> securitySettings = new TreeMap<String, SecuritySettingsElement>();
    private final NavigableMap<String, QueueElement> queues = new TreeMap<String, QueueElement>();

    public MessagingSubsystemElement() {
        super(Namespace.MESSAGING_1_0.getUriString());
    }

    protected Class<MessagingSubsystemElement> getElementClass() {
        return MessagingSubsystemElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        JournalType jt;
        if (this.bindingsDirectory != null) {
            streamWriter.writeEmptyElement(Element.BINDINGS_DIRECTORY.getLocalName());
            this.bindingsDirectory.writeContent(streamWriter);
        }
        if (this.largeMessagesDirectory != null) {
            streamWriter.writeEmptyElement(Element.LARGE_MESSAGES_DIRECTORY.getLocalName());
            this.largeMessagesDirectory.writeContent(streamWriter);
        }
        if (this.pagingDirectory != null) {
            streamWriter.writeEmptyElement(Element.PAGING_DIRECTORY.getLocalName());
            this.pagingDirectory.writeContent(streamWriter);
        }
        if (this.journalDirectory != null) {
            streamWriter.writeEmptyElement(Element.JOURNAL_DIRECTORY.getLocalName());
            this.journalDirectory.writeContent(streamWriter);
        }
        if (this.persistenceEnabled != null) {
            ElementUtils.writeSimpleElement(Element.PERSISTENCE_ENABLED, String.valueOf(this.persistenceEnabled), streamWriter);
        }
        if (this.clustered != null) {
            ElementUtils.writeSimpleElement(Element.CLUSTERED, String.valueOf(this.isClustered()), streamWriter);
        }
        if (this.journalMinFiles != -1) {
            ElementUtils.writeSimpleElement(Element.JOURNAL_MIN_FILES, String.valueOf(this.getJournalMinFiles()), streamWriter);
        }
        if ((jt = this.getJournalType()) != null) {
            ElementUtils.writeSimpleElement(Element.JOURNAL_TYPE, jt.toString(), streamWriter);
        }
        if (this.journalFileSize != -1) {
            ElementUtils.writeSimpleElement(Element.JOURNAL_FILE_SIZE, String.valueOf(this.getJournalFileSize()), streamWriter);
        }
        if (this.connectors.size() > 0) {
            streamWriter.writeStartElement(Element.CONNECTORS.getLocalName());
            for (AbstractTransportElement connector : this.connectors.values()) {
                streamWriter.writeStartElement(connector.getElement().getLocalName());
                connector.writeContent(streamWriter);
            }
            streamWriter.writeEndElement();
        }
        if (this.acceptors.size() > 0) {
            streamWriter.writeStartElement(Element.ACCEPTORS.getLocalName());
            for (AbstractTransportElement acceptor : this.acceptors.values()) {
                streamWriter.writeStartElement(acceptor.getElement().getLocalName());
                acceptor.writeContent(streamWriter);
            }
            streamWriter.writeEndElement();
        }
        if (this.queues.size() > 0) {
            streamWriter.writeStartElement(Element.QUEUES.getLocalName());
            for (QueueElement queue : this.queues.values()) {
                streamWriter.writeStartElement(Element.QUEUE.getLocalName());
                queue.writeContent(streamWriter);
            }
        }
        if (this.addressSettings.size() > 0) {
            streamWriter.writeStartElement(Element.ADDRESS_SETTINGS.getLocalName());
            for (AddressSettingsElement addressSettingsElement : this.addressSettings.values()) {
                streamWriter.writeStartElement(Element.ADDRESS_SETTING.getLocalName());
                addressSettingsElement.writeContent(streamWriter);
            }
            streamWriter.writeEndElement();
        }
        if (this.securitySettings.size() > 0) {
            streamWriter.writeStartElement(Element.SECURITY_SETTINGS.getLocalName());
            for (SecuritySettingsElement securitySettingElement : this.securitySettings.values()) {
                streamWriter.writeStartElement(Element.SECURITY_SETTING.getLocalName());
                securitySettingElement.writeContent(streamWriter);
            }
            streamWriter.writeEndElement();
        }
        streamWriter.writeEndElement();
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<MessagingSubsystemElement, ?>> list) {
    }

    protected boolean isEmpty() {
        return false;
    }

    protected AbstractSubsystemAdd<MessagingSubsystemElement> getAdd() {
        MessagingSubsystemAdd element = new MessagingSubsystemAdd();
        if (this.bindingsDirectory != null) {
            element.setBindingsDirectory(this.getBindingsDirectory());
        }
        if (this.journalDirectory != null) {
            element.setJournalDirectory(this.getJournalDirectory());
        }
        if (this.largeMessagesDirectory != null) {
            element.setLargeMessagesDirectory(this.getLargeMessagesDirectory());
        }
        if (this.pagingDirectory != null) {
            element.setPagingDirectory(this.getPagingDirectory());
        }
        if (this.clustered != null) {
            element.setClustered(this.isClustered());
        }
        if (this.persistenceEnabled != null) {
            element.setPersistenceEnabled(this.persistenceEnabled);
        }
        if (this.journalMinFiles != -1) {
            element.setJournalMinFiles(this.getJournalMinFiles());
        }
        if (this.journalFileSize != -1) {
            element.setJournalFileSize(this.getJournalFileSize());
        }
        if (this.journalType != null) {
            element.setJournalType(this.getJournalType());
        }
        for (AbstractTransportElement acceptorSpec : this.acceptors.values()) {
            element.addAcceptor(acceptorSpec);
        }
        for (AddressSettingsElement addressSpec : this.addressSettings.values()) {
            element.addAddressSettings(addressSpec);
        }
        for (AbstractTransportElement connectorSpec : this.connectors.values()) {
            element.addConnector(connectorSpec);
        }
        for (SecuritySettingsElement securitySetting : this.securitySettings.values()) {
            element.addSecuritySettings(securitySetting);
        }
        for (QueueElement queue : this.queues.values()) {
            element.addQueue(queue);
        }
        return element;
    }

    protected <P> void applyRemove(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
    }

    public DirectoryElement getBindingsDirectory() {
        return this.bindingsDirectory;
    }

    public void setBindingsDirectory(DirectoryElement bindingsDirectory) {
        this.bindingsDirectory = bindingsDirectory;
    }

    public DirectoryElement getJournalDirectory() {
        return this.journalDirectory;
    }

    public void setJournalDirectory(DirectoryElement journalDirectory) {
        this.journalDirectory = journalDirectory;
    }

    public DirectoryElement getLargeMessagesDirectory() {
        return this.largeMessagesDirectory;
    }

    public void setLargeMessagesDirectory(DirectoryElement largeMessagesDirectory) {
        this.largeMessagesDirectory = largeMessagesDirectory;
    }

    public DirectoryElement getPagingDirectory() {
        return this.pagingDirectory;
    }

    public void setPagingDirectory(DirectoryElement pagingDirectory) {
        this.pagingDirectory = pagingDirectory;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public int getJournalMinFiles() {
        return this.journalMinFiles;
    }

    public void setJournalMinFiles(int journalMinFiles) {
        this.journalMinFiles = journalMinFiles;
    }

    public int getJournalFileSize() {
        return this.journalFileSize;
    }

    public void setJournalFileSize(int journalFileSize) {
        this.journalFileSize = journalFileSize;
    }

    public JournalType getJournalType() {
        return this.journalType;
    }

    public void setJournalType(JournalType journalType) {
        this.journalType = journalType;
    }

    public boolean isPersistenceEnabled() {
        return this.persistenceEnabled;
    }

    public void setPersistenceEnabled(boolean persistenceEnabled) {
        this.persistenceEnabled = persistenceEnabled;
    }

    boolean addAcceptor(AbstractTransportElement<?> acceptor) {
        if (this.acceptors.containsKey(acceptor.getName())) {
            return false;
        }
        this.acceptors.put(acceptor.getName(), acceptor);
        return true;
    }

    public Collection<AbstractTransportElement<?>> getAcceptors() {
        return Collections.unmodifiableCollection(new HashSet(this.acceptors.values()));
    }

    boolean removeAcceptor(String name) {
        return this.acceptors.remove(name) != null;
    }

    boolean addConnector(AbstractTransportElement<?> connector) {
        if (this.connectors.containsKey(connector.getName())) {
            return false;
        }
        this.connectors.put(connector.getName(), connector);
        return true;
    }

    public Collection<AbstractTransportElement<?>> getConnectors() {
        return Collections.unmodifiableCollection(new HashSet(this.connectors.values()));
    }

    boolean removeConnector(String name) {
        return this.connectors.remove(name) != null;
    }

    boolean addAddressSettings(AddressSettingsElement spec) {
        if (this.addressSettings.containsKey(spec.getMatch())) {
            return false;
        }
        this.addressSettings.put(spec.getMatch(), spec);
        return true;
    }

    public Collection<AddressSettingsElement> getAddressSettings() {
        return Collections.unmodifiableCollection(new HashSet(this.addressSettings.values()));
    }

    boolean removeAddressSettings(String match) {
        return this.addressSettings.remove(match) != null;
    }

    boolean addSecuritySetting(SecuritySettingsElement spec) {
        if (this.securitySettings.containsKey(spec.getMatch())) {
            return false;
        }
        this.securitySettings.put(spec.getMatch(), spec);
        return true;
    }

    public Collection<SecuritySettingsElement> getSecuritySettings() {
        return Collections.unmodifiableCollection(new HashSet(this.securitySettings.values()));
    }

    boolean removeSecuritySetting(String match) {
        return this.securitySettings.remove(match) != null;
    }

    public QueueElement getQueue(String name) {
        return (QueueElement)((Object)this.queues.get(name));
    }

    QueueElement addQueue(String name) {
        QueueElement queue = new QueueElement(name);
        if (this.addQueue(queue)) {
            return queue;
        }
        return null;
    }

    boolean addQueue(QueueElement queue) {
        if (this.queues.containsKey(queue.getName())) {
            return false;
        }
        this.queues.put(queue.getName(), queue);
        return true;
    }

    boolean removeQueue(String name) {
        return this.queues.remove(name) != null;
    }
}

