/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import org.hornetq.core.server.HornetQServer;
import org.jboss.as.messaging.AbstractMessagingSubsystemUpdate;
import org.jboss.as.messaging.MessagingSubsystemElement;
import org.jboss.as.messaging.QueueElement;
import org.jboss.as.messaging.QueueRemove;
import org.jboss.as.messaging.QueueService;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class QueueAdd
extends AbstractMessagingSubsystemUpdate<Void> {
    private static final long serialVersionUID = 2210829361890051692L;
    private final String name;
    private String address;
    private String filter;
    private Boolean durable;

    public QueueAdd(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    protected void applyUpdate(MessagingSubsystemElement element) throws UpdateFailedException {
        QueueElement queue = element.addQueue(this.name);
        if (queue == null) {
            throw new UpdateFailedException("duplicate queue " + this.name);
        }
        queue.setAddress(this.address);
        queue.setFilter(this.filter);
        if (this.durable != null) {
            queue.setDurable(this.durable);
        }
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        QueueService service = new QueueService(this.address, this.name, this.filter, this.durable != null ? this.durable : true, false);
        context.getBatchBuilder().addService(MessagingSubsystemElement.CORE_QUEUE_BASE.append(new String[]{this.name}), (Service)service).addDependency(MessagingSubsystemElement.JBOSS_MESSAGING, HornetQServer.class, service.getHornetQService()).addListener((ServiceListener)new UpdateResultHandler.ServiceStartListener(resultHandler, param)).setInitialMode(ServiceController.Mode.ACTIVE);
    }

    public AbstractSubsystemUpdate<MessagingSubsystemElement, ?> getCompensatingUpdate(MessagingSubsystemElement original) {
        return new QueueRemove(this.name);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Boolean getDurable() {
        return this.durable;
    }

    public void setDurable(Boolean durable) {
        this.durable = durable;
    }

    public String getName() {
        return this.name;
    }
}

