/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.messaging.jms.AbstractJMSSubsystemUpdate;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryElement;
import org.jboss.as.messaging.jms.JMSSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class ConnectionFactoryRemove
extends AbstractJMSSubsystemUpdate<Void> {
    private static final long serialVersionUID = -4308722612702198415L;
    private final String cfName;

    public ConnectionFactoryRemove(String cfName) {
        this.cfName = cfName;
    }

    protected void applyUpdate(JMSSubsystemElement element) throws UpdateFailedException {
        if (!element.removeConnectionFactory(this.cfName)) {
            throw new UpdateFailedException(String.format("connection-factory (%s) does not exist", this.cfName));
        }
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> handler, P param) {
        ServiceController service = context.getServiceContainer().getService(JMSSubsystemElement.JMS_CF_BASE.append(new String[]{this.cfName}));
        if (service == null) {
            handler.handleSuccess(null, param);
        } else {
            service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(handler, param));
        }
    }

    public AbstractSubsystemUpdate<JMSSubsystemElement, ?> getCompensatingUpdate(JMSSubsystemElement original) {
        ConnectionFactoryElement element = original.getConnectionFactory(this.cfName);
        if (element == null) {
            return null;
        }
        return new ConnectionFactoryAdd(element);
    }
}

