/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.jboss.as.messaging.jms.AbstractJMSSubsystemUpdate;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSQueueElement;
import org.jboss.as.messaging.jms.JMSSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public class JMSQueueRemove
extends AbstractJMSSubsystemUpdate<Void> {
    private static final long serialVersionUID = -635741968258725932L;
    private final String queueName;

    public JMSQueueRemove(String queueName) {
        if (queueName == null) {
            throw new IllegalArgumentException("null name");
        }
        this.queueName = queueName;
    }

    protected void applyUpdate(JMSSubsystemElement element) throws UpdateFailedException {
        if (!element.removeQueue(this.queueName)) {
            throw new UpdateFailedException(String.format("queue (%s) does not exist", this.queueName));
        }
    }

    protected <P> void applyUpdate(UpdateContext context, UpdateResultHandler<? super Void, P> handler, P param) {
        ServiceController service = context.getServiceContainer().getService(JMSSubsystemElement.JMS_QUEUE_BASE.append(new String[]{this.queueName}));
        if (service == null) {
            handler.handleSuccess(null, param);
        } else {
            service.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(handler, param));
        }
    }

    public AbstractSubsystemUpdate<JMSSubsystemElement, ?> getCompensatingUpdate(JMSSubsystemElement original) {
        JMSQueueElement element = original.getQueue(this.queueName);
        if (element == null) {
            return null;
        }
        JMSQueueAdd action = new JMSQueueAdd(this.queueName);
        action.setBindings(element.getBindings());
        action.setSelector(element.getSelector());
        action.setDurable(element.getDurable());
        return action;
    }
}

