/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import org.hornetq.jms.server.JMSServerManager;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

class JMSQueueService
implements Service<Void> {
    private final InjectedValue<JMSServerManager> jmsServer = new InjectedValue();
    private String queueName;
    private String selectorString;
    private boolean durable;
    private String[] jndi;

    public JMSQueueService(String queueName, String selectorString, boolean durable, String[] jndi) {
        this.queueName = queueName;
        this.selectorString = selectorString;
        this.durable = durable;
        this.jndi = jndi;
    }

    public synchronized void start(StartContext context) throws StartException {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            jmsManager.createQueue(false, this.queueName, this.selectorString, this.durable, this.jndi);
        }
        catch (Exception e) {
            throw new StartException("failed to create queue", (Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        JMSServerManager jmsManager = (JMSServerManager)this.jmsServer.getValue();
        try {
            jmsManager.destroyQueue(this.queueName);
        }
        catch (Exception e) {
            Logger.getLogger((String)"org.jboss.messaging").warnf((Throwable)e, "failed to destroy jms queue: %s", (Object)this.queueName);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }

    InjectedValue<JMSServerManager> getJmsServer() {
        return this.jmsServer;
    }
}

