/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.ExtensionContext;
import org.jboss.as.messaging.jms.Attribute;
import org.jboss.as.messaging.jms.ConnectionFactoryAdd;
import org.jboss.as.messaging.jms.ConnectionFactoryConnectorRef;
import org.jboss.as.messaging.jms.ConnectionFactoryElement;
import org.jboss.as.messaging.jms.Element;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSSubsystemAdd;
import org.jboss.as.messaging.jms.JMSSubsystemElement;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.as.model.AbstractSubsystemAdd;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.ParseResult;
import org.jboss.as.model.ParseUtils;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JMSSubsystemParser
implements XMLStreamConstants,
XMLElementReader<ParseResult<ExtensionContext.SubsystemConfiguration<JMSSubsystemElement>>> {
    private static final JMSSubsystemParser INSTANCE = new JMSSubsystemParser();

    static JMSSubsystemParser getInstance() {
        return INSTANCE;
    }

    private JMSSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, ParseResult<ExtensionContext.SubsystemConfiguration<JMSSubsystemElement>> result) throws XMLStreamException {
        JMSSubsystemAdd subsystemAdd = new JMSSubsystemAdd();
        ArrayList updates = new ArrayList();
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_FACTORY: {
                    JMSSubsystemParser.processConnectionFactory(reader, updates);
                    continue block5;
                }
                case QUEUE: {
                    JMSSubsystemParser.processJMSQueue(reader, updates);
                    continue block5;
                }
                case TOPIC: {
                    JMSSubsystemParser.processJMSTopic(reader, updates);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.setResult((Object)new ExtensionContext.SubsystemConfiguration((AbstractSubsystemAdd)subsystemAdd, updates));
    }

    static void processConnectionFactory(XMLExtendedStreamReader reader, List<AbstractSubsystemUpdate<JMSSubsystemElement, ?>> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ConnectionFactoryElement cf = new ConnectionFactoryElement(name);
        HashSet<String> bindings = new HashSet<String>();
        block35: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DISCOVERY_GROUP_REF: {
                    String groupRef = reader.getAttributeValue(0);
                    if (groupRef != null) {
                        cf.setDiscoveryGroupName(groupRef.trim());
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block35;
                }
                case DISCOVERY_INITIAL_WAIT_TIMEOUT: {
                    cf.setInitialWaitTimeout(JMSSubsystemParser.textAsLong(reader));
                    continue block35;
                }
                case CONNECTORS: {
                    List<ConnectionFactoryConnectorRef> connectors = JMSSubsystemParser.processConnectors(reader);
                    if (connectors.isEmpty()) continue block35;
                    cf.setConnectorRef(connectors);
                    continue block35;
                }
                case ENTRIES: {
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        Element local = Element.forName(reader.getLocalName());
                        if (local != Element.ENTRY) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        String entry = reader.getAttributeValue(0);
                        bindings.add(entry.trim());
                        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    }
                    continue block35;
                }
                case CLIENT_FAILURE_CHECK_PERIOD: {
                    cf.setClientFailureCheckPeriod(JMSSubsystemParser.textAsLong(reader));
                    continue block35;
                }
                case CONNECTION_TTL: {
                    cf.setConnectionTTL(JMSSubsystemParser.textAsLong(reader));
                    continue block35;
                }
                case CALL_TIMEOUT: {
                    cf.setCallTimeout(JMSSubsystemParser.textAsLong(reader));
                    continue block35;
                }
                case CONSUMER_WINDOW_SIZE: {
                    cf.setConsumerWindowSize(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case CONSUMER_MAX_RATE: {
                    cf.setConsumerMaxRate(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case CONFIRMATION_WINDOW_SIZE: {
                    cf.setConfirmationWindowSize(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case PRODUCER_WINDOW_SIZE: {
                    cf.setProducerWindowSize(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case PRODUCER_MAX_RATE: {
                    cf.setProducerMaxRate(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case CACHE_LARGE_MESSAGE_CLIENT: {
                    cf.setCacheLargeMessagesClient(JMSSubsystemParser.textAsBoolean(reader));
                    continue block35;
                }
                case MIN_LARGE_MESSAGE_SIZE: {
                    cf.setMinLargeMessageSize(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case CLIENT_ID: {
                    cf.setClientID(JMSSubsystemParser.elementText(reader));
                    continue block35;
                }
                case DUPS_OK_BATCH_SIZE: {
                    cf.setDupsOKBatchSize(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case TRANSACTION_BATH_SIZE: {
                    cf.setTransactionBatchSize(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case BLOCK_ON_ACK: {
                    cf.setBlockOnAcknowledge(JMSSubsystemParser.textAsBoolean(reader));
                    continue block35;
                }
                case BLOCK_ON_NON_DURABLE_SEND: {
                    cf.setBlockOnNonDurableSend(JMSSubsystemParser.textAsBoolean(reader));
                    continue block35;
                }
                case BLOCK_ON_DURABLE_SEND: {
                    cf.setBlockOnDurableSend(JMSSubsystemParser.textAsBoolean(reader));
                    continue block35;
                }
                case AUTO_GROUP: {
                    cf.setAutoGroup(JMSSubsystemParser.textAsBoolean(reader));
                    continue block35;
                }
                case PRE_ACK: {
                    cf.setPreAcknowledge(JMSSubsystemParser.textAsBoolean(reader));
                    continue block35;
                }
                case RETRY_INTERVAL: {
                    cf.setRetryInterval(JMSSubsystemParser.textAsLong(reader));
                    continue block35;
                }
                case RETRY_INTERVAL_MULTIPLIER: {
                    cf.setRetryIntervalMultiplier(Double.valueOf(JMSSubsystemParser.elementText(reader)));
                    continue block35;
                }
                case MAX_RETRY_INTERVAL: {
                    cf.setMaxRetryInterval(JMSSubsystemParser.textAsLong(reader));
                    continue block35;
                }
                case RECONNECT_ATTEMPTS: {
                    cf.setReconnectAttempts(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case FAILOVER_ON_INITIAL_CONNECTION: {
                    cf.setFailoverOnInitialConnection(JMSSubsystemParser.textAsBoolean(reader));
                    continue block35;
                }
                case FAILOVER_ON_SERVER_SHUTDOWN: {
                    cf.setFailoverOnServerShutdown(JMSSubsystemParser.textAsBoolean(reader));
                    continue block35;
                }
                case LOAD_BALANCING_CLASS_NAME: {
                    cf.setLoadBalancingPolicyClassName(JMSSubsystemParser.elementText(reader));
                    continue block35;
                }
                case USE_GLOBAL_POOLS: {
                    cf.setUseGlobalPools(JMSSubsystemParser.textAsBoolean(reader));
                    continue block35;
                }
                case SCHEDULED_THREAD_POOL_MAX_SIZE: {
                    cf.setScheduledThreadPoolMaxSize(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case THREAD_POOL_MAX_SIZE: {
                    cf.setThreadPoolMaxSize(JMSSubsystemParser.textAsInt(reader));
                    continue block35;
                }
                case GROUP_ID: {
                    cf.setGroupID(JMSSubsystemParser.elementText(reader));
                    continue block35;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        cf.setBindings(bindings);
        updates.add(new ConnectionFactoryAdd(cf));
    }

    static void processJMSQueue(XMLExtendedStreamReader reader, List<AbstractSubsystemUpdate<JMSSubsystemElement, ?>> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        HashSet<String> bindings = new HashSet<String>();
        String selector = null;
        Boolean durable = null;
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = reader.getAttributeValue(0);
                    bindings.add(entry.trim());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block5;
                }
                case SELECTOR: {
                    if (selector != null) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.SELECTOR.getLocalName());
                    }
                    selector = reader.getElementText().trim();
                    continue block5;
                }
                case DURABLE: {
                    if (durable != null) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.DURABLE.getLocalName());
                    }
                    durable = Boolean.valueOf(reader.getElementText());
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        JMSQueueAdd action = new JMSQueueAdd(name);
        action.setSelector(selector);
        action.setBindings(bindings);
        action.setDurable(durable);
        updates.add(action);
    }

    static void processJMSTopic(XMLExtendedStreamReader reader, List<AbstractSubsystemUpdate<JMSSubsystemElement, ?>> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        HashSet<String> bindings = new HashSet<String>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = reader.getAttributeValue(0);
                    bindings.add(entry.trim());
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        JMSTopicAdd action = new JMSTopicAdd(name);
        action.setBindings(bindings);
        updates.add(action);
    }

    static List<ConnectionFactoryConnectorRef> processConnectors(XMLExtendedStreamReader reader) throws XMLStreamException {
        ArrayList<ConnectionFactoryConnectorRef> connectors = new ArrayList<ConnectionFactoryConnectorRef>();
        while (reader.hasNext() && reader.nextTag() != 2) {
            String connector = null;
            String backup = null;
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case CONNECTOR_NAME: {
                        connector = value.trim();
                        continue block5;
                    }
                    case CONNECTOR_BACKUP_NAME: {
                        backup = value.trim();
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (connector == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.CONNECTOR_NAME));
            }
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.CONNECTOR_REF) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            ConnectionFactoryConnectorRef ref = new ConnectionFactoryConnectorRef();
            ref.setConnectorName(connector);
            if (backup != null) {
                ref.setBackupName(backup);
            }
            connectors.add(ref);
        }
        return connectors;
    }

    static Boolean textAsBoolean(XMLExtendedStreamReader reader) throws XMLStreamException {
        return Boolean.valueOf(JMSSubsystemParser.elementText(reader));
    }

    static Integer textAsInt(XMLExtendedStreamReader reader) throws XMLStreamException {
        return Integer.valueOf(JMSSubsystemParser.elementText(reader));
    }

    static Long textAsLong(XMLExtendedStreamReader reader) throws XMLStreamException {
        return Long.valueOf(JMSSubsystemParser.elementText(reader));
    }

    static String elementText(XMLExtendedStreamReader reader) throws XMLStreamException {
        return reader.getElementText().trim();
    }
}

