/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.jms;

import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.messaging.jms.Attribute;
import org.jboss.as.messaging.jms.Element;
import org.jboss.as.model.AbstractModelElement;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JMSTopicElement
extends AbstractModelElement<JMSTopicElement> {
    private static final long serialVersionUID = 7877459701976545141L;
    private final String name;
    private Set<String> bindings;

    public JMSTopicElement(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        this.name = name;
    }

    public Set<String> getBindings() {
        return this.bindings;
    }

    public void setBindings(Set<String> bindings) {
        this.bindings = bindings;
    }

    public String getName() {
        return this.name;
    }

    protected Class<JMSTopicElement> getElementClass() {
        return JMSTopicElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.NAME.getLocalName(), this.name);
        if (this.bindings != null && this.bindings.size() > 0) {
            for (String binding : this.bindings) {
                streamWriter.writeEmptyElement(Element.ENTRY.getLocalName());
                streamWriter.writeAttribute(Attribute.NAME.getLocalName(), binding);
            }
        }
        streamWriter.writeEndElement();
    }
}

