/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.ActionHierarchy;
import com.arjuna.ats.arjuna.coordinator.ActionManager;
import com.arjuna.ats.arjuna.coordinator.ActionStatus;
import com.arjuna.ats.arjuna.coordinator.AsyncCommit;
import com.arjuna.ats.arjuna.coordinator.AsyncPrepare;
import com.arjuna.ats.arjuna.coordinator.CheckedAction;
import com.arjuna.ats.arjuna.coordinator.CheckedActionFactory;
import com.arjuna.ats.arjuna.coordinator.RecordList;
import com.arjuna.ats.arjuna.coordinator.RecordListIterator;
import com.arjuna.ats.arjuna.coordinator.RecordType;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseOutcome;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.coordinator.TxStats;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.ThreadUtil;
import com.arjuna.ats.arjuna.utils.Utility;
import com.arjuna.ats.internal.arjuna.Header;
import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;

public class BasicAction
extends StateManager {
    protected RecordList pendingList;
    protected RecordList preparedList;
    protected RecordList readonlyList;
    protected RecordList failedList;
    protected RecordList heuristicList;
    protected boolean savedIntentionList;
    private ActionHierarchy currentHierarchy;
    private ObjectStore currentStore;
    private int actionStatus;
    private int actionType;
    private BasicAction parentAction;
    private AbstractRecord recordBeingHandled;
    private int heuristicDecision;
    private CheckedAction _checkedAction;
    private Hashtable _childThreads;
    private Hashtable _childActions;
    private static CheckedActionFactory _checkedActionFactory = arjPropertyManager.getCoordinatorEnvironmentBean().getCheckedActionFactory();

    public BasicAction() {
        super(2);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::BasicAction()");
        }
        this.pendingList = null;
        this.preparedList = null;
        this.readonlyList = null;
        this.failedList = null;
        this.heuristicList = null;
        this.currentHierarchy = null;
        this.currentStore = null;
        this.savedIntentionList = false;
        this.actionStatus = 8;
        this.actionType = 1;
        this.parentAction = null;
        this.recordBeingHandled = null;
        this.heuristicDecision = 0;
        this._checkedAction = _checkedActionFactory.getCheckedAction(this.get_uid(), this.type());
        this._childThreads = null;
        this._childActions = null;
    }

    public BasicAction(Uid objUid) {
        super(objUid, 2);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::BasicAction(" + objUid + ")");
        }
        this.pendingList = null;
        this.preparedList = null;
        this.readonlyList = null;
        this.failedList = null;
        this.heuristicList = null;
        this.currentHierarchy = null;
        this.currentStore = null;
        this.savedIntentionList = false;
        this.actionStatus = 8;
        this.actionType = 1;
        this.parentAction = null;
        this.recordBeingHandled = null;
        this.heuristicDecision = 0;
        this._checkedAction = _checkedActionFactory.getCheckedAction(this.get_uid(), this.type());
        this._childThreads = null;
        this._childActions = null;
    }

    @Override
    public void finalize() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::finalize()");
        }
        if (this.actionStatus == 0 || this.actionStatus == 3) {
            BasicAction currentAct = BasicAction.Current();
            if (currentAct != null && currentAct != this && currentAct.isAncestor(this.get_uid())) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_1", new Object[]{this.get_uid()});
                }
                while (currentAct != this && currentAct != null) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_2", new Object[]{currentAct.get_uid()});
                    }
                    currentAct.Abort();
                    currentAct = BasicAction.Current();
                }
            }
            for (BasicAction parentAct = this.parent(); parentAct != null; parentAct = parentAct.parent()) {
                parentAct.preventCommit();
            }
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_3", new Object[]{this.get_uid()});
            }
            this.Abort();
        } else if (this.actionStatus == 5) {
            Thread.yield();
        }
        this.pendingList = null;
        this.preparedList = null;
        this.readonlyList = null;
        this.failedList = null;
        this.heuristicList = null;
        this.currentStore = null;
        this.currentHierarchy = null;
        this._checkedAction = null;
        if (this._childThreads != null) {
            this._childThreads.clear();
            this._childThreads = null;
        }
        if (this._childActions != null) {
            this._childActions.clear();
            this._childActions = null;
        }
    }

    public final synchronized ActionHierarchy getHierarchy() {
        return this.currentHierarchy;
    }

    public final boolean preventCommit() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::preventCommit( " + this + ")");
        }
        boolean res = false;
        if (this.actionStatus == 0) {
            this.actionStatus = 3;
        }
        res = this.actionStatus == 3 || this.actionStatus == 4 || this.actionStatus == 2;
        return res;
    }

    public final int activeThreads() {
        if (this._childThreads != null) {
            return this._childThreads.size();
        }
        return 0;
    }

    public final synchronized int add(AbstractRecord A) {
        int result = 3;
        this.criticalStart();
        if (!(this.actionStatus > 2 || this.recordBeingHandled != null && this.recordBeingHandled.equals(A))) {
            if (this.pendingList == null) {
                this.pendingList = new RecordList();
            }
            result = this.pendingList.insert(A) ? 2 : 4;
        }
        this.criticalEnd();
        return result;
    }

    public final synchronized int hierarchyDepth() {
        if (this.currentHierarchy != null) {
            return this.currentHierarchy.depth();
        }
        return 0;
    }

    public final boolean isAncestor(Uid ancestor) {
        boolean res = false;
        if (this.get_uid().equals(ancestor)) {
            res = true;
        } else if (this.parentAction != null && this.actionType != 0) {
            res = this.parentAction.isAncestor(ancestor);
        }
        return res;
    }

    public final BasicAction parent() {
        if (this.actionType == 1) {
            return this.parentAction;
        }
        return null;
    }

    public final int typeOfAction() {
        return this.actionType;
    }

    @Override
    public final int status() {
        int s = 9;
        s = this.actionStatus;
        return s;
    }

    @Override
    public ObjectStore getStore() {
        if (this.currentStore == null) {
            this.currentStore = TxControl.getStore();
        }
        return this.currentStore;
    }

    public final ObjectStore store() {
        return this.getStore();
    }

    public final Uid topLevelActionUid() {
        BasicAction root = this;
        while (root.parent() != null) {
            root = root.parent();
        }
        return root.get_uid();
    }

    public final BasicAction topLevelAction() {
        BasicAction root = this;
        while (root.parent() != null) {
            root = root.parent();
        }
        return root;
    }

    @Override
    public boolean activate() {
        return this.activate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activate(String root) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::activate() for action-id " + this.get_uid());
        }
        boolean restored = false;
        ObjectStore aaStore = this.store();
        if (aaStore == null) {
            return false;
        }
        try {
            InputObjectState oState = aaStore.read_committed(this.getSavingUid(), this.type());
            if (oState != null) {
                BasicAction basicAction = this;
                synchronized (basicAction) {
                    restored = this.restore_state(oState, 1);
                }
                oState = null;
            } else {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_5", new Object[]{this.get_uid(), this.type()});
                }
                restored = false;
            }
            return restored;
        }
        catch (ObjectStoreException e) {
            if (tsLogger.arjLogger.isWarnEnabled()) {
                tsLogger.arjLogger.warn(e);
            }
            return false;
        }
    }

    @Override
    public boolean deactivate() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::deactivate() for action-id " + this.get_uid());
        }
        boolean deactivated = false;
        ObjectStore aaStore = this.store();
        if (aaStore == null) {
            return false;
        }
        try {
            OutputObjectState oState = new OutputObjectState();
            if (this.save_state(oState, 1)) {
                deactivated = aaStore.write_committed(this.getSavingUid(), this.type(), oState);
                oState = null;
            } else {
                deactivated = false;
            }
            if (!deactivated && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_5a", new Object[]{this.get_uid(), this.type()});
            }
        }
        catch (ObjectStoreException e) {
            if (tsLogger.arjLogger.isWarnEnabled()) {
                tsLogger.arjLogger.warn(e);
            }
            deactivated = false;
        }
        return deactivated;
    }

    public final boolean addChildThread() {
        return this.addChildThread(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addChildThread(Thread t) {
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_6", new Object[]{this.get_uid(), t});
        }
        if (t == null) {
            return false;
        }
        boolean result = false;
        this.criticalStart();
        BasicAction basicAction = this;
        synchronized (basicAction) {
            if (this.actionStatus <= 2) {
                if (this._childThreads == null) {
                    this._childThreads = new Hashtable();
                }
                this._childThreads.put(ThreadUtil.getThreadId(t), t);
                result = true;
            }
        }
        this.criticalEnd();
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_7", new Object[]{this.get_uid(), t, new Boolean(result)});
        }
        return result;
    }

    public final boolean removeChildThread() {
        return this.removeChildThread(ThreadUtil.getThreadId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeChildThread(String threadId) {
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_8", new Object[]{this.get_uid(), threadId});
        }
        if (threadId == null) {
            return false;
        }
        boolean result = false;
        this.criticalStart();
        BasicAction basicAction = this;
        synchronized (basicAction) {
            if (this._childThreads != null) {
                this._childThreads.remove(threadId);
                result = true;
            }
        }
        this.criticalEnd();
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            if (result) {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_9", new Object[]{this.get_uid(), threadId, "true"});
            } else {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_9", new Object[]{this.get_uid(), threadId, "false"});
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addChildAction(BasicAction act) {
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_10", new Object[]{this.get_uid(), act != null ? act.get_uid() : Uid.nullUid()});
        }
        if (act == null) {
            return false;
        }
        boolean result = false;
        this.criticalStart();
        BasicAction basicAction = this;
        synchronized (basicAction) {
            if (this.actionStatus <= 2) {
                if (this._childActions == null) {
                    this._childActions = new Hashtable();
                }
                this._childActions.put(act, act);
                result = true;
            }
        }
        this.criticalEnd();
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            if (result) {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_11", new Object[]{this.get_uid(), act.get_uid(), "true"});
            } else {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_11", new Object[]{this.get_uid(), act.get_uid(), "false"});
            }
        }
        return result;
    }

    @Override
    public boolean save_state(OutputObjectState os, int ot) {
        boolean havePacked;
        AbstractRecord first;
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::save_state ()");
        }
        try {
            this.packHeader(os, new Header(this.get_uid(), Utility.getProcessUid()));
        }
        catch (IOException e) {
            return false;
        }
        RecordList listToSave = null;
        boolean res = true;
        listToSave = this.failedList != null && this.failedList.size() > 0 ? this.failedList : this.preparedList;
        AbstractRecord temp = first = listToSave != null ? listToSave.getFront() : null;
        boolean bl = havePacked = listToSave != null;
        while (res && temp != null) {
            listToSave.putRear(temp);
            if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                if (temp.doSave()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_14", new Object[]{Integer.toString(temp.typeIs()), temp.type(), "true"});
                } else {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_14", new Object[]{Integer.toString(temp.typeIs()), temp.type(), "false"});
                }
            }
            if (temp.doSave()) {
                res = true;
                try {
                    if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                        tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_15", new Object[]{Integer.toString(temp.typeIs())});
                    }
                    os.packInt(temp.typeIs());
                    res = temp.save_state(os, ot);
                }
                catch (IOException e) {
                    res = false;
                }
            }
            if ((temp = listToSave.getFront()) != first) continue;
            listToSave.putFront(temp);
            temp = null;
        }
        if (res && (os.notempty() || !havePacked)) {
            try {
                if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_16");
                }
                os.packInt(463);
            }
            catch (IOException e) {
                res = false;
            }
        }
        if (res) {
            int hSize = this.heuristicList == null ? 0 : this.heuristicList.size();
            try {
                os.packInt(hSize);
            }
            catch (IOException e) {
                res = false;
            }
            if (res && hSize > 0) {
                temp = first = this.heuristicList.getFront();
                while (res && temp != null) {
                    this.heuristicList.putRear(temp);
                    if (temp.doSave()) {
                        res = true;
                        try {
                            if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_17", new Object[]{Integer.toString(temp.typeIs())});
                            }
                            os.packInt(temp.typeIs());
                            res = temp.save_state(os, ot);
                        }
                        catch (IOException e) {
                            res = false;
                        }
                    }
                    if ((temp = this.heuristicList.getFront()) != first) continue;
                    this.heuristicList.putFront(temp);
                    temp = null;
                }
                if (res && os.notempty()) {
                    try {
                        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_18");
                        }
                        os.packInt(463);
                    }
                    catch (IOException e) {
                        res = false;
                    }
                }
            }
        }
        if (res && os.notempty()) {
            try {
                if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_19", new Object[]{ActionStatus.stringForm(this.actionStatus)});
                }
                os.packInt(this.actionStatus);
                os.packInt(this.actionType);
                os.packInt(this.heuristicDecision);
            }
            catch (IOException e) {
                res = false;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeChildAction(BasicAction act) {
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_12", new Object[]{this.get_uid(), act != null ? act.get_uid() : Uid.nullUid()});
        }
        if (act == null) {
            return false;
        }
        boolean result = false;
        this.criticalStart();
        BasicAction basicAction = this;
        synchronized (basicAction) {
            if (this._childActions != null) {
                this._childActions.remove(act);
                result = true;
            }
        }
        this.criticalEnd();
        if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
            if (result) {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_13", new Object[]{this.get_uid(), act.get_uid(), "true"});
            } else {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_13", new Object[]{this.get_uid(), act.get_uid(), "false"});
            }
        }
        return result;
    }

    protected final synchronized void setCheckedAction(CheckedAction c) {
        this.criticalStart();
        this._checkedAction = c;
        this.criticalEnd();
    }

    public Uid getSavingUid() {
        return this.get_uid();
    }

    public String toString() {
        return new String("BasicAction: " + this.get_uid() + " status: " + ActionStatus.stringForm(this.actionStatus));
    }

    @Override
    public boolean restore_state(InputObjectState os, int ot) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::restore_state ()");
        }
        this.createPreparedLists();
        boolean res = true;
        int record_type = 463;
        int tempActionStatus = 9;
        int tempActionType = 0;
        int tempHeuristicDecision = 0;
        try {
            Header hdr = new Header();
            this.unpackHeader(os, hdr);
        }
        catch (IOException e) {
            return false;
        }
        try {
            record_type = os.unpackInt();
            if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_20", new Object[]{Integer.toString(record_type)});
            }
        }
        catch (IOException e) {
            res = false;
        }
        while (res && record_type != 463) {
            AbstractRecord record = AbstractRecord.create(record_type);
            if (record == null) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_21", new Object[]{Integer.toString(record_type)});
                }
                res = false;
            } else {
                boolean bl = res = record.restore_state(os, ot) && this.preparedList.insert(record);
            }
            if (!res) continue;
            try {
                record_type = os.unpackInt();
                if (!tsLogger.arjLoggerI18N.isDebugEnabled()) continue;
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_20", new Object[]{Integer.toString(record_type)});
            }
            catch (IOException e) {
                res = false;
            }
        }
        int hSize = 0;
        if (res) {
            try {
                hSize = os.unpackInt();
                if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_22", new Object[]{Integer.toString(hSize)});
                }
            }
            catch (IOException e) {
                res = false;
            }
        }
        if (hSize > 0) {
            try {
                record_type = os.unpackInt();
                if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_23", new Object[]{Integer.toString(record_type)});
                }
            }
            catch (IOException e) {
                res = false;
            }
            while (res && record_type != 463) {
                AbstractRecord record = AbstractRecord.create(record_type);
                try {
                    res = record.restore_state(os, ot) && this.heuristicList.insert(record);
                    record_type = os.unpackInt();
                    if (!tsLogger.arjLoggerI18N.isDebugEnabled()) continue;
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_23", new Object[]{Integer.toString(record_type)});
                }
                catch (IOException e) {
                    res = false;
                }
                catch (NullPointerException ex) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.norecordfound", new Object[]{record_type});
                    }
                    res = false;
                }
            }
        }
        if (res) {
            try {
                tempActionStatus = os.unpackInt();
                tempActionType = os.unpackInt();
                tempHeuristicDecision = os.unpackInt();
            }
            catch (IOException e) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_24");
                }
                res = false;
            }
        }
        if (res) {
            if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_25", new Object[]{ActionStatus.stringForm(tempActionStatus), Integer.toString(tempActionStatus)});
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_26", new Object[]{tempActionType == 1 ? "Nested" : "Top-level", Integer.toString(tempActionType)});
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_27", new Object[]{TwoPhaseOutcome.stringForm(tempHeuristicDecision), Integer.toString(tempHeuristicDecision)});
            }
            this.actionStatus = tempActionStatus;
            this.actionType = tempActionType;
            this.heuristicDecision = tempHeuristicDecision;
            this.savedIntentionList = true;
        }
        return res;
    }

    @Override
    public String type() {
        return "/StateManager/BasicAction";
    }

    public static BasicAction Current() {
        return ThreadActionData.currentAction();
    }

    public static boolean maintainHeuristics() {
        return TxControl.maintainHeuristics;
    }

    @Override
    public boolean destroy() {
        return true;
    }

    public final Object[] childTransactions() {
        int size;
        int n = size = this._childActions == null ? 0 : this._childActions.size();
        if (size > 0) {
            Collection c = this._childActions.values();
            return c.toArray();
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof BasicAction && ((BasicAction)obj).get_uid().equals(this.get_uid());
    }

    protected boolean forgetHeuristics() {
        if (this.heuristicList != null && this.heuristicList.size() > 0) {
            this.doForget(this.heuristicList);
            this.updateState();
            return this.heuristicList.size() == 0;
        }
        return true;
    }

    protected synchronized int Begin(BasicAction parentAct) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::Begin() for action-id " + this.get_uid());
        }
        if (!TxControl.isEnabled()) {
            this.actionStatus = 3;
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.notrunning");
            }
        } else if (this.actionStatus != 8) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_29", new Object[]{this.get_uid(), ActionStatus.stringForm(this.actionStatus)});
            }
        } else {
            this.actionInitialise(parentAct);
            this.actionStatus = 0;
            if (this.actionType != 0 && (parentAct == null || parentAct.status() > 0)) {
                this.actionStatus = 3;
                if (parentAct == null) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_30", new Object[]{this.get_uid()});
                    }
                } else if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_31", new Object[]{this.get_uid(), parentAct.get_uid(), Integer.toString(parentAct.status())});
                }
            }
            ActionManager.manager().put(this);
            if (TxStats.enabled()) {
                TxStats.getInstance().incrementTransactions();
                if (parentAct != null) {
                    TxStats.getInstance().incrementNestedTransactions();
                }
            }
        }
        return this.actionStatus;
    }

    protected synchronized int End(boolean reportHeuristics) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::End() for action-id " + this.get_uid());
        }
        if (this.actionStatus != 0 && this.actionStatus != 3) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                switch (this.actionStatus) {
                    case 8: {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_33", new Object[]{this.get_uid()});
                        break;
                    }
                    case 7: {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_34", new Object[]{this.get_uid()});
                        break;
                    }
                    default: {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_35", new Object[]{this.get_uid()});
                    }
                }
            }
            return this.actionStatus;
        }
        if (!this.checkIsCurrent() || this.checkChildren(true) || this.actionStatus == 3) {
            return this.Abort();
        }
        if (this.pendingList != null) {
            if (this.doOnePhase()) {
                this.onePhaseCommit(reportHeuristics);
                ActionManager.manager().remove(this.get_uid());
            } else if (this.prepare(reportHeuristics) == 1) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_36", new Object[]{this.get_uid()});
                }
                if (this.heuristicDecision != 0 && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_37", new Object[]{TwoPhaseOutcome.stringForm(this.heuristicDecision)});
                }
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_38");
                }
                if (!reportHeuristics && TxControl.asyncCommit && this.parentAction == null) {
                    AsyncCommit.create(this, false);
                } else {
                    this.phase2Abort(reportHeuristics);
                }
            } else if (!reportHeuristics && TxControl.asyncCommit && this.parentAction == null) {
                AsyncCommit.create(this, true);
            } else {
                this.phase2Commit(reportHeuristics);
            }
        } else {
            ActionManager.manager().remove(this.get_uid());
            this.actionStatus = 7;
            if (TxStats.enabled() && this.heuristicDecision != 3) {
                TxStats.getInstance().incrementCommittedTransactions();
            }
        }
        boolean returnCurrentStatus = false;
        if (reportHeuristics || !reportHeuristics && !TxControl.asyncCommit) {
            returnCurrentStatus = true;
        }
        if (returnCurrentStatus) {
            if (reportHeuristics) {
                switch (this.heuristicDecision) {
                    case 0: 
                    case 7: {
                        break;
                    }
                    case 3: {
                        return 11;
                    }
                    case 4: {
                        return 12;
                    }
                    case 5: {
                        return 13;
                    }
                    default: {
                        return 14;
                    }
                }
            }
            switch (this.actionStatus) {
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    if (reportHeuristics) break;
                    return 7;
                }
            }
            return this.actionStatus;
        }
        return 6;
    }

    protected synchronized int Abort() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::Abort() for action-id " + this.get_uid());
        }
        if (this.actionStatus != 0 && this.actionStatus != 3 && this.actionStatus != 6) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                switch (this.actionStatus) {
                    case 8: {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_39", new Object[]{this.get_uid()});
                        break;
                    }
                    case 4: {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_40", new Object[]{this.get_uid()});
                        break;
                    }
                    default: {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_41", new Object[]{this.get_uid()});
                    }
                }
            }
            return this.actionStatus;
        }
        this.checkIsCurrent();
        this.checkChildren(false);
        if (this.pendingList != null) {
            this.actionStatus = 2;
            while (this.pendingList.size() > 0) {
                this.doAbort(this.pendingList, false);
            }
            this.forgetHeuristics();
        }
        ActionManager.manager().remove(this.get_uid());
        this.actionStatus = 4;
        if (TxStats.enabled()) {
            TxStats.getInstance().incrementAbortedTransactions();
        }
        return this.actionStatus;
    }

    protected BasicAction(int at) {
        super(2);
        this.pendingList = null;
        this.preparedList = null;
        this.readonlyList = null;
        this.failedList = null;
        this.heuristicList = null;
        this.currentHierarchy = null;
        this.currentStore = null;
        this.savedIntentionList = false;
        this.actionStatus = 8;
        this.actionType = at;
        this.parentAction = null;
        this.recordBeingHandled = null;
        this.heuristicDecision = 0;
        this._checkedAction = _checkedActionFactory.getCheckedAction(this.get_uid(), this.type());
        this._childThreads = null;
        this._childActions = null;
    }

    protected BasicAction(Uid u, int at) {
        super(u, 2);
        this.pendingList = null;
        this.preparedList = null;
        this.readonlyList = null;
        this.failedList = null;
        this.heuristicList = null;
        this.currentHierarchy = null;
        this.currentStore = null;
        this.savedIntentionList = false;
        this.actionStatus = 8;
        this.actionType = at;
        this.parentAction = null;
        this.recordBeingHandled = null;
        this.heuristicDecision = 0;
        this._checkedAction = _checkedActionFactory.getCheckedAction(this.get_uid(), this.type());
        this._childThreads = null;
        this._childActions = null;
    }

    protected final void criticalStart() {
    }

    protected final void criticalEnd() {
    }

    protected final synchronized void phase2Cleanup() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::phase2Cleanup() for action-id " + this.get_uid());
        }
        this.criticalStart();
        this.actionStatus = 10;
        while (this.preparedList != null && this.preparedList.size() > 0) {
            this.doCleanup(this.preparedList);
        }
        while (this.readonlyList != null && this.readonlyList.size() > 0) {
            this.doCleanup(this.readonlyList);
        }
        while (this.pendingList != null && this.pendingList.size() > 0) {
            this.doCleanup(this.pendingList);
        }
        this.criticalEnd();
    }

    protected final synchronized void phase2Commit(boolean reportHeuristics) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::phase2Commit() for action-id " + this.get_uid());
        }
        if (this.pendingList != null && this.pendingList.size() > 0) {
            int size;
            int n = size = this.pendingList == null ? 0 : this.pendingList.size();
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_42", new Object[]{this.get_uid(), Integer.toString(size), this.pendingList});
            }
            this.phase2Abort(reportHeuristics);
        } else {
            this.criticalStart();
            this.actionStatus = 6;
            this.doCommit(this.preparedList, reportHeuristics);
            if (this.heuristicDecision != 0 && this.heuristicDecision == 4) {
                this.heuristicDecision = 7;
            }
            if (this.readonlyList != null && this.readonlyList.size() > 0) {
                if (!TxControl.readonlyOptimisation && this.readonlyList != null) {
                    this.doCommit(this.readonlyList, reportHeuristics);
                }
                while ((this.recordBeingHandled = this.readonlyList.getFront()) != null) {
                    if (this.actionType == 1 && this.recordBeingHandled.propagateOnCommit()) {
                        this.merge(this.recordBeingHandled);
                        continue;
                    }
                    this.recordBeingHandled = null;
                }
            }
            this.forgetHeuristics();
            this.actionStatus = 7;
            this.updateState();
            ActionManager.manager().remove(this.get_uid());
            this.criticalEnd();
            if (TxStats.enabled() && this.heuristicDecision != 3) {
                TxStats.getInstance().incrementCommittedTransactions();
            }
        }
    }

    protected final synchronized void phase2Abort(boolean reportHeuristics) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::phase2Abort() for action-id " + this.get_uid());
        }
        this.criticalStart();
        this.actionStatus = 2;
        if (this.preparedList != null) {
            this.doAbort(this.preparedList, reportHeuristics);
        }
        if (!TxControl.readonlyOptimisation && this.readonlyList != null) {
            this.doAbort(this.readonlyList, reportHeuristics);
        }
        if (this.pendingList != null) {
            this.doAbort(this.pendingList, reportHeuristics);
        }
        if (this.heuristicDecision != 0 && this.heuristicDecision == 3) {
            this.heuristicDecision = 7;
        }
        this.forgetHeuristics();
        this.actionStatus = this.abortStatus();
        this.updateState();
        ActionManager.manager().remove(this.get_uid());
        this.criticalEnd();
        if (TxStats.enabled()) {
            TxStats.getInstance().incrementResourceRollbacks();
            TxStats.getInstance().incrementAbortedTransactions();
        }
    }

    protected final synchronized int prepare(boolean reportHeuristics) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::prepare () for action-id " + this.get_uid());
        }
        boolean commitAllowed = this.actionStatus != 3;
        this.actionStatus = 1;
        if (!commitAllowed) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_43", new Object[]{this.get_uid()});
            }
            this.actionStatus = 5;
            return 1;
        }
        if (this.actionType == 0 && this.store() == null) {
            this.actionStatus = 3;
            return 1;
        }
        this.criticalStart();
        this.createPreparedLists();
        int p = 0;
        if (this.actionType == 0 && TxControl.asyncPrepare) {
            int i;
            int numberOfThreads = this.pendingList != null ? this.pendingList.size() : 0;
            Thread[] threads = new Thread[numberOfThreads];
            for (i = 0; i < numberOfThreads; ++i) {
                threads[i] = AsyncPrepare.create(this, reportHeuristics, this.pendingList.getFront());
            }
            for (i = 0; i < numberOfThreads; ++i) {
                threads[i].start();
                Thread.yield();
            }
            for (int j = 0; j < numberOfThreads; ++j) {
                while (threads[j].isAlive()) {
                    try {
                        threads[j].join();
                    }
                    catch (Exception e) {
                        if (tsLogger.arjLogger.isWarnEnabled()) {
                            tsLogger.arjLogger.warn(e);
                        }
                        p = 1;
                    }
                }
                if (p == 0) {
                    p = ((AsyncPrepare)threads[j]).outcome();
                }
                threads[j] = null;
            }
        } else {
            boolean ok = true;
            do {
                try {
                    p = this.doPrepare(reportHeuristics);
                    if (p == 0 || p == 2) continue;
                    ok = false;
                }
                catch (IndexOutOfBoundsException e) {
                    ok = false;
                }
            } while (ok);
        }
        if (p != 0 && p != 2) {
            if (this.actionType == 1 && this.preparedList.size() > 0 && p == 10) {
                AbstractRecord tmpRec = this.preparedList.getFront();
                while (tmpRec != null) {
                    this.merge(tmpRec);
                    tmpRec = this.preparedList.getFront();
                }
                if (this.parentAction != null) {
                    this.parentAction.preventCommit();
                } else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_44");
                }
            }
            this.criticalEnd();
            return 1;
        }
        boolean stateToSave = false;
        RecordListIterator iter = new RecordListIterator(this.preparedList);
        while ((this.recordBeingHandled = iter.iterate()) != null) {
            if (!stateToSave) {
                stateToSave = this.recordBeingHandled.doSave();
            }
            if (!stateToSave) continue;
        }
        iter = null;
        if (!stateToSave) {
            iter = new RecordListIterator(this.heuristicList);
            while ((this.recordBeingHandled = this.heuristicList.getFront()) != null) {
                if (!stateToSave) {
                    stateToSave = this.recordBeingHandled.doSave();
                }
                if (!stateToSave) continue;
            }
            iter = null;
        }
        this.actionStatus = this.actionType == 0 ? this.preparedStatus() : 5;
        if (this.actionType == 0 && stateToSave && (this.preparedList.size() > 0 || this.heuristicList.size() > 0)) {
            String tn;
            Uid u = this.getSavingUid();
            OutputObjectState state = new OutputObjectState(u, tn = this.type());
            if (!this.save_state(state, 1)) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_45", new Object[]{this.get_uid()});
                }
                this.criticalEnd();
                return 1;
            }
            if (state.notempty()) {
                try {
                    if (!this.currentStore.write_committed(u, tn, state)) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_46", new Object[]{this.get_uid()});
                        }
                        this.criticalEnd();
                        return 1;
                    }
                    this.savedIntentionList = true;
                }
                catch (ObjectStoreException e) {
                    this.criticalEnd();
                    return 1;
                }
            }
        }
        this.criticalEnd();
        if (this.preparedList.size() == 0 && this.readonlyList.size() >= 0) {
            return 2;
        }
        return 0;
    }

    protected void onePhaseCommit(boolean reportHeuristics) {
        int p;
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::onePhaseCommit() for action-id " + this.get_uid());
        }
        if (this.actionStatus == 3) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_43", new Object[]{this.get_uid()});
            }
            this.Abort();
            return;
        }
        this.actionStatus = 6;
        this.criticalStart();
        if (this.heuristicList == null && reportHeuristics) {
            this.heuristicList = new RecordList();
        }
        if (this.failedList == null) {
            this.failedList = new RecordList();
        }
        boolean stateToSave = false;
        this.recordBeingHandled = this.pendingList.getFront();
        int n = p = this.actionType == 0 ? this.recordBeingHandled.topLevelOnePhaseCommit() : this.recordBeingHandled.nestedOnePhaseCommit();
        if (p == 7 || p == 2) {
            if (this.actionType == 1 && this.recordBeingHandled.propagateOnCommit()) {
                this.merge(this.recordBeingHandled);
            } else {
                this.recordBeingHandled = null;
            }
            this.actionStatus = 7;
        } else if (p == 8 || p == 10) {
            if (p == 8) {
                if (!this.failedList.insert(this.recordBeingHandled)) {
                    this.recordBeingHandled = null;
                } else if (!stateToSave) {
                    stateToSave = this.recordBeingHandled.doSave();
                }
                this.actionStatus = 7;
            } else {
                this.actionStatus = 4;
            }
        } else {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_47", new Object[]{this.get_uid(), TwoPhaseOutcome.stringForm(p)});
            }
            if (reportHeuristics) {
                this.updateHeuristic(p, true);
                if (!this.heuristicList.insert(this.recordBeingHandled)) {
                    this.recordBeingHandled = null;
                } else if (!stateToSave) {
                    stateToSave = this.recordBeingHandled.doSave();
                }
            }
            if (this.heuristicDecision == 3) {
                this.heuristicDecision = 0;
                this.actionStatus = 4;
            } else if (this.heuristicDecision == 4) {
                this.heuristicDecision = 0;
                this.actionStatus = 7;
            } else {
                this.actionStatus = 14;
            }
        }
        if (this.actionType == 0 && stateToSave && (this.heuristicList.size() > 0 || this.failedList.size() > 0)) {
            if (this.store() == null) {
                if (tsLogger.arjLoggerI18N.isFatalEnabled()) {
                    tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.coordinator.BasicAction_48");
                }
                throw new FatalError(tsLogger.arjLoggerI18N.getString("com.arjuna.ats.arjuna.coordinator.BasicAction_69") + this.get_uid());
            }
            this.updateState();
        }
        this.forgetHeuristics();
        ActionManager.manager().remove(this.get_uid());
        this.criticalEnd();
        if (TxStats.enabled()) {
            if (this.actionStatus == 4) {
                TxStats.getInstance().incrementAbortedTransactions();
            } else {
                TxStats.getInstance().incrementCommittedTransactions();
            }
        }
    }

    protected final synchronized int getHeuristicDecision() {
        return this.heuristicDecision;
    }

    protected final synchronized void setHeuristicDecision(int p) {
        this.heuristicDecision = p;
    }

    protected final synchronized void addRecord(AbstractRecord A) {
        this.preparedList.insert(A);
    }

    protected int preparedStatus() {
        if (this.actionType == 0) {
            return 6;
        }
        return 5;
    }

    protected int abortStatus() {
        return 4;
    }

    protected int commitStatus() {
        return 7;
    }

    protected int doPrepare(boolean reportHeuristics) throws IndexOutOfBoundsException {
        int p = 1;
        do {
            AbstractRecord rec;
            AbstractRecord abstractRecord = rec = this.pendingList != null ? this.pendingList.getFront() : null;
            if (rec == null) {
                throw new IndexOutOfBoundsException();
            }
            p = this.doPrepare(reportHeuristics, rec);
        } while (p == 0 || p == 2);
        return p;
    }

    protected int doPrepare(boolean reportHeuristics, AbstractRecord theRecord) throws IndexOutOfBoundsException {
        int p = 1;
        AbstractRecord record = theRecord;
        if (record != null) {
            int n = p = this.actionType == 0 ? record.topLevelPrepare() : record.nestedPrepare();
            if (p == 0) {
                record = this.insertRecord(this.preparedList, record);
            } else if (p == 2) {
                record = this.insertRecord(this.readonlyList, record);
            } else {
                if (p == 1 || p == 10 || !reportHeuristics) {
                    if (this.actionType == 1 && this.preparedList.size() > 0 && p == 10 && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_49", new Object[]{this.get_uid()});
                    }
                    record = this.insertRecord(this.pendingList, record);
                    record = null;
                    this.actionStatus = 5;
                    return p;
                }
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_50", new Object[]{this.get_uid(), TwoPhaseOutcome.stringForm(p)});
                }
                if (reportHeuristics) {
                    this.updateHeuristic(p, false);
                }
                record = this.insertRecord(this.heuristicList, record);
                if (this.heuristicDecision != 4) {
                    this.actionStatus = 5;
                    return 1;
                }
            }
        } else {
            throw new IndexOutOfBoundsException();
        }
        return p;
    }

    protected int doCommit(RecordList rl, boolean reportHeuristics) {
        if (rl != null && rl.size() > 0) {
            AbstractRecord rec;
            boolean pastFirstParticipant = false;
            block4: while ((rec = rl.getFront()) != null) {
                int outcome = this.doCommit(reportHeuristics, rec);
                switch (outcome) {
                    case 4: 
                    case 7: {
                        pastFirstParticipant = true;
                        continue block4;
                    }
                    default: {
                        pastFirstParticipant = true;
                        continue block4;
                    }
                    case 3: 
                }
                if (pastFirstParticipant) continue;
                pastFirstParticipant = true;
                int oldDecision = this.heuristicDecision;
                this.phase2Abort(reportHeuristics);
                this.heuristicDecision = oldDecision;
            }
        }
        return 7;
    }

    protected int doCommit(boolean reportHeuristics, AbstractRecord record) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::doCommit (" + record + ")");
        }
        int ok = 8;
        this.recordBeingHandled = record;
        if (this.recordBeingHandled != null) {
            if (this.actionType == 0) {
                ok = this.recordBeingHandled.topLevelCommit();
                if (ok == 7) {
                    this.recordBeingHandled = null;
                    this.updateHeuristic(7, true);
                } else {
                    if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                        tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_51", new Object[]{this.get_uid(), TwoPhaseOutcome.stringForm(ok), RecordType.typeToClass(this.recordBeingHandled.typeIs())});
                    }
                    if (reportHeuristics && (ok == 3 || ok == 4 || ok == 5 || ok == 6)) {
                        this.updateHeuristic(ok, true);
                        this.heuristicList.insert(this.recordBeingHandled);
                    } else if (ok == 9) {
                        this.updateHeuristic(6, true);
                    } else {
                        this.failedList.insert(this.recordBeingHandled);
                    }
                }
            } else {
                ok = this.recordBeingHandled.nestedCommit();
                if (this.recordBeingHandled.propagateOnCommit()) {
                    this.merge(this.recordBeingHandled);
                } else {
                    this.recordBeingHandled = null;
                }
            }
            if (ok != 7) {
                // empty if block
            }
        }
        return ok;
    }

    protected int doAbort(RecordList list_toprocess, boolean reportHeuristics) {
        if (list_toprocess != null && list_toprocess.size() > 0) {
            while ((this.recordBeingHandled = list_toprocess.getFront()) != null) {
                this.doAbort(reportHeuristics, this.recordBeingHandled);
            }
        }
        return 7;
    }

    protected int doAbort(boolean reportHeuristics, AbstractRecord record) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::doAbort (" + record + ")");
        }
        int ok = 7;
        this.recordBeingHandled = record;
        if (this.recordBeingHandled != null) {
            ok = this.actionType == 0 ? this.recordBeingHandled.topLevelAbort() : this.recordBeingHandled.nestedAbort();
            if (this.actionType != 0 && this.recordBeingHandled.propagateOnAbort()) {
                this.merge(this.recordBeingHandled);
            } else {
                if (ok == 7) {
                    this.updateHeuristic(7, false);
                } else if (reportHeuristics && (ok == 3 || ok == 4 || ok == 5 || ok == 6)) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        if (this.actionType == 0) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_52", new Object[]{this.get_uid(), TwoPhaseOutcome.stringForm(ok)});
                        } else {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_53", new Object[]{this.get_uid(), TwoPhaseOutcome.stringForm(ok)});
                        }
                    }
                    this.updateHeuristic(ok, false);
                    this.heuristicList.insert(this.recordBeingHandled);
                } else if (ok != 7 && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    if (this.actionType == 0) {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_54", new Object[]{this.get_uid(), TwoPhaseOutcome.stringForm(ok), RecordType.typeToClass(this.recordBeingHandled.typeIs())});
                    } else {
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_55", new Object[]{this.get_uid(), TwoPhaseOutcome.stringForm(ok), RecordType.typeToClass(this.recordBeingHandled.typeIs())});
                    }
                }
                this.recordBeingHandled = null;
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractRecord insertRecord(RecordList reclist, AbstractRecord record) {
        boolean lock = TxControl.asyncPrepare;
        if (lock) {
            RecordList recordList = reclist;
            synchronized (recordList) {
                if (!reclist.insert(record)) {
                    record = null;
                }
            }
        } else if (!reclist.insert(record)) {
            record = null;
        }
        return record;
    }

    protected boolean checkForCurrent() {
        return false;
    }

    protected final synchronized void updateHeuristic(int p, boolean commit) {
        if (p == 7) {
            if (TxStats.enabled()) {
                TxStats.getInstance().incrementHeuristics();
            }
            if (commit) {
                if (this.heuristicDecision == 0) {
                    p = 4;
                }
                if (this.heuristicDecision == 3) {
                    this.heuristicDecision = 5;
                }
            } else {
                if (this.heuristicDecision == 0) {
                    p = 3;
                }
                if (this.heuristicDecision == 4) {
                    this.heuristicDecision = 5;
                }
            }
        }
        switch (this.heuristicDecision) {
            case 0: {
                if (p == 0 || p == 7) break;
                this.heuristicDecision = p;
                break;
            }
            case 4: {
                if (p == 3 || p == 5) {
                    this.heuristicDecision = 5;
                    break;
                }
                if (p != 6) break;
                this.heuristicDecision = 6;
                break;
            }
            case 3: {
                if (p == 4 || p == 5) {
                    this.heuristicDecision = 5;
                    break;
                }
                if (p != 6) break;
                this.heuristicDecision = 6;
                break;
            }
            case 6: {
                if (p != 5) break;
                this.heuristicDecision = 5;
                break;
            }
            case 5: {
                break;
            }
            default: {
                this.heuristicDecision = p;
            }
        }
    }

    protected void updateState() {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::updateState() for action-id " + this.get_uid());
        }
        if (this.actionType == 0) {
            this.store();
            if (this.failedList != null && this.failedList.size() > 0 || this.heuristicList != null && this.heuristicList.size() > 0 || this.preparedList != null && this.preparedList.size() > 0) {
                String tn;
                Uid u = this.getSavingUid();
                OutputObjectState state = new OutputObjectState(u, tn = this.type());
                if (!this.save_state(state, 1)) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_64");
                }
                if (state.notempty()) {
                    try {
                        if (!this.currentStore.write_committed(u, tn, state)) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_65");
                        }
                    }
                    catch (ObjectStoreException e) {
                        tsLogger.arjLogger.warn(e);
                    }
                }
            } else {
                try {
                    if (this.savedIntentionList && this.currentStore.remove_committed(this.getSavingUid(), this.type())) {
                        this.savedIntentionList = false;
                    }
                }
                catch (ObjectStoreException e) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_70", new Object[]{e});
                }
            }
        }
    }

    private final void createPreparedLists() {
        if (this.preparedList == null) {
            this.preparedList = new RecordList();
        }
        if (this.readonlyList == null) {
            this.readonlyList = new RecordList();
        }
        if (this.failedList == null) {
            this.failedList = new RecordList();
        }
        if (this.heuristicList == null) {
            this.heuristicList = new RecordList();
        }
        if (this.pendingList == null) {
            this.pendingList = new RecordList();
        }
    }

    private final boolean checkIsCurrent() {
        boolean isCurrent = true;
        if (this.checkForCurrent()) {
            BasicAction currentAct = BasicAction.Current();
            if (currentAct != null && currentAct != this) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_56", new Object[]{currentAct.get_uid(), this.get_uid()});
                }
                isCurrent = false;
                if (currentAct.isAncestor(this.get_uid())) {
                    for (BasicAction parentAct = this.parent(); parentAct != null; parentAct = parentAct.parent()) {
                        parentAct.preventCommit();
                    }
                }
            }
            Object var2_2 = null;
        }
        return isCurrent;
    }

    private final boolean checkChildren(boolean isCommit) {
        boolean problem = false;
        if (this._childThreads != null && this._childThreads.size() > 0 && (this._childThreads.size() != 1 || this._childThreads.size() == 1 && !this._childThreads.contains(Thread.currentThread()))) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                if (isCommit) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_57", new Object[]{this.get_uid()});
                } else {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_58", new Object[]{this.get_uid()});
                }
            }
            if (this._checkedAction != null) {
                this._checkedAction.check(isCommit, this.get_uid(), this._childThreads);
            }
            this.removeAllChildThreads();
        }
        if (this._childActions != null && this._childActions.size() > 0) {
            problem = true;
            Enumeration iter = this._childActions.elements();
            BasicAction child = null;
            boolean printError = true;
            while (iter.hasMoreElements()) {
                child = (BasicAction)iter.nextElement();
                if (child.status() == 4) continue;
                if (printError) {
                    if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                        if (isCommit) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_59", new Object[]{this.get_uid()});
                        } else {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_60", new Object[]{this.get_uid()});
                        }
                    }
                    printError = false;
                }
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_61", new Object[]{child.get_uid()});
                }
                child.Abort();
                child = null;
            }
            iter = null;
            if (isCommit && tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_62", new Object[]{child != null ? child.get_uid() : "null"});
            }
        }
        return problem;
    }

    private final void removeAllChildThreads() {
        this.criticalStart();
        if (this._childThreads != null && this._childThreads.size() != 0) {
            Thread currentThread = Thread.currentThread();
            Enumeration iter = this._childThreads.elements();
            Thread t = null;
            while (iter.hasMoreElements()) {
                t = (Thread)iter.nextElement();
                if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                    tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_63", new Object[]{this.get_uid(), t});
                }
                if (t == currentThread) continue;
                ThreadActionData.purgeAction(this, t);
            }
        }
        this.criticalEnd();
    }

    private final void actionInitialise(BasicAction parent) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::actionInitialise() for action-id " + this.get_uid());
        }
        this.criticalStart();
        if (parent != null) {
            if (tsLogger.arjLoggerI18N.isDebugEnabled()) {
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_66", new Object[]{this.get_uid(), Integer.toString(parent.actionStatus)});
            }
            this.currentHierarchy = new ActionHierarchy(parent.getHierarchy());
        } else {
            this.currentHierarchy = new ActionHierarchy(5);
        }
        this.currentHierarchy.add(this.get_uid(), this.actionType);
        switch (this.actionType) {
            case 0: {
                if (parent == null || !tsLogger.arjLoggerI18N.isDebugEnabled()) break;
                tsLogger.arjLoggerI18N.debug("com.arjuna.ats.arjuna.coordinator.BasicAction_67", new Object[]{this.get_uid(), parent.get_uid()});
                break;
            }
            case 1: {
                if (parent != null) break;
                this.actionType = 0;
            }
        }
        this.parentAction = parent;
        this.criticalEnd();
    }

    private final void doForget(RecordList list_toprocess) {
        boolean force;
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::doForget (" + list_toprocess + ")");
        }
        boolean bl = force = this.heuristicDecision == 7;
        if ((!TxControl.maintainHeuristics || force) && list_toprocess.size() > 0) {
            RecordList tmpList = new RecordList();
            while ((this.recordBeingHandled = list_toprocess.getFront()) != null) {
                if (this.recordBeingHandled.forgetHeuristic()) {
                    this.recordBeingHandled = null;
                    continue;
                }
                tmpList.putFront(this.recordBeingHandled);
            }
            if (tmpList.size() > 0) {
                while ((this.recordBeingHandled = tmpList.getFront()) != null) {
                    list_toprocess.putFront(this.recordBeingHandled);
                }
            }
        }
    }

    private final void doCleanup(RecordList list_toprocess) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("BasicAction::doCleanup (" + list_toprocess + ")");
        }
        if (list_toprocess.size() > 0) {
            int ok = 7;
            while ((this.recordBeingHandled = list_toprocess.getFront()) != null) {
                ok = this.actionType == 0 ? this.recordBeingHandled.topLevelCleanup() : this.recordBeingHandled.nestedCleanup();
                if (this.actionType != 0 && this.recordBeingHandled.propagateOnAbort()) {
                    this.merge(this.recordBeingHandled);
                    continue;
                }
                if (ok != 7) {
                    // empty if block
                }
                this.recordBeingHandled = null;
            }
        }
    }

    private final synchronized boolean doOnePhase() {
        if (TxControl.onePhase) {
            return this.pendingList == null || this.pendingList.size() == 1;
        }
        return false;
    }

    private final synchronized void merge(AbstractRecord A) {
        int as = this.parentAction.add(A);
        if (as != 2) {
            A = null;
            if (as == 3) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_68");
            }
        }
    }
}

